/*
 * Decompiled with CFR 0.152.
 */
package com.plexpt.chatgpt;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.ContentType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plexpt.chatgpt.entity.chat.ChatCompletion;
import com.plexpt.chatgpt.entity.chat.Message;
import java.net.Proxy;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatGPTStream {
    private static final Logger log = LoggerFactory.getLogger(ChatGPTStream.class);
    private String apiKey;
    private List<String> apiKeyList;
    private OkHttpClient okHttpClient;
    private long timeout;
    private Proxy proxy;
    private String apiHost;

    public ChatGPTStream init() {
        OkHttpClient.Builder client = new OkHttpClient.Builder();
        client.connectTimeout(this.timeout, TimeUnit.SECONDS);
        client.writeTimeout(this.timeout, TimeUnit.SECONDS);
        client.readTimeout(this.timeout, TimeUnit.SECONDS);
        if (Objects.nonNull(this.proxy)) {
            client.proxy(this.proxy);
        }
        this.okHttpClient = client.build();
        return this;
    }

    public void streamChatCompletion(ChatCompletion chatCompletion, EventSourceListener eventSourceListener) {
        chatCompletion.setStream(true);
        try {
            EventSource.Factory factory = EventSources.createFactory((OkHttpClient)this.okHttpClient);
            ObjectMapper mapper = new ObjectMapper();
            String requestBody = mapper.writeValueAsString((Object)chatCompletion);
            String key = this.apiKey;
            if (this.apiKeyList != null && !this.apiKeyList.isEmpty()) {
                key = (String)RandomUtil.randomEle(this.apiKeyList);
            }
            Request request = new Request.Builder().url(this.apiHost + "v1/chat/completions").post(RequestBody.create((MediaType)MediaType.parse((String)ContentType.JSON.getValue()), (String)requestBody)).header("Authorization", "Bearer " + key).build();
            factory.newEventSource(request, eventSourceListener);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u51fa\u9519\uff1a{}", (Throwable)e);
        }
    }

    public void streamChatCompletion(List<Message> messages, EventSourceListener eventSourceListener) {
        ChatCompletion chatCompletion = ChatCompletion.builder().messages(messages).stream(true).build();
        this.streamChatCompletion(chatCompletion, eventSourceListener);
    }

    private static long $default$timeout() {
        return 90L;
    }

    private static Proxy $default$proxy() {
        return Proxy.NO_PROXY;
    }

    private static String $default$apiHost() {
        return "https://api.openai.com/";
    }

    public static ChatGPTStreamBuilder builder() {
        return new ChatGPTStreamBuilder();
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public List<String> getApiKeyList() {
        return this.apiKeyList;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setApiKeyList(List<String> apiKeyList) {
        this.apiKeyList = apiKeyList;
    }

    public void setOkHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setApiHost(String apiHost) {
        this.apiHost = apiHost;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatGPTStream)) {
            return false;
        }
        ChatGPTStream other = (ChatGPTStream)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        List<String> this$apiKeyList = this.getApiKeyList();
        List<String> other$apiKeyList = other.getApiKeyList();
        if (this$apiKeyList == null ? other$apiKeyList != null : !((Object)this$apiKeyList).equals(other$apiKeyList)) {
            return false;
        }
        OkHttpClient this$okHttpClient = this.getOkHttpClient();
        OkHttpClient other$okHttpClient = other.getOkHttpClient();
        if (this$okHttpClient == null ? other$okHttpClient != null : !this$okHttpClient.equals(other$okHttpClient)) {
            return false;
        }
        Proxy this$proxy = this.getProxy();
        Proxy other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !((Object)this$proxy).equals(other$proxy)) {
            return false;
        }
        String this$apiHost = this.getApiHost();
        String other$apiHost = other.getApiHost();
        return !(this$apiHost == null ? other$apiHost != null : !this$apiHost.equals(other$apiHost));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatGPTStream;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeout = this.getTimeout();
        result = result * 59 + (int)($timeout >>> 32 ^ $timeout);
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        List<String> $apiKeyList = this.getApiKeyList();
        result = result * 59 + ($apiKeyList == null ? 43 : ((Object)$apiKeyList).hashCode());
        OkHttpClient $okHttpClient = this.getOkHttpClient();
        result = result * 59 + ($okHttpClient == null ? 43 : $okHttpClient.hashCode());
        Proxy $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : ((Object)$proxy).hashCode());
        String $apiHost = this.getApiHost();
        result = result * 59 + ($apiHost == null ? 43 : $apiHost.hashCode());
        return result;
    }

    public String toString() {
        return "ChatGPTStream(apiKey=" + this.getApiKey() + ", apiKeyList=" + this.getApiKeyList() + ", okHttpClient=" + this.getOkHttpClient() + ", timeout=" + this.getTimeout() + ", proxy=" + this.getProxy() + ", apiHost=" + this.getApiHost() + ")";
    }

    public ChatGPTStream() {
        this.timeout = ChatGPTStream.$default$timeout();
        this.proxy = ChatGPTStream.$default$proxy();
        this.apiHost = ChatGPTStream.$default$apiHost();
    }

    public ChatGPTStream(String apiKey, List<String> apiKeyList, OkHttpClient okHttpClient, long timeout, Proxy proxy, String apiHost) {
        this.apiKey = apiKey;
        this.apiKeyList = apiKeyList;
        this.okHttpClient = okHttpClient;
        this.timeout = timeout;
        this.proxy = proxy;
        this.apiHost = apiHost;
    }

    public static class ChatGPTStreamBuilder {
        private String apiKey;
        private List<String> apiKeyList;
        private OkHttpClient okHttpClient;
        private boolean timeout$set;
        private long timeout$value;
        private boolean proxy$set;
        private Proxy proxy$value;
        private boolean apiHost$set;
        private String apiHost$value;

        ChatGPTStreamBuilder() {
        }

        public ChatGPTStreamBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public ChatGPTStreamBuilder apiKeyList(List<String> apiKeyList) {
            this.apiKeyList = apiKeyList;
            return this;
        }

        public ChatGPTStreamBuilder okHttpClient(OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
            return this;
        }

        public ChatGPTStreamBuilder timeout(long timeout) {
            this.timeout$value = timeout;
            this.timeout$set = true;
            return this;
        }

        public ChatGPTStreamBuilder proxy(Proxy proxy) {
            this.proxy$value = proxy;
            this.proxy$set = true;
            return this;
        }

        public ChatGPTStreamBuilder apiHost(String apiHost) {
            this.apiHost$value = apiHost;
            this.apiHost$set = true;
            return this;
        }

        public ChatGPTStream build() {
            long timeout$value = this.timeout$value;
            if (!this.timeout$set) {
                timeout$value = ChatGPTStream.$default$timeout();
            }
            Proxy proxy$value = this.proxy$value;
            if (!this.proxy$set) {
                proxy$value = ChatGPTStream.$default$proxy();
            }
            String apiHost$value = this.apiHost$value;
            if (!this.apiHost$set) {
                apiHost$value = ChatGPTStream.$default$apiHost();
            }
            return new ChatGPTStream(this.apiKey, this.apiKeyList, this.okHttpClient, timeout$value, proxy$value, apiHost$value);
        }

        public String toString() {
            return "ChatGPTStream.ChatGPTStreamBuilder(apiKey=" + this.apiKey + ", apiKeyList=" + this.apiKeyList + ", okHttpClient=" + this.okHttpClient + ", timeout$value=" + this.timeout$value + ", proxy$value=" + this.proxy$value + ", apiHost$value=" + this.apiHost$value + ")";
        }
    }
}

