/*
 * Decompiled with CFR 0.152.
 */
package com.github.monkeywie.proxyee.server;

import com.github.monkeywie.proxyee.crt.CertPool;
import com.github.monkeywie.proxyee.crt.CertUtil;
import com.github.monkeywie.proxyee.exception.HttpProxyExceptionHandle;
import com.github.monkeywie.proxyee.handler.HttpProxyServerHandle;
import com.github.monkeywie.proxyee.intercept.HttpProxyInterceptInitializer;
import com.github.monkeywie.proxyee.proxy.ProxyConfig;
import com.github.monkeywie.proxyee.server.HttpProxyCACertFactory;
import com.github.monkeywie.proxyee.server.HttpProxyServerConfig;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class HttpProxyServer {
    public static final HttpResponseStatus SUCCESS = new HttpResponseStatus(200, "Connection established");
    private HttpProxyCACertFactory caCertFactory;
    private HttpProxyServerConfig serverConfig;
    private HttpProxyInterceptInitializer proxyInterceptInitializer;
    private HttpProxyExceptionHandle httpProxyExceptionHandle;
    private ProxyConfig proxyConfig;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    private void init() {
        if (this.serverConfig == null) {
            this.serverConfig = new HttpProxyServerConfig();
        }
        this.serverConfig.setProxyLoopGroup((EventLoopGroup)new NioEventLoopGroup(this.serverConfig.getProxyGroupThreads()));
        if (this.serverConfig.isHandleSsl()) {
            try {
                PrivateKey caPriKey;
                X509Certificate caCert;
                this.serverConfig.setClientSslCtx(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build());
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (this.caCertFactory == null) {
                    caCert = CertUtil.loadCert(classLoader.getResourceAsStream("ca.crt"));
                    caPriKey = CertUtil.loadPriKey(classLoader.getResourceAsStream("ca_private.der"));
                } else {
                    caCert = this.caCertFactory.getCACert();
                    caPriKey = this.caCertFactory.getCAPriKey();
                }
                this.serverConfig.setIssuer(CertUtil.getSubject(caCert));
                this.serverConfig.setCaNotBefore(caCert.getNotBefore());
                this.serverConfig.setCaNotAfter(caCert.getNotAfter());
                this.serverConfig.setCaPriKey(caPriKey);
                KeyPair keyPair = CertUtil.genKeyPair();
                this.serverConfig.setServerPriKey(keyPair.getPrivate());
                this.serverConfig.setServerPubKey(keyPair.getPublic());
            }
            catch (Exception e) {
                this.serverConfig.setHandleSsl(false);
            }
        }
        if (this.proxyInterceptInitializer == null) {
            this.proxyInterceptInitializer = new HttpProxyInterceptInitializer();
        }
        if (this.httpProxyExceptionHandle == null) {
            this.httpProxyExceptionHandle = new HttpProxyExceptionHandle();
        }
    }

    public HttpProxyServer serverConfig(HttpProxyServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        return this;
    }

    public HttpProxyServer proxyInterceptInitializer(HttpProxyInterceptInitializer proxyInterceptInitializer) {
        this.proxyInterceptInitializer = proxyInterceptInitializer;
        return this;
    }

    public HttpProxyServer httpProxyExceptionHandle(HttpProxyExceptionHandle httpProxyExceptionHandle) {
        this.httpProxyExceptionHandle = httpProxyExceptionHandle;
        return this;
    }

    public HttpProxyServer proxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
        return this;
    }

    public HttpProxyServer caCertFactory(HttpProxyCACertFactory caCertFactory) {
        this.caCertFactory = caCertFactory;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int port) {
        this.init();
        this.bossGroup = new NioEventLoopGroup(this.serverConfig.getBossGroupThreads());
        this.workerGroup = new NioEventLoopGroup(this.serverConfig.getWorkerGroupThreads());
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast("httpCodec", (ChannelHandler)new HttpServerCodec());
                    ch.pipeline().addLast("serverHandle", (ChannelHandler)new HttpProxyServerHandle(HttpProxyServer.this.serverConfig, HttpProxyServer.this.proxyInterceptInitializer, HttpProxyServer.this.proxyConfig, HttpProxyServer.this.httpProxyExceptionHandle));
                }
            });
            ChannelFuture f = b.bind(port).sync();
            f.channel().closeFuture().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
        }
    }

    public void close() {
        this.serverConfig.getProxyLoopGroup().shutdownGracefully();
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        CertPool.clear();
    }
}

