/*
 * Decompiled with CFR 0.152.
 */
package com.github.monkeywie.proxyee.intercept.common;

import com.github.monkeywie.proxyee.intercept.HttpProxyIntercept;
import com.github.monkeywie.proxyee.intercept.HttpProxyInterceptPipeline;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;

public abstract class FullResponseIntercept
extends HttpProxyIntercept {
    private static final int defaultMaxContentLength = 0x800000;
    private int maxContentLength;

    public FullResponseIntercept() {
        this(0x800000);
    }

    public FullResponseIntercept(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    @Override
    public final void afterResponse(Channel clientChannel, Channel proxyChannel, HttpResponse httpResponse, HttpProxyInterceptPipeline pipeline) throws Exception {
        if (httpResponse instanceof FullHttpResponse) {
            FullHttpResponse fullHttpResponse = (FullHttpResponse)httpResponse;
            this.handelResponse(pipeline.getHttpRequest(), fullHttpResponse, pipeline);
            if (fullHttpResponse.headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
                httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)fullHttpResponse.content().readableBytes());
            }
            proxyChannel.pipeline().remove("decompress");
            proxyChannel.pipeline().remove("aggregator");
        } else if (this.match(pipeline.getHttpRequest(), pipeline.getHttpResponse(), pipeline)) {
            pipeline.resetAfterHead();
            proxyChannel.pipeline().addAfter("httpCodec", "decompress", (ChannelHandler)new HttpContentDecompressor());
            proxyChannel.pipeline().addAfter("decompress", "aggregator", (ChannelHandler)new HttpObjectAggregator(this.maxContentLength));
            proxyChannel.pipeline().fireChannelRead((Object)httpResponse);
            return;
        }
        pipeline.afterResponse(clientChannel, proxyChannel, httpResponse);
    }

    protected boolean isHtml(HttpRequest httpRequest, HttpResponse httpResponse) {
        String accept = httpRequest.headers().get((CharSequence)HttpHeaderNames.ACCEPT);
        String contentType = httpResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        return httpResponse.status().code() == 200 && accept != null && accept.matches("^.*text/html.*$") && contentType != null && contentType.matches("^text/html.*$");
    }

    public abstract boolean match(HttpRequest var1, HttpResponse var2, HttpProxyInterceptPipeline var3);

    public abstract void handelResponse(HttpRequest var1, FullHttpResponse var2, HttpProxyInterceptPipeline var3);
}

