/*
 * Decompiled with CFR 0.152.
 */
package com.github.monkeywie.proxyee.handler;

import com.github.monkeywie.proxyee.crt.CertPool;
import com.github.monkeywie.proxyee.exception.HttpProxyExceptionHandle;
import com.github.monkeywie.proxyee.handler.HttpProxyInitializer;
import com.github.monkeywie.proxyee.handler.TunnelProxyInitializer;
import com.github.monkeywie.proxyee.intercept.HttpProxyIntercept;
import com.github.monkeywie.proxyee.intercept.HttpProxyInterceptInitializer;
import com.github.monkeywie.proxyee.intercept.HttpProxyInterceptPipeline;
import com.github.monkeywie.proxyee.proxy.ProxyConfig;
import com.github.monkeywie.proxyee.proxy.ProxyHandleFactory;
import com.github.monkeywie.proxyee.server.HttpProxyServer;
import com.github.monkeywie.proxyee.server.HttpProxyServerConfig;
import com.github.monkeywie.proxyee.util.ProtoUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;

public class HttpProxyServerHandle
extends ChannelInboundHandlerAdapter {
    private ChannelFuture cf;
    private String host;
    private int port;
    private boolean isSsl = false;
    private int status = 0;
    private HttpProxyServerConfig serverConfig;
    private ProxyConfig proxyConfig;
    private HttpProxyInterceptInitializer interceptInitializer;
    private HttpProxyInterceptPipeline interceptPipeline;
    private HttpProxyExceptionHandle exceptionHandle;
    private List requestList;
    private boolean isConnect;

    public HttpProxyServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public HttpProxyInterceptPipeline getInterceptPipeline() {
        return this.interceptPipeline;
    }

    public HttpProxyExceptionHandle getExceptionHandle() {
        return this.exceptionHandle;
    }

    public HttpProxyServerHandle(HttpProxyServerConfig serverConfig, HttpProxyInterceptInitializer interceptInitializer, ProxyConfig proxyConfig, HttpProxyExceptionHandle exceptionHandle) {
        this.serverConfig = serverConfig;
        this.proxyConfig = proxyConfig;
        this.interceptInitializer = interceptInitializer;
        this.exceptionHandle = exceptionHandle;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            if (this.status == 0) {
                ProtoUtil.RequestProto requestProto = ProtoUtil.getRequestProto(request);
                if (requestProto == null) {
                    ctx.channel().close();
                    return;
                }
                this.status = 1;
                this.host = requestProto.getHost();
                this.port = requestProto.getPort();
                if ("CONNECT".equalsIgnoreCase(request.method().name())) {
                    this.status = 2;
                    DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpProxyServer.SUCCESS);
                    ctx.writeAndFlush((Object)response);
                    ctx.channel().pipeline().remove("httpCodec");
                    return;
                }
            }
            this.interceptPipeline = this.buildPipeline();
            this.interceptPipeline.setRequestProto(new ProtoUtil.RequestProto(this.host, this.port, this.isSsl));
            if (request.uri().indexOf("/") != 0) {
                URL url = new URL(request.uri());
                request.setUri(url.getFile());
            }
            this.interceptPipeline.beforeRequest(ctx.channel(), request);
        } else if (msg instanceof HttpContent) {
            if (this.status != 2) {
                this.interceptPipeline.beforeRequest(ctx.channel(), (HttpContent)msg);
            } else {
                ReferenceCountUtil.release((Object)msg);
                this.status = 1;
            }
        } else {
            ByteBuf byteBuf;
            if (this.serverConfig.isHandleSsl() && (byteBuf = (ByteBuf)msg).getByte(0) == 22) {
                this.isSsl = true;
                int port = ((InetSocketAddress)ctx.channel().localAddress()).getPort();
                SslContext sslCtx = SslContextBuilder.forServer((PrivateKey)this.serverConfig.getServerPriKey(), (X509Certificate[])new X509Certificate[]{CertPool.getCert(port, this.host, this.serverConfig)}).build();
                ctx.pipeline().addFirst("httpCodec", (ChannelHandler)new HttpServerCodec());
                ctx.pipeline().addFirst("sslHandle", (ChannelHandler)sslCtx.newHandler(ctx.alloc()));
                ctx.pipeline().fireChannelRead(msg);
                return;
            }
            this.handleProxyData(ctx.channel(), msg, false);
        }
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        if (this.cf != null) {
            this.cf.channel().close();
        }
        ctx.channel().close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.cf != null) {
            this.cf.channel().close();
        }
        ctx.channel().close();
        this.exceptionHandle.beforeCatch(ctx.channel(), cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProxyData(Channel channel, Object msg, boolean isHttp) throws Exception {
        if (this.cf == null) {
            if (isHttp && !(msg instanceof HttpRequest)) {
                return;
            }
            ProxyHandler proxyHandler = ProxyHandleFactory.build(this.proxyConfig);
            ProtoUtil.RequestProto requestProto = new ProtoUtil.RequestProto(this.host, this.port, this.isSsl);
            ChannelInitializer channelInitializer = isHttp ? new HttpProxyInitializer(channel, requestProto, proxyHandler) : new TunnelProxyInitializer(channel, proxyHandler);
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)bootstrap.group(this.serverConfig.getProxyLoopGroup())).channel(NioSocketChannel.class)).handler((ChannelHandler)channelInitializer);
            if (this.proxyConfig != null) {
                bootstrap.resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
            }
            this.requestList = new LinkedList();
            this.cf = bootstrap.connect(this.host, this.port);
            this.cf.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    future.channel().writeAndFlush(msg);
                    List list = this.requestList;
                    synchronized (list) {
                        this.requestList.forEach(obj -> future.channel().writeAndFlush(obj));
                        this.requestList.clear();
                        this.isConnect = true;
                    }
                } else {
                    this.requestList.forEach(obj -> ReferenceCountUtil.release((Object)obj));
                    this.requestList.clear();
                    future.channel().close();
                    channel.close();
                }
            }));
        } else {
            List list = this.requestList;
            synchronized (list) {
                if (this.isConnect) {
                    this.cf.channel().writeAndFlush(msg);
                } else {
                    this.requestList.add(msg);
                }
            }
        }
    }

    private HttpProxyInterceptPipeline buildPipeline() {
        HttpProxyInterceptPipeline interceptPipeline = new HttpProxyInterceptPipeline(new HttpProxyIntercept(){

            @Override
            public void beforeRequest(Channel clientChannel, HttpRequest httpRequest, HttpProxyInterceptPipeline pipeline) throws Exception {
                HttpProxyServerHandle.this.handleProxyData(clientChannel, httpRequest, true);
            }

            @Override
            public void beforeRequest(Channel clientChannel, HttpContent httpContent, HttpProxyInterceptPipeline pipeline) throws Exception {
                HttpProxyServerHandle.this.handleProxyData(clientChannel, httpContent, true);
            }

            @Override
            public void afterResponse(Channel clientChannel, Channel proxyChannel, HttpResponse httpResponse, HttpProxyInterceptPipeline pipeline) throws Exception {
                clientChannel.writeAndFlush((Object)httpResponse);
                if (HttpHeaderValues.WEBSOCKET.toString().equals(httpResponse.headers().get((CharSequence)HttpHeaderNames.UPGRADE))) {
                    proxyChannel.pipeline().remove("httpCodec");
                    clientChannel.pipeline().remove("httpCodec");
                }
            }

            @Override
            public void afterResponse(Channel clientChannel, Channel proxyChannel, HttpContent httpContent, HttpProxyInterceptPipeline pipeline) throws Exception {
                clientChannel.writeAndFlush((Object)httpContent);
            }
        });
        this.interceptInitializer.init(interceptPipeline);
        return interceptPipeline;
    }
}

