/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.utils;

import com.github.liaochong.myexcel.core.cache.Cache;
import com.github.liaochong.myexcel.core.cache.WeakCache;
import java.util.regex.Pattern;

public final class TdUtil {
    private static Pattern chineseOrCapitalPattern = Pattern.compile("[\u4e00-\u9fa5|A-Z]");
    private static Pattern digitalPattern = Pattern.compile("^\\d+$");
    private static Pattern nonDigitalPattern = Pattern.compile("[^\\d]+");
    private static final Cache<String, Integer> SPAN_CACHE = new WeakCache<String, Integer>();

    public static int get(int firstValue, int secondValue) {
        return firstValue > 0 ? secondValue + firstValue - 1 : secondValue;
    }

    public static int getSpan(String span) {
        Integer cacheResult = SPAN_CACHE.get(span);
        if (cacheResult != null) {
            return cacheResult;
        }
        if (!TdUtil.isSpanValid(span)) {
            SPAN_CACHE.cache(span, 0);
            return 0;
        }
        int result = Integer.parseInt(span);
        SPAN_CACHE.cache(span, result);
        return result;
    }

    public static boolean isSpanValid(String span) {
        return digitalPattern.matcher(span).find();
    }

    public static int getStringWidth(String s) {
        return TdUtil.getStringWidth(s, 0.0);
    }

    public static int getStringWidth(String s, double shift) {
        if (s == null) {
            return 1;
        }
        double valueLength = 1.0;
        double chineseOrCapitalShift = 1.0 + shift;
        double otherShift = 0.5 + shift;
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            String temp = s.substring(i, i + 1);
            if (chineseOrCapitalPattern.matcher(temp).find()) {
                valueLength += chineseOrCapitalShift;
                continue;
            }
            valueLength += otherShift;
        }
        return (int)Math.ceil(valueLength);
    }

    public static int getValue(String v) {
        if (v == null) {
            return -1;
        }
        String realValue = nonDigitalPattern.matcher(v).replaceAll("");
        return Integer.parseInt(realValue);
    }
}

