/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.parser;

import com.github.liaochong.myexcel.core.parser.ContentTypeEnum;
import com.github.liaochong.myexcel.utils.StringUtil;
import com.github.liaochong.myexcel.utils.StyleUtil;
import com.github.liaochong.myexcel.utils.TdUtil;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class StyleParser {
    private Map<String, String> globalTitleStyle = Collections.emptyMap();
    private Map<String, String> globalCommonStyle = Collections.emptyMap();
    private Map<String, String> globalEvenStyle = Collections.emptyMap();
    private Map<String, String> globalCellStyle = Collections.emptyMap();
    private Map<String, String> globalLinkStyle = Collections.emptyMap();
    private Map<String, Map<String, String>> eachColumnStyle = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> formatsStyleMap = new HashMap<String, Map<String, String>>();
    private Map<Integer, Integer> customWidthMap;
    private boolean isOddRow = true;
    private boolean noStyle;

    public StyleParser(Map<Integer, Integer> customWidthMap) {
        this.customWidthMap = customWidthMap;
    }

    public void parse(Set<String> styles) {
        if (this.noStyle) {
            return;
        }
        HashMap<String, String> styleMap = new HashMap<String, String>();
        styles.forEach(style -> {
            String[] splits = style.split("->");
            if (splits.length == 1) {
                styleMap.putIfAbsent("cell", "cell->" + style);
                return;
            }
            boolean appoint = splits[0].contains("&");
            if (appoint) {
                this.eachColumnStyle.put(splits[0], StyleUtil.parseStyle(splits[1]));
            } else {
                styleMap.putIfAbsent(splits[0], (String)style);
            }
        });
        this.globalTitleStyle = this.parseStyle(styleMap, "title");
        this.globalCommonStyle = this.parseStyle(styleMap, "odd");
        this.globalEvenStyle = this.parseStyle(styleMap, "even");
        this.globalCellStyle = this.parseStyle(styleMap, "cell");
        String linkStyle = (String)styleMap.get("link");
        if (linkStyle != null) {
            this.globalLinkStyle = StyleUtil.parseStyle(linkStyle.split("->")[1]);
        } else {
            this.globalLinkStyle = new HashMap<String, String>();
            this.globalLinkStyle.put("color", "blue");
            this.globalLinkStyle.put("text-decoration", "underline");
        }
    }

    private Map<String, String> parseStyle(Map<String, String> styleMap, String prefix) {
        String style = styleMap.get(prefix);
        return style == null ? Collections.emptyMap() : StyleUtil.parseStyle(style.split("->")[1]);
    }

    public void setColumnStyle(Field field, int fieldIndex, String ... columnStyles) {
        if (this.noStyle) {
            return;
        }
        this.setEachColumnStyle("title", fieldIndex, this.globalTitleStyle);
        this.setEachColumnStyle("even", fieldIndex, this.globalEvenStyle);
        this.setEachColumnStyle("odd", fieldIndex, this.globalCommonStyle);
        this.setEachColumnStyle("cell", fieldIndex, this.globalCellStyle);
        if (columnStyles == null) {
            return;
        }
        for (String columnStyle : columnStyles) {
            if (StringUtil.isBlank(columnStyle)) {
                throw new IllegalArgumentException("Illegal style,field:" + field.getName());
            }
            String[] splits = columnStyle.split("->");
            if (splits.length == 1) {
                this.setEachColumnStyle("cell", fieldIndex, StyleUtil.parseStyle(splits[0]));
                continue;
            }
            this.setEachColumnStyle(splits[0], fieldIndex, StyleUtil.parseStyle(splits[1]));
        }
    }

    private void setEachColumnStyle(String prefix, int fieldIndex, Map<String, String> styleMap) {
        if (styleMap == null || styleMap.isEmpty()) {
            return;
        }
        String stylePrefix = prefix + "&" + fieldIndex;
        Map<String, String> parentStyleMap = this.eachColumnStyle.get(stylePrefix);
        if (parentStyleMap == null || parentStyleMap.isEmpty()) {
            parentStyleMap = new HashMap<String, String>(styleMap);
            this.eachColumnStyle.put(stylePrefix, parentStyleMap);
        } else {
            parentStyleMap.putAll(styleMap);
        }
        this.setWidth(fieldIndex, parentStyleMap);
    }

    public Map<String, String> getTitleStyle(String styleKey) {
        if (this.noStyle) {
            return Collections.emptyMap();
        }
        return this.eachColumnStyle.getOrDefault(styleKey, this.globalTitleStyle);
    }

    public void toggle() {
        this.isOddRow = !this.isOddRow;
    }

    public Map<String, String> getCellStyle(int fieldIndex, ContentTypeEnum contentType, String format) {
        Map<String, String> style = Collections.emptyMap();
        if (!this.noStyle) {
            style = this.eachColumnStyle.get((this.isOddRow ? "odd&" : "even&") + fieldIndex);
            Map<String, String> cellStyleMap = this.eachColumnStyle.get("cell&" + fieldIndex);
            if (cellStyleMap != null) {
                if (style == null || style.isEmpty()) {
                    style = cellStyleMap;
                } else {
                    style = new HashMap<String, String>(style);
                    style.putAll(cellStyleMap);
                }
            }
            if (style == null && !this.globalCellStyle.isEmpty()) {
                style = this.globalCellStyle;
            }
            if (style == null) {
                Map<String, String> map = style = this.isOddRow ? this.globalCommonStyle : this.globalEvenStyle;
            }
            if (ContentTypeEnum.isLink(contentType)) {
                style = new HashMap<String, String>(style);
                style.putAll(this.globalLinkStyle);
            }
        }
        if (format != null) {
            style = this.getFormatStyle(format, fieldIndex, style);
        }
        return style;
    }

    private Map<String, String> getFormatStyle(String format, int fieldIndex, Map<String, String> style) {
        Map<String, String> formatStyle = this.formatsStyleMap.get(format + "_" + fieldIndex + "_" + (this.isOddRow ? "odd&" : "even&"));
        if (formatStyle == null) {
            formatStyle = new HashMap<String, String>(style);
            formatStyle.put("format", format);
            this.formatsStyleMap.put(format + "_" + fieldIndex, formatStyle);
        }
        return formatStyle;
    }

    private void setWidth(int fieldIndex, Map<String, String> styleMap) {
        String width = styleMap.get("width");
        if (width != null) {
            this.customWidthMap.put(fieldIndex, TdUtil.getValue(width));
        }
    }

    public void setCustomWidthMap(Map<Integer, Integer> customWidthMap) {
        this.customWidthMap = customWidthMap;
    }

    public void setNoStyle(boolean noStyle) {
        this.noStyle = noStyle;
    }
}

