/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter.reader;

import com.github.liaochong.myexcel.core.converter.ConvertContext;
import com.github.liaochong.myexcel.core.converter.reader.AbstractReadConverter;
import com.github.liaochong.myexcel.utils.RegexpUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberReadConverter<R extends Number>
extends AbstractReadConverter<R> {
    private static final Pattern PATTERN_ZERO = Pattern.compile("(.+)\\.0*");
    private Function<String, R> func;

    private NumberReadConverter(Function<String, R> func, boolean isInteger) {
        this.func = isInteger ? c -> {
            Matcher matcher = PATTERN_ZERO.matcher((CharSequence)c);
            boolean zeroSuffix = matcher.matches();
            return zeroSuffix ? (Number)((Number)func.apply(matcher.group(1))) : (Number)((Number)func.apply((String)c));
        } : func;
    }

    @Override
    protected R doConvert(String v, Field field, ConvertContext convertContext) {
        v = RegexpUtil.removeComma(v);
        BigDecimal bigDecimal = new BigDecimal(v);
        String realValue = bigDecimal.toPlainString();
        return (R)((Number)this.func.apply(realValue));
    }

    public static <R extends Number> NumberReadConverter<R> of(Function<String, R> func) {
        return new NumberReadConverter<R>(func, false);
    }

    public static <R extends Number> NumberReadConverter<R> of(Function<String, R> func, boolean isInteger) {
        return new NumberReadConverter<R>(func, isInteger);
    }
}

