/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.cache;

import com.github.liaochong.myexcel.core.cache.Cache;
import com.github.liaochong.myexcel.utils.RegexpUtil;
import com.github.liaochong.myexcel.utils.TempFileOperator;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class StringsCache
implements Cache<Integer, String> {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final int MAX_SIZE_PATH = 1000;
    private static final int MAX_PATH = 5;
    private final List<Path> cacheFiles = new ArrayList<Path>();
    private final LinkedHashMap<Integer, String[]> activeCache = new LinkedHashMap<Integer, String[]>(5, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 5;
        }
    };
    private String[] cacheValues;
    private int totalCount;
    private int index;

    public void init(int stringCount) {
        if (stringCount == 0) {
            return;
        }
        this.cacheValues = new String[Math.min(stringCount, 1000)];
    }

    @Override
    public void cache(Integer key, String value) {
        int cacheIndex = key - key / 1000 * 1000;
        if (cacheIndex >= this.cacheValues.length) {
            String[] resizeCache = new String[1000];
            System.arraycopy(this.cacheValues, 0, resizeCache, 0, this.cacheValues.length);
            this.cacheValues = resizeCache;
        }
        this.cacheValues[cacheIndex] = value;
        ++this.totalCount;
        if ((key + 1) % 1000 == 0) {
            if (this.index == 0) {
                String[] preCache = new String[1000];
                System.arraycopy(this.cacheValues, 0, preCache, 0, 1000);
                this.activeCache.put(0, preCache);
            }
            ++this.index;
            this.writeToFile();
        }
    }

    @Override
    public String get(Integer key) {
        int index;
        int route = key / 1000;
        String[] strings = this.activeCache.get(route);
        if (strings == null) {
            strings = this.getStrings(route);
            this.activeCache.put(route, strings);
        }
        return (index = key - route * 1000) >= strings.length ? "" : strings[index];
    }

    /*
     * Exception decompiling
     */
    private String[] getStrings(int route) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void finished() {
        if (this.index == 0) {
            this.activeCache.put(0, this.cacheValues);
            return;
        }
        int remainder = this.totalCount - this.index * 1000;
        if (remainder == 0) {
            this.cacheValues = null;
            return;
        }
        String[] temp = new String[remainder];
        System.arraycopy(this.cacheValues, 0, temp, 0, remainder);
        this.cacheValues = temp;
        this.writeToFile();
        this.cacheValues = null;
    }

    private void writeToFile() {
        Path file = TempFileOperator.createTempFile("s_c", ".data");
        this.cacheFiles.add(file);
        try {
            String content = Arrays.stream(this.cacheValues).filter(Objects::nonNull).map(RegexpUtil::escapeLineFeed).collect(Collectors.joining(LINE_SEPARATOR));
            Files.write(file, content.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clearAll() {
        TempFileOperator.deleteTempFiles(this.cacheFiles);
    }
}

