/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.CiConsumer;
import com.github.liaochong.myexcel.core.CiFunction;
import com.github.liaochong.myexcel.core.CsvReadHandler;
import com.github.liaochong.myexcel.core.HSSFMergeReadHandler;
import com.github.liaochong.myexcel.core.HSSFMetaDataSaxReadHandler;
import com.github.liaochong.myexcel.core.HSSFSaxReadHandler;
import com.github.liaochong.myexcel.core.ReadContext;
import com.github.liaochong.myexcel.core.ReadOnlySharedStringsTable;
import com.github.liaochong.myexcel.core.Row;
import com.github.liaochong.myexcel.core.RowContext;
import com.github.liaochong.myexcel.core.SheetMetaData;
import com.github.liaochong.myexcel.core.WorkbookMetaData;
import com.github.liaochong.myexcel.core.XSSFSaxReadHandler;
import com.github.liaochong.myexcel.core.XSSFSheetMergeXMLHandler;
import com.github.liaochong.myexcel.core.XSSFSheetMetaDataXMLHandler;
import com.github.liaochong.myexcel.core.XSSFSheetXMLHandler;
import com.github.liaochong.myexcel.core.cache.StringsCache;
import com.github.liaochong.myexcel.exception.ExcelReadException;
import com.github.liaochong.myexcel.exception.SaxReadException;
import com.github.liaochong.myexcel.exception.StopReadException;
import com.github.liaochong.myexcel.utils.TempFileOperator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SaxExcelReader<T> {
    private static final int DEFAULT_SHEET_INDEX = 0;
    private static final Logger log = LoggerFactory.getLogger(SaxExcelReader.class);
    private WorkbookMetaData workbookMetaData;
    private final List<T> result = new LinkedList<T>();
    private final ReadConfig<T> readConfig = new ReadConfig(0);

    private SaxExcelReader(Class<T> dataType) {
        this.readConfig.dataType = dataType;
    }

    public static <T> SaxExcelReader<T> of(Class<T> clazz) {
        return new SaxExcelReader<T>(clazz);
    }

    public SaxExcelReader<T> sheet(Integer sheetIndex) {
        return this.sheets(sheetIndex);
    }

    public SaxExcelReader<T> sheet(String sheetName) {
        return this.sheets(sheetName);
    }

    public SaxExcelReader<T> sheets(Integer ... sheetIndexs) {
        this.readConfig.sheetIndexs.clear();
        this.readConfig.sheetIndexs.addAll(Arrays.asList(sheetIndexs));
        return this;
    }

    public SaxExcelReader<T> sheets(String ... sheetNames) {
        this.readConfig.sheetNames.clear();
        this.readConfig.sheetNames.addAll(Arrays.asList(sheetNames));
        return this;
    }

    public SaxExcelReader<T> rowFilter(Predicate<Row> rowFilter) {
        this.readConfig.rowFilter = rowFilter;
        return this;
    }

    public SaxExcelReader<T> beanFilter(Predicate<T> beanFilter) {
        this.readConfig.beanFilter = beanFilter;
        return this;
    }

    @Deprecated
    public SaxExcelReader<T> charset(String charset) {
        this.readConfig.csvCharset = charset;
        return this;
    }

    public SaxExcelReader<T> csvCharset(String charset) {
        this.readConfig.csvCharset = charset;
        return this;
    }

    public SaxExcelReader<T> csvDelimiter(char delimiter) {
        this.readConfig.csvDelimiter = delimiter;
        return this;
    }

    public SaxExcelReader<T> exceptionally(BiFunction<Throwable, ReadContext, Boolean> exceptionFunction) {
        this.readConfig.exceptionFunction = exceptionFunction;
        return this;
    }

    public SaxExcelReader<T> noTrim() {
        this.readConfig.trim = v -> v;
        return this;
    }

    public SaxExcelReader<T> readAllSheet() {
        this.readConfig.readAllSheet = true;
        return this;
    }

    public SaxExcelReader<T> ignoreBlankRow() {
        this.readConfig.ignoreBlankRow = true;
        return this;
    }

    public SaxExcelReader<T> stopReadingOnBlankRow() {
        this.readConfig.stopReadingOnBlankRow = true;
        return this;
    }

    public SaxExcelReader<T> startSheet(BiConsumer<String, Integer> startSheetConsumer) {
        this.readConfig.startSheetConsumer = startSheetConsumer;
        return this;
    }

    public SaxExcelReader<T> detectedMerge() {
        this.readConfig.detectedMerge = true;
        return this;
    }

    public List<T> read(Path path) {
        this.doRead(path.toFile());
        return this.result;
    }

    public List<T> read(InputStream fileInputStream) {
        this.doRead(fileInputStream);
        return this.result;
    }

    public List<T> read(File file) {
        this.doRead(file);
        return this.result;
    }

    public void readThen(InputStream fileInputStream, Consumer<T> consumer) {
        this.readConfig.consumer = consumer;
        this.doRead(fileInputStream);
    }

    public void readThen(File file, Consumer<T> consumer) {
        this.readConfig.consumer = consumer;
        this.doRead(file);
    }

    public void readThen(Path path, Consumer<T> consumer) {
        this.readConfig.consumer = consumer;
        this.doRead(path.toFile());
    }

    public void readThen(InputStream fileInputStream, BiConsumer<T, RowContext> contextConsumer) {
        this.readConfig.contextConsumer = contextConsumer;
        this.doRead(fileInputStream);
    }

    public void readThen(File file, BiConsumer<T, RowContext> contextConsumer) {
        this.readConfig.contextConsumer = contextConsumer;
        this.doRead(file);
    }

    public void readThen(Path path, BiConsumer<T, RowContext> contextConsumer) {
        this.readConfig.contextConsumer = contextConsumer;
        this.doRead(path.toFile());
    }

    public void readThen(File file, BiFunction<T, RowContext, Boolean> contextFunction) {
        this.readConfig.contextFunction = contextFunction;
        this.doRead(file);
    }

    public void readThen(InputStream fileInputStream, BiFunction<T, RowContext, Boolean> contextFunction) {
        this.readConfig.contextFunction = contextFunction;
        this.doRead(fileInputStream);
    }

    public void readThen(Path path, BiFunction<T, RowContext, Boolean> contextFunction) {
        this.readConfig.contextFunction = contextFunction;
        this.doRead(path.toFile());
    }

    public void readThen(InputStream fileInputStream, Function<T, Boolean> function) {
        this.readConfig.function = function;
        this.doRead(fileInputStream);
    }

    public void readThen(File file, Function<T, Boolean> function) {
        this.readConfig.function = function;
        this.doRead(file);
    }

    public void readThen(Path path, Function<T, Boolean> function) {
        this.readConfig.function = function;
        this.doRead(path.toFile());
    }

    public static WorkbookMetaData getWorkbookMetaData(Path path) {
        SaxExcelReader saxExcelReader = new SaxExcelReader(null);
        super.doRead(path.toFile(), true);
        return saxExcelReader.workbookMetaData;
    }

    public static WorkbookMetaData getWorkbookMetaData(InputStream fileInputStream) {
        SaxExcelReader saxExcelReader = new SaxExcelReader(null);
        super.doRead(fileInputStream, true);
        return saxExcelReader.workbookMetaData;
    }

    public static WorkbookMetaData getWorkbookMetaData(File file) {
        SaxExcelReader saxExcelReader = new SaxExcelReader(null);
        super.doRead(file, true);
        return saxExcelReader.workbookMetaData;
    }

    private void doRead(InputStream fileInputStream) {
        this.doRead(fileInputStream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRead(InputStream fileInputStream, boolean readMetaData) {
        Path path = TempFileOperator.convertToFile(fileInputStream);
        try {
            this.doRead(path.toFile(), readMetaData);
        }
        finally {
            TempFileOperator.deleteTempFile(path);
        }
    }

    private void doRead(File file) {
        this.doRead(file, false);
    }

    private void doRead(File file, boolean readMetaData) {
        FileMagic fm;
        try (InputStream is = FileMagic.prepareToCheckMagic((InputStream)new FileInputStream(file));){
            fm = FileMagic.valueOf((InputStream)is);
        }
        catch (Throwable throwable) {
            throw new SaxReadException("Fail to get excel magic", throwable);
        }
        try {
            switch (fm) {
                case OOXML: {
                    this.doReadXlsx(file, readMetaData);
                    break;
                }
                case OLE2: {
                    this.doReadXls(file, readMetaData);
                    break;
                }
                default: {
                    if (readMetaData) {
                        throw new UnsupportedOperationException();
                    }
                    this.doReadCsv(file);
                    break;
                }
            }
        }
        catch (Throwable e) {
            throw new SaxReadException("Fail to read excel", e);
        }
    }

    private void doReadXls(File file, boolean readMetaData) {
        try {
            if (readMetaData) {
                this.workbookMetaData = new WorkbookMetaData();
                new HSSFMetaDataSaxReadHandler(file, this.workbookMetaData).process();
            } else {
                HashMap<Integer, Map<CellAddress, CellAddress>> mergeCellIndexMapping = new HashMap<Integer, Map<CellAddress, CellAddress>>();
                if (this.readConfig.detectedMerge) {
                    new HSSFMergeReadHandler(file, this.readConfig, mergeCellIndexMapping).process();
                }
                if (mergeCellIndexMapping.isEmpty()) {
                    this.readConfig.detectedMerge = false;
                }
                new HSSFSaxReadHandler<T>(file, this.result, this.readConfig, mergeCellIndexMapping).process();
            }
        }
        catch (StopReadException mergeCellIndexMapping) {
        }
        catch (IOException e) {
            throw new SaxReadException("Fail to read xls file:" + file.getName(), e);
        }
    }

    private void doReadXlsx(File file, boolean readMetaData) {
        try (OPCPackage p2 = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);){
            if (readMetaData) {
                this.processMetaData(p2);
            } else {
                this.process(p2);
            }
        }
        catch (StopReadException p2) {
        }
        catch (Exception e) {
            throw new SaxReadException("Fail to read xlsx file:" + file.getName(), e);
        }
    }

    private void doReadCsv(File file) {
        try {
            new CsvReadHandler<T>(Files.newInputStream(file.toPath(), new OpenOption[0]), this.readConfig, this.result).read();
        }
        catch (StopReadException stopReadException) {
        }
        catch (Throwable throwable) {
            throw new ExcelReadException("Fail to read csv file:" + file.getName(), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(OPCPackage xlsxPackage) throws IOException, OpenXML4JException, SAXException {
        long startTime = System.currentTimeMillis();
        Map<Integer, Map<CellAddress, CellAddress>> mergeCellIndexMapping = this.processMerge(xlsxPackage);
        StringsCache stringsCache = new StringsCache();
        try {
            ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(xlsxPackage, stringsCache);
            this.doReadSheet(xlsxPackage, (stream, index, sheetName) -> {
                this.readConfig.startSheetConsumer.accept((String)sheetName, (Integer)index);
                XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler(mergeCellIndexMapping.getOrDefault(index, Collections.emptyMap()), strings, new XSSFSaxReadHandler<T>(this.result, this.readConfig));
                this.processSheet(handler, (InputStream)stream);
                mergeCellIndexMapping.remove(index);
            });
        }
        finally {
            stringsCache.clearAll();
        }
        log.info("Sax import takes {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private Map<Integer, Map<CellAddress, CellAddress>> processMerge(OPCPackage xlsxPackage) throws IOException, OpenXML4JException {
        if (!this.readConfig.detectedMerge) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Map<CellAddress, CellAddress>> mergeCellIndexMapping = new HashMap<Integer, Map<CellAddress, CellAddress>>();
        this.doReadSheet(xlsxPackage, (stream, index, sheetName) -> {
            HashMap<CellAddress, CellAddress> mergeCellMapping = new HashMap<CellAddress, CellAddress>();
            this.processSheet(new XSSFSheetMergeXMLHandler(mergeCellMapping), (InputStream)stream);
            mergeCellIndexMapping.put((Integer)index, (Map<CellAddress, CellAddress>)mergeCellMapping);
        });
        if (mergeCellIndexMapping.isEmpty()) {
            this.readConfig.detectedMerge = false;
        }
        return mergeCellIndexMapping;
    }

    private void processMetaData(OPCPackage xlsxPackage) throws IOException, OpenXML4JException {
        this.workbookMetaData = new WorkbookMetaData();
        this.readConfig.readAllSheet = true;
        int lastIndex = this.doReadSheet(xlsxPackage, (stream, index, sheetName) -> {
            SheetMetaData sheetMetaData = new SheetMetaData((String)sheetName, (int)index);
            this.processSheet(new XSSFSheetMetaDataXMLHandler(sheetMetaData), (InputStream)stream);
            this.workbookMetaData.getSheetMetaDataList().add(sheetMetaData);
        });
        if (lastIndex > -1) {
            this.workbookMetaData.setSheetCount(lastIndex + 1);
        }
    }

    private int doReadSheet(OPCPackage xlsxPackage, CiConsumer<InputStream, Integer, String> ciConsumer) throws IOException, OpenXML4JException {
        XSSFReader.SheetIterator iter = this.getSheetIterator(xlsxPackage);
        CiFunction<InputStream, Integer, String, Boolean> acceptFunction = this.getSheetAcceptFunction();
        int index = -1;
        while (iter.hasNext()) {
            ++index;
            InputStream stream = iter.next();
            Throwable throwable = null;
            try {
                if (!acceptFunction.apply(stream, index, iter.getSheetName()).booleanValue()) continue;
                ciConsumer.accept(stream, index, iter.getSheetName());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
        return index;
    }

    private XSSFReader.SheetIterator getSheetIterator(OPCPackage xlsxPackage) throws IOException, OpenXML4JException {
        XSSFReader xssfReader = new XSSFReader(xlsxPackage);
        return (XSSFReader.SheetIterator)xssfReader.getSheetsData();
    }

    private CiFunction<InputStream, Integer, String, Boolean> getSheetAcceptFunction() {
        CiFunction<InputStream, Integer, String, Boolean> acceptFunction = (is, index, sheetName) -> true;
        if (this.readConfig.readAllSheet) {
            acceptFunction = (is, index, sheetName) -> true;
        } else if (!this.readConfig.sheetNames.isEmpty()) {
            acceptFunction = (is, index, sheetName) -> this.readConfig.sheetNames.contains(sheetName);
        } else if (!this.readConfig.sheetIndexs.isEmpty()) {
            acceptFunction = (is, index, sheetName) -> this.readConfig.sheetIndexs.contains(index);
        }
        return acceptFunction;
    }

    private void processSheet(ContentHandler handler, InputStream sheetInputStream) {
        try {
            XMLReader sheetParser = XMLHelper.newXMLReader();
            sheetParser.setContentHandler(handler);
            sheetParser.parse(new InputSource(sheetInputStream));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("SAX parser appears to be broken - " + e.getMessage());
        }
    }

    public static final class ReadConfig<T> {
        public Class<T> dataType;
        public Set<String> sheetNames = new HashSet<String>();
        public Set<Integer> sheetIndexs = new HashSet<Integer>();
        public Consumer<T> consumer;
        public BiConsumer<T, RowContext> contextConsumer;
        public Function<T, Boolean> function;
        public BiFunction<T, RowContext, Boolean> contextFunction;
        public Predicate<Row> rowFilter = row -> true;
        public Predicate<T> beanFilter = bean -> true;
        public BiFunction<Throwable, ReadContext, Boolean> exceptionFunction = (t, c) -> false;
        public String csvCharset = "UTF-8";
        public char csvDelimiter = (char)44;
        public Function<String, String> trim = v -> {
            if (v == null) {
                return v;
            }
            return v.trim();
        };
        public boolean readAllSheet;
        public boolean ignoreBlankRow = false;
        public boolean stopReadingOnBlankRow = false;
        public boolean detectedMerge;
        public BiConsumer<String, Integer> startSheetConsumer = (sheetName, sheetIndex) -> log.info("Start read excel, sheet:{},index:{}", sheetName, sheetIndex);

        public ReadConfig(int sheetIndex2) {
            this.sheetIndexs.add(sheetIndex2);
        }
    }
}

