/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractHSSFReadHandler;
import com.github.liaochong.myexcel.core.SaxExcelReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.MergeCellsRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.util.CellAddress;

class HSSFMergeReadHandler
extends AbstractHSSFReadHandler {
    private final Map<Integer, Map<CellAddress, CellAddress>> mergeCellIndexMapping;

    public HSSFMergeReadHandler(File file, SaxExcelReader.ReadConfig<?> readConfig, Map<Integer, Map<CellAddress, CellAddress>> mergeCellIndexMapping) throws IOException {
        this.readConfig = readConfig;
        this.mergeCellIndexMapping = mergeCellIndexMapping;
        this.fs = new POIFSFileSystem((InputStream)new FileInputStream(file));
    }

    public void processRecord(Record record) {
        switch (record.getSid()) {
            case 133: {
                this.boundSheetRecords.add((BoundSheetRecord)record);
                break;
            }
            case 2057: {
                BOFRecord br = (BOFRecord)record;
                if (br.getType() != 16) break;
                ++this.sheetIndex;
                if (this.orderedBSRs == null) {
                    this.orderedBSRs = BoundSheetRecord.orderByBofPosition((List)this.boundSheetRecords);
                }
                this.sheetName = this.orderedBSRs[this.sheetIndex].getSheetname();
                break;
            }
            case 229: {
                if (!this.isSelectedSheet()) {
                    return;
                }
                MergeCellsRecord mergeCellsRecord = (MergeCellsRecord)record;
                int numAreas = mergeCellsRecord.getNumAreas();
                HashMap<CellAddress, CellAddress> mergeCellMapping = new HashMap<CellAddress, CellAddress>();
                for (int i = 0; i < numAreas; ++i) {
                    Iterator iterator = mergeCellsRecord.getAreaAt(i).iterator();
                    CellAddress firstCellAddress = null;
                    while (iterator.hasNext()) {
                        CellAddress cellAddress = (CellAddress)iterator.next();
                        if (firstCellAddress == null) {
                            firstCellAddress = cellAddress;
                            continue;
                        }
                        mergeCellMapping.put(cellAddress, firstCellAddress);
                    }
                }
                this.mergeCellIndexMapping.put(this.sheetIndex, mergeCellMapping);
                break;
            }
        }
    }

    private boolean isSelectedSheet() {
        if (this.readConfig.readAllSheet) {
            return true;
        }
        if (!this.readConfig.sheetNames.isEmpty()) {
            return this.readConfig.sheetNames.contains(this.sheetName);
        }
        return this.readConfig.sheetIndexs.contains(this.sheetIndex);
    }
}

