/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractReadHandler;
import com.github.liaochong.myexcel.core.SaxExcelReader;
import com.github.liaochong.myexcel.exception.StopReadException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.input.BOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CsvReadHandler<T>
extends AbstractReadHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(CsvReadHandler.class);
    private final InputStream is;

    public CsvReadHandler(InputStream is, SaxExcelReader.ReadConfig<T> readConfig, List<T> result) {
        super(true, result, readConfig);
        this.is = is;
    }

    public void read() {
        if (this.is == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new BOMInputStream(this.is), this.readConfig.csvCharset);
             CSVParser parser = new CSVParser((Reader)reader, CSVFormat.EXCEL.withDelimiter(this.readConfig.csvDelimiter));){
            for (CSVRecord record : parser) {
                this.newRow((int)(record.getRecordNumber() - 1L));
                Iterator iterator = record.stream().iterator();
                int columnIndex = 0;
                while (iterator.hasNext()) {
                    String content = (String)iterator.next();
                    this.handleField(columnIndex++, content);
                }
                this.handleResult();
            }
            log.info("Sax import takes {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (StopReadException e) {
            log.info("Sax import takes {} ms", (Object)(System.currentTimeMillis() - startTime));
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

