/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.Cell;
import com.github.liaochong.myexcel.core.ExcelColumnMapping;
import com.github.liaochong.myexcel.core.ReadContext;
import com.github.liaochong.myexcel.core.Row;
import com.github.liaochong.myexcel.core.RowContext;
import com.github.liaochong.myexcel.core.SaxExcelReader;
import com.github.liaochong.myexcel.core.annotation.ExcelColumn;
import com.github.liaochong.myexcel.core.converter.ConvertContext;
import com.github.liaochong.myexcel.core.converter.ReadConverterContext;
import com.github.liaochong.myexcel.core.reflect.ClassFieldContainer;
import com.github.liaochong.myexcel.exception.StopReadException;
import com.github.liaochong.myexcel.utils.ConfigurationUtil;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import com.github.liaochong.myexcel.utils.StringUtil;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

abstract class AbstractReadHandler<T> {
    private Map<Integer, Field> fieldMap;
    private T obj;
    protected Map<Integer, Map<Integer, String>> titles = new LinkedHashMap<Integer, Map<Integer, String>>();
    protected SaxExcelReader.ReadConfig<T> readConfig;
    private final ReadContext<T> context = new ReadContext();
    private final RowContext rowContext = new RowContext();
    private final ConvertContext convertContext;
    private final Row currentRow = new Row(-1);
    private int prevColNum = -1;
    private Supplier<T> newInstance;
    private BiConsumer<Integer, String> fieldHandler;
    private Consumer<T> resultHandler;
    private BiConsumer<T, RowContext> contextResultHandler;
    private boolean readWithTitle;
    private int titleRowNum = -1;
    protected boolean isBlankRow;

    public AbstractReadHandler(boolean readCsv, List<T> result, SaxExcelReader.ReadConfig<T> readConfig) {
        this.convertContext = new ConvertContext(readCsv);
        Class dataType = readConfig.dataType;
        this.fieldMap = ReflectUtil.getFieldMapOfExcelColumn(dataType);
        this.readConfig = readConfig;
        boolean isMapType = dataType == Map.class;
        this.readWithTitle = !isMapType && this.fieldMap.isEmpty();
        this.setNewInstanceFunction(dataType, isMapType);
        this.setConfiguration(dataType, isMapType);
        this.setResultHandlerFunction(result, readConfig);
        this.setFieldHandlerFunction(isMapType);
    }

    private void setResultHandlerFunction(List<T> result, SaxExcelReader.ReadConfig<T> readConfig) {
        if (readConfig.consumer != null) {
            this.resultHandler = v -> readConfig.consumer.accept(v);
        } else if (readConfig.function != null) {
            this.resultHandler = v -> {
                Boolean noStop = readConfig.function.apply(v);
                if (!noStop.booleanValue()) {
                    throw new StopReadException();
                }
            };
        } else if (readConfig.contextConsumer != null) {
            this.contextResultHandler = (v, context) -> readConfig.contextConsumer.accept(v, (RowContext)context);
        } else if (readConfig.contextFunction != null) {
            this.contextResultHandler = (v, context) -> {
                Boolean noStop = readConfig.contextFunction.apply(v, (RowContext)context);
                if (!noStop.booleanValue()) {
                    throw new StopReadException();
                }
            };
        } else {
            this.resultHandler = result::add;
        }
    }

    private void setNewInstanceFunction(Class<T> dataType, boolean isMapType) {
        this.newInstance = isMapType ? () -> new LinkedHashMap() : () -> ReflectUtil.newInstance(dataType);
    }

    private void setConfiguration(Class<T> dataType, boolean isMapType) {
        if (isMapType) {
            return;
        }
        ClassFieldContainer classFieldContainer = ReflectUtil.getAllFieldsOfClass(dataType);
        ConfigurationUtil.parseConfiguration(classFieldContainer, this.convertContext.configuration);
        List<Field> fields = classFieldContainer.getFieldsByAnnotation(ExcelColumn.class);
        fields.forEach(field -> {
            ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
            if (excelColumn == null) {
                return;
            }
            ExcelColumnMapping mapping = ExcelColumnMapping.mapping(excelColumn);
            this.convertContext.excelColumnMappingMap.put((Field)field, mapping);
        });
    }

    private void setFieldHandlerFunction(boolean isMapType) {
        this.fieldHandler = isMapType ? (colNum, content) -> {
            for (int i = this.prevColNum + 1; i < colNum; ++i) {
                ((Map)this.obj).put(new Cell(this.currentRow.getRowNum(), i), null);
            }
            ((Map)this.obj).put(new Cell(this.currentRow.getRowNum(), (int)colNum), content);
            this.prevColNum = colNum;
        } : (colNum, content) -> {
            Field field = this.fieldMap.get(colNum);
            this.convert((String)content, this.currentRow.getRowNum(), (int)colNum, field);
        };
    }

    protected void convert(String value, int rowNum, int colNum, Field field) {
        if (value == null || field == null) {
            return;
        }
        this.context.reset(this.obj, field, value, rowNum, colNum);
        ReadConverterContext.convert(this.obj, this.context, this.convertContext, this.readConfig.exceptionFunction);
    }

    protected void newRow(int rowNum) {
        this.currentRow.setRowNum(rowNum);
        this.obj = this.newInstance.get();
        this.prevColNum = -1;
        this.isBlankRow = true;
    }

    protected void setRecordAsNull() {
        this.obj = null;
    }

    protected void handleField(Integer colNum, String content) {
        if (this.obj == null || colNum < 0) {
            return;
        }
        this.isBlankRow = false;
        content = this.readConfig.trim.apply(content);
        if (this.readConfig.rowFilter.test(this.currentRow)) {
            this.fieldHandler.accept(colNum, content);
        } else if (this.readWithTitle) {
            Row nextRow;
            Map rowMapping = this.titles.computeIfAbsent(this.currentRow.getRowNum(), rowNum -> new HashMap());
            rowMapping.put(colNum, content);
            if (this.titleRowNum == -1 && this.readConfig.rowFilter.test(nextRow = new Row(this.currentRow.getRowNum() + 1))) {
                this.titleRowNum = this.currentRow.getRowNum();
            }
        }
    }

    protected void handleResult() {
        if (this.isBlankRow) {
            if (this.readConfig.stopReadingOnBlankRow) {
                throw new StopReadException();
            }
            if (this.readConfig.ignoreBlankRow) {
                return;
            }
        }
        this.initFieldMap();
        if (!this.readConfig.rowFilter.test(this.currentRow)) {
            return;
        }
        if (!this.readConfig.beanFilter.test(this.obj)) {
            return;
        }
        if (this.readWithTitle && this.currentRow.getRowNum() == 0) {
            this.readWithTitle = false;
            return;
        }
        if (this.resultHandler != null) {
            this.resultHandler.accept(this.obj);
        } else {
            this.rowContext.setRowNum(this.currentRow.getRowNum());
            this.contextResultHandler.accept(this.obj, this.rowContext);
        }
    }

    private void initFieldMap() {
        if (this.currentRow.getRowNum() != this.titleRowNum || !this.fieldMap.isEmpty()) {
            return;
        }
        Map<String, Field> titleFieldMap = ReflectUtil.getFieldMapOfTitleExcelColumn(this.readConfig.dataType);
        this.fieldMap = new HashMap<Integer, Field>(titleFieldMap.size());
        List colNums = this.titles.values().stream().flatMap(t -> t.keySet().stream()).collect(Collectors.toList());
        int maxColNum = (Integer)Collections.max(colNums);
        Map<Integer, String> titleMapping = this.titles.get(this.titleRowNum);
        for (int i = 0; i <= maxColNum; ++i) {
            StringJoiner realTitle = new StringJoiner("->");
            int colNum = i;
            this.titles.keySet().forEach(rowNum -> {
                if (rowNum == this.titleRowNum) {
                    return;
                }
                Map<Integer, String> prevColMapping = this.titles.get(rowNum);
                int realColNum = colNum;
                while (true) {
                    String prevTitle;
                    if (StringUtil.isNotBlank(prevTitle = prevColMapping.get(realColNum))) {
                        realTitle.add(prevTitle);
                        return;
                    }
                    --realColNum;
                }
            });
            String title = titleMapping.get(i);
            if (StringUtil.isNotBlank(title)) {
                realTitle.add(title);
            }
            this.fieldMap.put(colNum, titleFieldMap.get(realTitle.toString()));
        }
        this.titles = null;
    }
}

