/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.druid.autoconfigure.properties;

import com.alibaba.druid.pool.DruidDataSource;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="spring.datasource.druid")
public class DruidDataSourceProperties {
    Map<String, DruidDataSource> dataSources = new HashMap<String, DruidDataSource>(16);
    @NestedConfigurationProperty
    DruidConfigFilterProperties config = new DruidConfigFilterProperties();
    @NestedConfigurationProperty
    DruidStatViewServletProperties statViewServlet = new DruidStatViewServletProperties();
    @NestedConfigurationProperty
    DruidWebStatProperties webStat = new DruidWebStatProperties();
    @NestedConfigurationProperty
    DruidAopStatProperties aopStat = new DruidAopStatProperties();

    public Map<String, DruidDataSource> getDataSources() {
        return this.dataSources;
    }

    public DruidConfigFilterProperties getConfig() {
        return this.config;
    }

    public DruidStatViewServletProperties getStatViewServlet() {
        return this.statViewServlet;
    }

    public DruidWebStatProperties getWebStat() {
        return this.webStat;
    }

    public DruidAopStatProperties getAopStat() {
        return this.aopStat;
    }

    public void setDataSources(Map<String, DruidDataSource> dataSources) {
        this.dataSources = dataSources;
    }

    public void setConfig(DruidConfigFilterProperties config) {
        this.config = config;
    }

    public void setStatViewServlet(DruidStatViewServletProperties statViewServlet) {
        this.statViewServlet = statViewServlet;
    }

    public void setWebStat(DruidWebStatProperties webStat) {
        this.webStat = webStat;
    }

    public void setAopStat(DruidAopStatProperties aopStat) {
        this.aopStat = aopStat;
    }

    public static class DruidAopStatProperties {
        private boolean enabled;
        private String[] patterns;

        public boolean isEnabled() {
            return this.enabled;
        }

        public String[] getPatterns() {
            return this.patterns;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setPatterns(String[] patterns) {
            this.patterns = patterns;
        }
    }

    public static class DruidWebStatProperties {
        private boolean enabled;
        private String urlPatterns = "/*";
        private String exclusions = "*.js,*.gif,*.jpg,*.png,*.css,*.ico,/druid/*";
        private boolean sessionStatEnable;
        private Integer sessionStatMaxCount = 1000;
        private String principalSessionName;
        private String principalCookieName;
        private boolean profileEnable = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getUrlPatterns() {
            return this.urlPatterns;
        }

        public String getExclusions() {
            return this.exclusions;
        }

        public boolean isSessionStatEnable() {
            return this.sessionStatEnable;
        }

        public Integer getSessionStatMaxCount() {
            return this.sessionStatMaxCount;
        }

        public String getPrincipalSessionName() {
            return this.principalSessionName;
        }

        public String getPrincipalCookieName() {
            return this.principalCookieName;
        }

        public boolean isProfileEnable() {
            return this.profileEnable;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setUrlPatterns(String urlPatterns) {
            this.urlPatterns = urlPatterns;
        }

        public void setExclusions(String exclusions) {
            this.exclusions = exclusions;
        }

        public void setSessionStatEnable(boolean sessionStatEnable) {
            this.sessionStatEnable = sessionStatEnable;
        }

        public void setSessionStatMaxCount(Integer sessionStatMaxCount) {
            this.sessionStatMaxCount = sessionStatMaxCount;
        }

        public void setPrincipalSessionName(String principalSessionName) {
            this.principalSessionName = principalSessionName;
        }

        public void setPrincipalCookieName(String principalCookieName) {
            this.principalCookieName = principalCookieName;
        }

        public void setProfileEnable(boolean profileEnable) {
            this.profileEnable = profileEnable;
        }
    }

    public static class DruidStatViewServletProperties {
        private boolean enabled;
        private String urlMappings = "/druid/*";
        private String loginUsername;
        private String loginPassword;
        private String allow;
        private String deny;
        private boolean resetEnable;

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getUrlMappings() {
            return this.urlMappings;
        }

        public String getLoginUsername() {
            return this.loginUsername;
        }

        public String getLoginPassword() {
            return this.loginPassword;
        }

        public String getAllow() {
            return this.allow;
        }

        public String getDeny() {
            return this.deny;
        }

        public boolean isResetEnable() {
            return this.resetEnable;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setUrlMappings(String urlMappings) {
            this.urlMappings = urlMappings;
        }

        public void setLoginUsername(String loginUsername) {
            this.loginUsername = loginUsername;
        }

        public void setLoginPassword(String loginPassword) {
            this.loginPassword = loginPassword;
        }

        public void setAllow(String allow) {
            this.allow = allow;
        }

        public void setDeny(String deny) {
            this.deny = deny;
        }

        public void setResetEnable(boolean resetEnable) {
            this.resetEnable = resetEnable;
        }
    }

    public static class DruidConfigFilterProperties {
        private boolean enabled;
        private String file;
        private String key;

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getFile() {
            return this.file;
        }

        public String getKey() {
            return this.key;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public void setKey(String key) {
            this.key = key;
        }
    }

    public static class DruidConstants {
        public static final String DRUID_DATA_SOURCE_PREFIX = "spring.datasource.druid";
        public static final String DRUID_STAT_FILTER_PREFIX = "spring.datasource.druid.stat";
        public static final String DRUID_WALL_FILTER_PREFIX = "spring.datasource.druid.wall";
        public static final String DRUID_WALL_CONFIG_PREFIX = "spring.datasource.druid.wall.config";
        public static final String DRUID_SLF4J_FILTER_PREFIX = "spring.datasource.druid.slf4j";
        public static final String DRUID_LOG4J_FILTER_PREFIX = "spring.datasource.druid.log4j";
        public static final String DRUID_LOG4J2_FILTER_PREFIX = "spring.datasource.druid.log4j2";
        public static final String DRUID_COMMONS_LOG_FILTER_PREFIX = "spring.datasource.druid.commons-log";
        public static final String DRUID_CONFIG_FILTER_PREFIX = "spring.datasource.druid.config";
        public static final String DRUID_STAT_VIEW_SERVLET_PREFIX = "spring.datasource.druid.stat-view-servlet";
        public static final String DRUID_WEB_STAT_PREFIX = "spring.datasource.druid.web-stat";
        public static final String DRUID_AOP_STAT_PREFIX = "spring.datasource.druid.aop-stat";
    }
}

