/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.okhttp;

import com.github.dockerjava.okhttp.OkHttpInvocationBuilder;
import com.sun.jna.platform.win32.Kernel32;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import javax.net.SocketFactory;

class NamedPipeSocketFactory
extends SocketFactory {
    final String socketFileName;

    NamedPipeSocketFactory(String socketFileName) {
        this.socketFileName = socketFileName;
    }

    @Override
    public Socket createSocket() {
        return new Socket(){
            RandomAccessFile file;
            InputStream is;
            OutputStream os;

            @Override
            public void close() throws IOException {
                if (this.file != null) {
                    this.file.close();
                    this.file = null;
                }
            }

            @Override
            public void connect(SocketAddress endpoint) {
                this.connect(endpoint, 0);
            }

            @Override
            public void connect(SocketAddress endpoint, int timeout) {
                long startedAt = System.currentTimeMillis();
                timeout = Math.max(timeout, 10000);
                while (true) {
                    try {
                        this.file = new RandomAccessFile(NamedPipeSocketFactory.this.socketFileName, "rw");
                    }
                    catch (FileNotFoundException e) {
                        if (System.currentTimeMillis() - startedAt >= (long)timeout) {
                            throw new RuntimeException(e);
                        }
                        Kernel32.INSTANCE.WaitNamedPipe(NamedPipeSocketFactory.this.socketFileName, 100);
                        continue;
                    }
                    break;
                }
                this.is = new InputStream(){

                    @Override
                    public int read(byte[] bytes, int off, int len) throws IOException {
                        if (OkHttpInvocationBuilder.CLOSING.get().booleanValue()) {
                            return 0;
                        }
                        return file.read(bytes, off, len);
                    }

                    @Override
                    public int read() throws IOException {
                        if (OkHttpInvocationBuilder.CLOSING.get().booleanValue()) {
                            return 0;
                        }
                        return file.read();
                    }

                    @Override
                    public int read(byte[] bytes) throws IOException {
                        if (OkHttpInvocationBuilder.CLOSING.get().booleanValue()) {
                            return 0;
                        }
                        return file.read(bytes);
                    }
                };
                this.os = new OutputStream(){

                    @Override
                    public void write(byte[] bytes, int off, int len) throws IOException {
                        file.write(bytes, off, len);
                    }

                    @Override
                    public void write(int value) throws IOException {
                        file.write(value);
                    }

                    @Override
                    public void write(byte[] bytes) throws IOException {
                        file.write(bytes);
                    }
                };
            }

            @Override
            public InputStream getInputStream() {
                return this.is;
            }

            @Override
            public OutputStream getOutputStream() {
                return this.os;
            }
        };
    }

    @Override
    public Socket createSocket(String s, int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) {
        throw new UnsupportedOperationException();
    }
}

