/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.okhttp;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.StreamType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Consumer;
import okio.BufferedSource;

class FramedSink
implements Consumer<BufferedSource> {
    private static final int HEADER_SIZE = 8;
    private final ResultCallback<Frame> resultCallback;

    FramedSink(ResultCallback<Frame> resultCallback) {
        this.resultCallback = resultCallback;
    }

    @Override
    public void accept(BufferedSource source) {
        try {
            while (true) {
                try {
                    if (source.exhausted()) {
                    }
                }
                catch (IOException e) {}
                break;
                if (!source.request(8L)) {
                    return;
                }
                byte[] bytes = source.readByteArray(8L);
                StreamType streamType = FramedSink.streamType(bytes[0]);
                if (streamType == StreamType.RAW) {
                    this.resultCallback.onNext((Object)new Frame(StreamType.RAW, bytes));
                    byte[] buffer = new byte[1024];
                    while (!source.exhausted()) {
                        int readBytes = source.read(buffer);
                        if (readBytes == -1) continue;
                        this.resultCallback.onNext((Object)new Frame(StreamType.RAW, Arrays.copyOf(buffer, readBytes)));
                    }
                    return;
                }
                int payloadSize = ByteBuffer.wrap(bytes, 4, 4).getInt();
                if (!source.request((long)payloadSize)) {
                    return;
                }
                byte[] payload = source.readByteArray((long)payloadSize);
                this.resultCallback.onNext((Object)new Frame(streamType, payload));
            }
        }
        catch (Exception e) {
            this.resultCallback.onError((Throwable)e);
        }
    }

    private static StreamType streamType(byte streamType) {
        switch (streamType) {
            case 0: {
                return StreamType.STDIN;
            }
            case 1: {
                return StreamType.STDOUT;
            }
            case 2: {
                return StreamType.STDERR;
            }
        }
        return StreamType.RAW;
    }
}

