/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.profitsharing.request;

import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Map;
import me.chanjar.weixin.common.annotation.Required;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="xml")
public class ProfitSharingReturnRequest
extends BaseWxPayRequest {
    private static final long serialVersionUID = 5926280401474809744L;
    @XStreamAlias(value="order_id")
    private String orderId;
    @XStreamAlias(value="out_order_no")
    private String outOrderNo;
    @Required
    @XStreamAlias(value="out_return_no")
    private String outReturnNo;
    @Required
    @XStreamAlias(value="return_account_type")
    private String returnAccountType;
    @Required
    @XStreamAlias(value="return_account")
    private String returnAccount;
    @Required
    @XStreamAlias(value="return_amount")
    private Integer returnAmount;
    @Required
    @XStreamAlias(value="description")
    private String description;

    @Override
    protected void checkConstraints() throws WxPayException {
        if (StringUtils.isBlank((CharSequence)this.orderId) && StringUtils.isBlank((CharSequence)this.outOrderNo)) {
            throw new WxPayException("order_id \u548c outOrderNo \u5fc5\u987b\u6709\u4e00\u4e2a\u5b58\u5728");
        }
        this.setSignType("HMAC-SHA256");
    }

    @Override
    protected void storeMap(Map<String, String> map) {
        map.put("order_id", this.orderId);
        map.put("out_order_no", this.outOrderNo);
        map.put("out_return_no", this.outReturnNo);
        map.put("return_account_type", this.returnAccountType);
        map.put("return_account", this.returnAccount);
        map.put("return_amount", this.returnAmount.toString());
        map.put("description", this.description);
    }

    public static ProfitSharingReturnRequestBuilder newBuilder() {
        return new ProfitSharingReturnRequestBuilder();
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getOutOrderNo() {
        return this.outOrderNo;
    }

    public String getOutReturnNo() {
        return this.outReturnNo;
    }

    public String getReturnAccountType() {
        return this.returnAccountType;
    }

    public String getReturnAccount() {
        return this.returnAccount;
    }

    public Integer getReturnAmount() {
        return this.returnAmount;
    }

    public String getDescription() {
        return this.description;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setOutOrderNo(String outOrderNo) {
        this.outOrderNo = outOrderNo;
    }

    public void setOutReturnNo(String outReturnNo) {
        this.outReturnNo = outReturnNo;
    }

    public void setReturnAccountType(String returnAccountType) {
        this.returnAccountType = returnAccountType;
    }

    public void setReturnAccount(String returnAccount) {
        this.returnAccount = returnAccount;
    }

    public void setReturnAmount(Integer returnAmount) {
        this.returnAmount = returnAmount;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return "ProfitSharingReturnRequest(orderId=" + this.getOrderId() + ", outOrderNo=" + this.getOutOrderNo() + ", outReturnNo=" + this.getOutReturnNo() + ", returnAccountType=" + this.getReturnAccountType() + ", returnAccount=" + this.getReturnAccount() + ", returnAmount=" + this.getReturnAmount() + ", description=" + this.getDescription() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProfitSharingReturnRequest)) {
            return false;
        }
        ProfitSharingReturnRequest other = (ProfitSharingReturnRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$returnAmount = this.getReturnAmount();
        Integer other$returnAmount = other.getReturnAmount();
        if (this$returnAmount == null ? other$returnAmount != null : !((Object)this$returnAmount).equals(other$returnAmount)) {
            return false;
        }
        String this$orderId = this.getOrderId();
        String other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
            return false;
        }
        String this$outOrderNo = this.getOutOrderNo();
        String other$outOrderNo = other.getOutOrderNo();
        if (this$outOrderNo == null ? other$outOrderNo != null : !this$outOrderNo.equals(other$outOrderNo)) {
            return false;
        }
        String this$outReturnNo = this.getOutReturnNo();
        String other$outReturnNo = other.getOutReturnNo();
        if (this$outReturnNo == null ? other$outReturnNo != null : !this$outReturnNo.equals(other$outReturnNo)) {
            return false;
        }
        String this$returnAccountType = this.getReturnAccountType();
        String other$returnAccountType = other.getReturnAccountType();
        if (this$returnAccountType == null ? other$returnAccountType != null : !this$returnAccountType.equals(other$returnAccountType)) {
            return false;
        }
        String this$returnAccount = this.getReturnAccount();
        String other$returnAccount = other.getReturnAccount();
        if (this$returnAccount == null ? other$returnAccount != null : !this$returnAccount.equals(other$returnAccount)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProfitSharingReturnRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $returnAmount = this.getReturnAmount();
        result = result * 59 + ($returnAmount == null ? 43 : ((Object)$returnAmount).hashCode());
        String $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
        String $outOrderNo = this.getOutOrderNo();
        result = result * 59 + ($outOrderNo == null ? 43 : $outOrderNo.hashCode());
        String $outReturnNo = this.getOutReturnNo();
        result = result * 59 + ($outReturnNo == null ? 43 : $outReturnNo.hashCode());
        String $returnAccountType = this.getReturnAccountType();
        result = result * 59 + ($returnAccountType == null ? 43 : $returnAccountType.hashCode());
        String $returnAccount = this.getReturnAccount();
        result = result * 59 + ($returnAccount == null ? 43 : $returnAccount.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public ProfitSharingReturnRequest() {
    }

    public ProfitSharingReturnRequest(String orderId, String outOrderNo, String outReturnNo, String returnAccountType, String returnAccount, Integer returnAmount, String description) {
        this.orderId = orderId;
        this.outOrderNo = outOrderNo;
        this.outReturnNo = outReturnNo;
        this.returnAccountType = returnAccountType;
        this.returnAccount = returnAccount;
        this.returnAmount = returnAmount;
        this.description = description;
    }

    public static class ProfitSharingReturnRequestBuilder {
        private String orderId;
        private String outOrderNo;
        private String outReturnNo;
        private String returnAccountType;
        private String returnAccount;
        private Integer returnAmount;
        private String description;

        ProfitSharingReturnRequestBuilder() {
        }

        public ProfitSharingReturnRequestBuilder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public ProfitSharingReturnRequestBuilder outOrderNo(String outOrderNo) {
            this.outOrderNo = outOrderNo;
            return this;
        }

        public ProfitSharingReturnRequestBuilder outReturnNo(String outReturnNo) {
            this.outReturnNo = outReturnNo;
            return this;
        }

        public ProfitSharingReturnRequestBuilder returnAccountType(String returnAccountType) {
            this.returnAccountType = returnAccountType;
            return this;
        }

        public ProfitSharingReturnRequestBuilder returnAccount(String returnAccount) {
            this.returnAccount = returnAccount;
            return this;
        }

        public ProfitSharingReturnRequestBuilder returnAmount(Integer returnAmount) {
            this.returnAmount = returnAmount;
            return this;
        }

        public ProfitSharingReturnRequestBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ProfitSharingReturnRequest build() {
            return new ProfitSharingReturnRequest(this.orderId, this.outOrderNo, this.outReturnNo, this.returnAccountType, this.returnAccount, this.returnAmount, this.description);
        }

        public String toString() {
            return "ProfitSharingReturnRequest.ProfitSharingReturnRequestBuilder(orderId=" + this.orderId + ", outOrderNo=" + this.outOrderNo + ", outReturnNo=" + this.outReturnNo + ", returnAccountType=" + this.returnAccountType + ", returnAccount=" + this.returnAccount + ", returnAmount=" + this.returnAmount + ", description=" + this.description + ")";
        }
    }
}

