/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.javafile.template;

import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.generator.database.config.impl.RelationConfig;
import cn.org.atool.generator.database.model.Naming;
import cn.org.atool.generator.database.model.TableField;
import cn.org.atool.generator.database.model.TableSetter;
import cn.org.atool.generator.javafile.template.AbstractTemplateFile;
import cn.org.atool.generator.util.ClassNames;
import cn.org.atool.generator.util.GeneratorHelper;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Modifier;

public class EntityFile
extends AbstractTemplateFile {
    private static final Set<String> Allow_Entity_Bounds = new HashSet<String>();

    public EntityFile(TableSetter table) {
        super(table);
        this.packageName = EntityFile.entityPackage(table);
        this.klassName = EntityFile.entityClass(table);
    }

    public static TypeName entityName(TableSetter table) {
        return ClassName.get((String)EntityFile.entityPackage(table), (String)EntityFile.entityClass(table), (String[])new String[0]);
    }

    public static String entityPackage(TableSetter table) {
        return table.gc().getBasePackage() + ".entity";
    }

    public static String entityClass(TableSetter table) {
        String entityPrefix = table.getEntityPrefix();
        if (entityPrefix.endsWith(table.getEntitySuffix())) {
            return entityPrefix;
        }
        return entityPrefix + table.getEntitySuffix();
    }

    @Override
    protected void build(TypeSpec.Builder spec) {
        spec.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "{$S, $S}", new Object[]{"rawtypes", "unchecked"}).build());
        if (this.table.gc().isLombok()) {
            spec.addAnnotation(ClassNames.Lombok_Data);
            if (this.table.gc().isSetterChain()) {
                spec.addAnnotation(AnnotationSpec.builder((ClassName)ClassNames.Lombok_Accessors).addMember("chain", "true", new Object[0]).build());
            }
            spec.addAnnotation(AnnotationSpec.builder((ClassName)ClassNames.Lombok_EqualsAndHashCode).addMember("callSuper", "false", new Object[0]).build());
            spec.addAnnotation(ClassNames.Lombok_AllArgsConstructor);
            spec.addAnnotation(ClassNames.Lombok_NoArgsConstructor);
            spec.addAnnotation(ClassNames.Lombok_Builder);
        }
        spec.addAnnotation(this.fluentMybatisAnnotation()).addJavadoc("$T: \u6570\u636e\u6620\u5c04\u5b9e\u4f53\u5b9a\u4e49\n\n", new Object[]{super.className()}).addJavadoc("$L", new Object[]{"@author Powered By Fluent Mybatis"});
        if (this.table.gc().isRichEntity()) {
            spec.superclass((TypeName)ClassNames.FM_RichEntity);
        } else {
            spec.superclass((TypeName)ClassNames.FM_BaseEntity);
        }
        this.addSuperInterface(spec, this.table.getEntityInterfaces());
        spec.addField(FieldSpec.builder(Long.TYPE, (String)"serialVersionUID", (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.FINAL, Modifier.PRIVATE}).initializer("1L", new Object[0]).build());
        for (TableField field : this.table.getFields()) {
            FieldSpec.Builder fb = FieldSpec.builder((TypeName)field.getJavaType(), (String)field.getName(), (Modifier[])new Modifier[]{Modifier.PRIVATE});
            if (field.isPrimary() && !"user".equals(this.table.getSeqName())) {
                fb.addAnnotation(this.getTableIdAnnotation(field));
            } else {
                fb.addAnnotation(this.getTableFieldAnnotation(field));
            }
            if (Objects.equals(field.getColumnName(), this.table.getLogicDeleted())) {
                fb.addAnnotation(ClassNames.FM_LogicDelete);
            }
            if (Objects.equals(field.getColumnName(), this.table.getVersionField())) {
                fb.addAnnotation(ClassNames.FM_Version);
            }
            spec.addField(fb.build());
            if (this.table.gc().isLombok()) continue;
            String capital = Naming.capitalFirst(field.getName());
            spec.addMethod(this.m_getter(capital, field));
            spec.addMethod(this.m_setter(capital, field, this.table.gc().isSetterChain()));
        }
        spec.addMethod(this.m_entityClass());
        for (RelationConfig relation : this.table.getRelations()) {
            spec.addMethod(this.m_relation(relation));
        }
    }

    private MethodSpec m_getter(String capital, TableField field) {
        return MethodSpec.methodBuilder((String)("get" + capital)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(field.getJavaType()).addStatement("return this.$L", new Object[]{field.getName()}).build();
    }

    private MethodSpec m_setter(String capital, TableField field, boolean setterChain) {
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)("set" + capital)).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (setterChain) {
            spec.returns((TypeName)this.className());
        }
        spec.addParameter(field.getJavaType(), field.getName(), new Modifier[0]).addStatement("this.$L = $L", new Object[]{field.getName(), field.getName()});
        if (setterChain) {
            spec.addStatement("return this", new Object[0]);
        }
        return spec.build();
    }

    private MethodSpec m_entityClass() {
        return MethodSpec.methodBuilder((String)"entityClass").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Override.class).returns(Class.class).addStatement("return $L.class", new Object[]{EntityFile.entityClass(this.table)}).build();
    }

    private MethodSpec m_relation(RelationConfig relation) {
        String methodName = relation.methodName();
        String entityName = EntityFile.entityClass(this.table);
        boolean isAbstract = relation.getRelationByFields().isEmpty() && relation.getRelationByColumns().isEmpty();
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(relation.refMethodAnnotation()).returns(relation.returnType()).addStatement("return super.invoke($S, $L)", new Object[]{methodName, relation.isCached()});
        if (isAbstract) {
            spec.addJavadoc("@see $L.IEntityRelation#$LOf$L($L)", new Object[]{this.table.gc().getBasePackage(), methodName, entityName, entityName});
        } else {
            spec.addJavadoc("@see $L.IEntityRelation#$LOf$L($T)", new Object[]{this.table.gc().getBasePackage(), methodName, entityName, List.class});
        }
        return spec.build();
    }

    private AnnotationSpec getTableFieldAnnotation(TableField field) {
        AnnotationSpec.Builder spec = AnnotationSpec.builder((ClassName)ClassNames.FM_TableField).addMember("value", "$S", new Object[]{field.getColumnName()});
        if (!GeneratorHelper.isBlank(field.getInsert())) {
            spec.addMember("insert", "$S", new Object[]{field.getInsert()});
        }
        if (!GeneratorHelper.isBlank(field.getUpdate())) {
            spec.addMember("update", "$S", new Object[]{field.getUpdate()});
        }
        if (field.getIsLarge() != null && !field.getIsLarge().booleanValue()) {
            spec.addMember("notLarge", "$L", new Object[]{Boolean.FALSE.toString()});
        }
        this.addHandlerAndComment(spec, field);
        return spec.build();
    }

    private AnnotationSpec getTableIdAnnotation(TableField field) {
        boolean before;
        AnnotationSpec.Builder spec = AnnotationSpec.builder((ClassName)ClassNames.FM_TableId).addMember("value", "$S", new Object[]{field.getColumnName()});
        String seqName = this.table.getSeqName();
        if (!this.isAuto(seqName, field.isPrimaryId())) {
            spec.addMember("auto", "$L", new Object[]{Boolean.FALSE.toString()});
        }
        if (!GeneratorHelper.isBlank(seqName) && !"auto".equals(seqName)) {
            spec.addMember("seqName", "$S", new Object[]{seqName});
        }
        if (before = this.table.selectKeyBefore()) {
            spec.addMember("before", "$L", new Object[]{true});
        }
        this.addHandlerAndComment(spec, field);
        return spec.build();
    }

    private void addHandlerAndComment(AnnotationSpec.Builder spec, TableField field) {
        if (field.getTypeHandler() != null) {
            spec.addMember("typeHandler", "$T.class", new Object[]{field.getTypeHandler()});
        }
        String comment = field.getComment();
        if (!GeneratorHelper.isBlank(field.getComment())) {
            comment = comment.trim().replace('\n', ';').replace('\r', ';');
            spec.addMember("desc", "$S", new Object[]{comment});
        }
    }

    boolean isAuto(String seqName, boolean isPrimaryId) {
        return "auto".equals(seqName) || "".equals(seqName) && isPrimaryId;
    }

    private void addSuperInterface(TypeSpec.Builder builder, List<Class> interfaces) {
        if (interfaces == null || interfaces.size() == 0) {
            return;
        }
        for (Class _interface : interfaces) {
            if (this.hasEntityType(_interface.getSimpleName(), _interface.getTypeParameters())) {
                builder.addSuperinterface(this.parameterizedType(ClassName.get((Class)_interface), new TypeName[]{this.className()}));
                continue;
            }
            builder.addSuperinterface((Type)_interface);
        }
    }

    private boolean hasEntityType(String interfaceName, TypeVariable[] typeVariables) {
        if (typeVariables.length != 1) {
            return false;
        }
        for (Type bound : typeVariables[0].getBounds()) {
            String tn = bound.getTypeName();
            if (!Objects.equals(tn, interfaceName) && !Allow_Entity_Bounds.contains(tn)) continue;
            return true;
        }
        return false;
    }

    private AnnotationSpec fluentMybatisAnnotation() {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassNames.FM_FluentMybatis);
        builder.addMember("table", "$S", new Object[]{this.table.getTableName()});
        if (!this.table.gc().getSchema().trim().isEmpty()) {
            builder.addMember("schema", "$S", new Object[]{this.table.gc().getSchema().trim()});
        }
        if (this.table.gc().isUseCached()) {
            builder.addMember("useCached", "true", new Object[0]);
        }
        if (!GeneratorHelper.isBlank(this.table.getMapperBeanPrefix())) {
            builder.addMember("mapperBeanPrefix", "$S", new Object[]{this.table.getMapperBeanPrefix()});
        }
        if (this.table.getDefaults() != null) {
            builder.addMember("defaults", "$T.class", new Object[]{this.table.getDefaults()});
        }
        if (this.table.getSuperMapper() != null) {
            builder.addMember("superMapper", "$T.class", new Object[]{this.table.getSuperMapper()});
        }
        if (!Objects.equals(this.table.getEntitySuffix(), "Entity")) {
            builder.addMember("suffix", "$S", new Object[]{this.table.getEntitySuffix()});
        }
        if (DbType.MYSQL != this.table.gc().getDbType()) {
            builder.addMember("dbType", "$T.$L", new Object[]{ClassNames.FM_FluentDbType, this.table.gc().getDbType().name()});
        }
        return builder.build();
    }

    @Override
    protected boolean isInterface() {
        return false;
    }

    static {
        Allow_Entity_Bounds.add("cn.org.atool.fluent.mybatis.base.IEntity");
        Allow_Entity_Bounds.add(Object.class.getName());
        Allow_Entity_Bounds.add(Serializable.class.getName());
    }
}

