/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.database.model;

import cn.org.atool.generator.database.model.TableField;
import cn.org.atool.generator.util.GeneratorHelper;
import java.util.Objects;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.UnknownTypeHandler;

public class CustomizedColumn {
    private String columnName;
    private String fieldName;
    private Class javaType;
    private Class<? extends TypeHandler> typeHandler;
    private boolean notLarge = true;
    private boolean exclude = false;
    private String update;
    private String insert;

    public CustomizedColumn(String columnName, String fieldName, Class javaType) {
        this.columnName = columnName;
        this.fieldName = fieldName;
        this.javaType = javaType;
    }

    public CustomizedColumn(String columnName) {
        this.columnName = columnName;
    }

    public CustomizedColumn setLarge() {
        this.notLarge = false;
        return this;
    }

    public CustomizedColumn setExclude() {
        this.exclude = true;
        return this;
    }

    public void initField(TableField field) {
        if (!GeneratorHelper.isBlank(this.fieldName)) {
            field.setName(this.fieldName);
        }
        if (this.javaType != null) {
            field.setJavaType(this.javaType);
        }
        if (this.typeHandler != null && !Objects.equals(UnknownTypeHandler.class, this.typeHandler)) {
            field.setTypeHandler(this.typeHandler);
        }
        if (!this.notLarge) {
            field.setIsLarge(false);
        }
        if (!GeneratorHelper.isBlank(this.insert)) {
            field.setInsert(this.insert);
        }
        if (!GeneratorHelper.isBlank(this.update)) {
            field.setUpdate(this.update);
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public Class<? extends TypeHandler> getTypeHandler() {
        return this.typeHandler;
    }

    public boolean isNotLarge() {
        return this.notLarge;
    }

    public boolean isExclude() {
        return this.exclude;
    }

    public String getUpdate() {
        return this.update;
    }

    public String getInsert() {
        return this.insert;
    }

    public CustomizedColumn setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public CustomizedColumn setJavaType(Class javaType) {
        this.javaType = javaType;
        return this;
    }

    public CustomizedColumn setTypeHandler(Class<? extends TypeHandler> typeHandler) {
        this.typeHandler = typeHandler;
        return this;
    }

    public CustomizedColumn setUpdate(String update) {
        this.update = update;
        return this;
    }

    public CustomizedColumn setInsert(String insert) {
        this.insert = insert;
        return this;
    }
}

