/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Metadata {
    @NotNull
    private final Map<Class<? extends Directory>, Collection<Directory>> _directoryListByClass = new HashMap<Class<? extends Directory>, Collection<Directory>>();

    @NotNull
    public Iterable<Directory> getDirectories() {
        return new DirectoryIterable(this._directoryListByClass);
    }

    @Nullable
    public <T extends Directory> Collection<T> getDirectoriesOfType(Class<T> type) {
        return this._directoryListByClass.get(type);
    }

    public int getDirectoryCount() {
        int count = 0;
        for (Map.Entry<Class<? extends Directory>, Collection<Directory>> pair : this._directoryListByClass.entrySet()) {
            count += pair.getValue().size();
        }
        return count;
    }

    public <T extends Directory> void addDirectory(@NotNull T directory) {
        this.getOrCreateDirectoryList(directory.getClass()).add(directory);
    }

    @Nullable
    public <T extends Directory> T getFirstDirectoryOfType(@NotNull Class<T> type) {
        Collection<Directory> list = this.getDirectoryList(type);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (T)list.iterator().next();
    }

    public boolean containsDirectoryOfType(Class<? extends Directory> type) {
        Collection<Directory> list = this.getDirectoryList(type);
        return list != null && !list.isEmpty();
    }

    public boolean hasErrors() {
        for (Directory directory : this.getDirectories()) {
            if (!directory.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        int count = this.getDirectoryCount();
        return String.format("Metadata (%d %s)", count, count == 1 ? "directory" : "directories");
    }

    @Nullable
    private <T extends Directory> Collection<Directory> getDirectoryList(@NotNull Class<T> type) {
        return this._directoryListByClass.get(type);
    }

    @NotNull
    private <T extends Directory> Collection<Directory> getOrCreateDirectoryList(@NotNull Class<T> type) {
        Collection<Directory> collection = this.getDirectoryList(type);
        if (collection != null) {
            return collection;
        }
        collection = new ArrayList<Directory>();
        this._directoryListByClass.put(type, collection);
        return collection;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DirectoryIterable
    implements Iterable<Directory> {
        private final Map<Class<? extends Directory>, Collection<Directory>> _map;

        public DirectoryIterable(Map<Class<? extends Directory>, Collection<Directory>> map) {
            this._map = map;
        }

        @Override
        public Iterator<Directory> iterator() {
            return new DirectoryIterator(this._map);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class DirectoryIterator
        implements Iterator<Directory> {
            @NotNull
            private final Iterator<Map.Entry<Class<? extends Directory>, Collection<Directory>>> _mapIterator;
            @Nullable
            private Iterator<Directory> _listIterator;

            public DirectoryIterator(Map<Class<? extends Directory>, Collection<Directory>> map) {
                this._mapIterator = map.entrySet().iterator();
                if (this._mapIterator.hasNext()) {
                    this._listIterator = this._mapIterator.next().getValue().iterator();
                }
            }

            @Override
            public boolean hasNext() {
                return this._listIterator != null && (this._listIterator.hasNext() || this._mapIterator.hasNext());
            }

            @Override
            public Directory next() {
                if (this._listIterator == null || !this._listIterator.hasNext() && !this._mapIterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                while (!this._listIterator.hasNext()) {
                    this._listIterator = this._mapIterator.next().getValue().iterator();
                }
                return this._listIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

