/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.util;

import com.ctrip.framework.apollo.core.MetaDomainConsts;
import com.ctrip.framework.apollo.core.enums.Env;
import com.ctrip.framework.apollo.core.enums.EnvUtils;
import com.ctrip.framework.apollo.core.utils.DeprecatedPropertyNotifyUtil;
import com.ctrip.framework.foundation.Foundation;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.RateLimiter;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtil {
    private static final Logger logger = LoggerFactory.getLogger(ConfigUtil.class);
    private int discoveryQPS = 1;
    private int discoveryConnectTimeout = 1000;
    private int discoveryReadTimeout = 1000;
    private int refreshInterval = 5;
    private TimeUnit refreshIntervalTimeUnit = TimeUnit.MINUTES;
    private int connectTimeout = 1000;
    private int readTimeout = 5000;
    private String cluster;
    private int loadConfigQPS = 2;
    private int longPollQPS = 2;
    private long onErrorRetryInterval = 1L;
    private TimeUnit onErrorRetryIntervalTimeUnit = TimeUnit.SECONDS;
    private long maxConfigCacheSize = 500L;
    private long configCacheExpireTime = 1L;
    private TimeUnit configCacheExpireTimeUnit = TimeUnit.MINUTES;
    private long longPollingInitialDelayInMills = 2000L;
    private boolean autoUpdateInjectedSpringProperties = true;
    private final RateLimiter warnLogRateLimiter = RateLimiter.create((double)0.017);
    private boolean propertiesOrdered = false;
    private boolean propertyNamesCacheEnabled = false;
    private boolean propertyFileCacheEnabled = true;
    private boolean overrideSystemProperties = true;
    private boolean propertyKubernetesCacheEnabled = false;
    private boolean clientMonitorEnabled = false;
    private boolean clientMonitorJmxEnabled = false;
    private String monitorExternalType = "";
    private long monitorExternalExportPeriod = 10L;
    private int monitorExceptionQueueSize = 25;

    public ConfigUtil() {
        this.initRefreshInterval();
        this.initConnectTimeout();
        this.initReadTimeout();
        this.initCluster();
        this.initQPS();
        this.initMaxConfigCacheSize();
        this.initLongPollingInitialDelayInMills();
        this.initAutoUpdateInjectedSpringProperties();
        this.initPropertiesOrdered();
        this.initPropertyNamesCacheEnabled();
        this.initPropertyFileCacheEnabled();
        this.initOverrideSystemProperties();
        this.initPropertyKubernetesCacheEnabled();
        this.initClientMonitorEnabled();
        this.initClientMonitorJmxEnabled();
        this.initClientMonitorExternalType();
        this.initClientMonitorExternalExportPeriod();
        this.initClientMonitorExceptionQueueSize();
    }

    public String getAppId() {
        String appId = Foundation.app().getAppId();
        if (Strings.isNullOrEmpty((String)appId)) {
            appId = "ApolloNoAppIdPlaceHolder";
            if (this.warnLogRateLimiter.tryAcquire()) {
                logger.warn("app.id is not set, please make sure it is set in classpath:/META-INF/app.properties, now apollo will only load public namespace configurations!");
            }
        }
        return appId;
    }

    public String getApolloLabel() {
        return Foundation.app().getApolloLabel();
    }

    public String getAccessKeySecret() {
        return Foundation.app().getAccessKeySecret();
    }

    public String getDataCenter() {
        return Foundation.server().getDataCenter();
    }

    private void initCluster() {
        this.cluster = System.getProperty("apollo.cluster");
        if (Strings.isNullOrEmpty((String)this.cluster)) {
            this.cluster = this.getDataCenter();
        }
        if (Strings.isNullOrEmpty((String)this.cluster)) {
            this.cluster = "default";
        }
    }

    public String getCluster() {
        return this.cluster;
    }

    public Env getApolloEnv() {
        return EnvUtils.transformEnv((String)Foundation.server().getEnvType());
    }

    public String getLocalIp() {
        return Foundation.net().getHostAddress();
    }

    public String getMetaServerDomainName() {
        return MetaDomainConsts.getDomain((Env)this.getApolloEnv());
    }

    private void initConnectTimeout() {
        String customizedConnectTimeout = System.getProperty("apollo.connectTimeout");
        if (!Strings.isNullOrEmpty((String)customizedConnectTimeout)) {
            try {
                this.connectTimeout = Integer.parseInt(customizedConnectTimeout);
            }
            catch (Throwable ex) {
                logger.error("Config for apollo.connectTimeout is invalid: {}", (Object)customizedConnectTimeout);
            }
        }
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    private void initReadTimeout() {
        String customizedReadTimeout = System.getProperty("apollo.readTimeout");
        if (!Strings.isNullOrEmpty((String)customizedReadTimeout)) {
            try {
                this.readTimeout = Integer.parseInt(customizedReadTimeout);
            }
            catch (Throwable ex) {
                logger.error("Config for apollo.readTimeout is invalid: {}", (Object)customizedReadTimeout);
            }
        }
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    private void initRefreshInterval() {
        String customizedRefreshInterval = System.getProperty("apollo.refreshInterval");
        if (!Strings.isNullOrEmpty((String)customizedRefreshInterval)) {
            try {
                this.refreshInterval = Integer.parseInt(customizedRefreshInterval);
            }
            catch (Throwable ex) {
                logger.error("Config for apollo.refreshInterval is invalid: {}", (Object)customizedRefreshInterval);
            }
        }
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public TimeUnit getRefreshIntervalTimeUnit() {
        return this.refreshIntervalTimeUnit;
    }

    static Integer getCustomizedIntegerValue(String systemKey) {
        String customizedValue = System.getProperty(systemKey);
        if (!Strings.isNullOrEmpty((String)customizedValue)) {
            try {
                return Integer.parseInt(customizedValue);
            }
            catch (Throwable ex) {
                logger.error("Config for {} is invalid: {}", (Object)systemKey, (Object)customizedValue);
            }
        }
        return null;
    }

    private void initQPS() {
        Integer value = ConfigUtil.getCustomizedIntegerValue("apollo.discoveryConnectTimeout");
        if (null != value) {
            this.discoveryConnectTimeout = value;
        }
        if (null != (value = ConfigUtil.getCustomizedIntegerValue("apollo.discoveryReadTimeout"))) {
            this.discoveryReadTimeout = value;
        }
        if (null != (value = ConfigUtil.getCustomizedIntegerValue("apollo.discoveryQPS"))) {
            this.discoveryQPS = value;
        }
        if (null != (value = ConfigUtil.getCustomizedIntegerValue("apollo.loadConfigQPS"))) {
            this.loadConfigQPS = value;
        }
        if (null != (value = ConfigUtil.getCustomizedIntegerValue("apollo.longPollQPS"))) {
            this.longPollQPS = value;
        }
    }

    public int getDiscoveryQPS() {
        return this.discoveryQPS;
    }

    public int getDiscoveryConnectTimeout() {
        return this.discoveryConnectTimeout;
    }

    public int getDiscoveryReadTimeout() {
        return this.discoveryReadTimeout;
    }

    public int getLoadConfigQPS() {
        return this.loadConfigQPS;
    }

    public int getLongPollQPS() {
        return this.longPollQPS;
    }

    public long getOnErrorRetryInterval() {
        return this.onErrorRetryInterval;
    }

    public TimeUnit getOnErrorRetryIntervalTimeUnit() {
        return this.onErrorRetryIntervalTimeUnit;
    }

    public String getDefaultLocalCacheDir() {
        String cacheRoot = this.getCustomizedCacheRoot();
        if (!Strings.isNullOrEmpty((String)cacheRoot)) {
            return cacheRoot + File.separator + this.getAppId();
        }
        cacheRoot = this.isOSWindows() ? "C:\\opt\\data\\%s" : "/opt/data/%s";
        return String.format(cacheRoot, this.getAppId());
    }

    public String getDefaultLocalCacheDir(String appId) {
        String cacheRoot = this.getCustomizedCacheRoot();
        if (!Strings.isNullOrEmpty((String)cacheRoot)) {
            return cacheRoot + File.separator + appId;
        }
        cacheRoot = this.isOSWindows() ? "C:\\opt\\data\\%s" : "/opt/data/%s";
        return String.format(cacheRoot, appId);
    }

    private String getCustomizedCacheRoot() {
        String cacheRoot = System.getProperty("apollo.cache-dir");
        if (Strings.isNullOrEmpty((String)cacheRoot)) {
            cacheRoot = System.getenv("APOLLO_CACHE_DIR");
        }
        if (Strings.isNullOrEmpty((String)cacheRoot)) {
            cacheRoot = Foundation.server().getProperty("apollo.cache-dir", null);
        }
        if (Strings.isNullOrEmpty((String)cacheRoot)) {
            cacheRoot = Foundation.app().getProperty("apollo.cache-dir", null);
        }
        if (Strings.isNullOrEmpty((String)cacheRoot)) {
            cacheRoot = this.getDeprecatedCustomizedCacheRoot();
        }
        return cacheRoot;
    }

    private String getDeprecatedCustomizedCacheRoot() {
        String cacheRoot = System.getProperty("apollo.cacheDir");
        if (!Strings.isNullOrEmpty((String)cacheRoot)) {
            DeprecatedPropertyNotifyUtil.warn((String)"apollo.cacheDir", (String)"apollo.cache-dir");
        }
        if (Strings.isNullOrEmpty((String)cacheRoot) && !Strings.isNullOrEmpty((String)(cacheRoot = System.getenv("APOLLO_CACHEDIR")))) {
            DeprecatedPropertyNotifyUtil.warn((String)"APOLLO_CACHEDIR", (String)"APOLLO_CACHE_DIR");
        }
        if (Strings.isNullOrEmpty((String)cacheRoot) && !Strings.isNullOrEmpty((String)(cacheRoot = Foundation.server().getProperty("apollo.cacheDir", null)))) {
            DeprecatedPropertyNotifyUtil.warn((String)"apollo.cacheDir", (String)"apollo.cache-dir");
        }
        if (Strings.isNullOrEmpty((String)cacheRoot) && !Strings.isNullOrEmpty((String)(cacheRoot = Foundation.app().getProperty("apollo.cacheDir", null)))) {
            DeprecatedPropertyNotifyUtil.warn((String)"apollo.cacheDir", (String)"apollo.cache-dir");
        }
        return cacheRoot;
    }

    public String getK8sNamespace() {
        String k8sNamespace = this.getCacheKubernetesNamespace();
        if (!Strings.isNullOrEmpty((String)k8sNamespace)) {
            return k8sNamespace;
        }
        return "default";
    }

    private String getCacheKubernetesNamespace() {
        String k8sNamespace = System.getProperty("apollo.cache.kubernetes.namespace");
        if (Strings.isNullOrEmpty((String)k8sNamespace)) {
            k8sNamespace = System.getenv("APOLLO_CACHE_KUBERNETES_NAMESPACE");
        }
        if (Strings.isNullOrEmpty((String)k8sNamespace)) {
            k8sNamespace = Foundation.server().getProperty("apollo.cache.kubernetes.namespace", null);
        }
        if (Strings.isNullOrEmpty((String)k8sNamespace)) {
            k8sNamespace = Foundation.app().getProperty("apollo.cache.kubernetes.namespace", null);
        }
        return k8sNamespace;
    }

    public boolean isInLocalMode() {
        try {
            return Env.LOCAL == this.getApolloEnv();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean isOSWindows() {
        String osName = System.getProperty("os.name");
        if (Strings.isNullOrEmpty((String)osName)) {
            return false;
        }
        return osName.startsWith("Windows");
    }

    private void initMaxConfigCacheSize() {
        String customizedConfigCacheSize = System.getProperty("apollo.configCacheSize");
        if (!Strings.isNullOrEmpty((String)customizedConfigCacheSize)) {
            try {
                this.maxConfigCacheSize = Long.parseLong(customizedConfigCacheSize);
            }
            catch (Throwable ex) {
                logger.error("Config for apollo.configCacheSize is invalid: {}", (Object)customizedConfigCacheSize);
            }
        }
    }

    public long getMaxConfigCacheSize() {
        return this.maxConfigCacheSize;
    }

    public long getConfigCacheExpireTime() {
        return this.configCacheExpireTime;
    }

    public TimeUnit getConfigCacheExpireTimeUnit() {
        return this.configCacheExpireTimeUnit;
    }

    private void initLongPollingInitialDelayInMills() {
        String customizedLongPollingInitialDelay = System.getProperty("apollo.longPollingInitialDelayInMills");
        if (!Strings.isNullOrEmpty((String)customizedLongPollingInitialDelay)) {
            try {
                this.longPollingInitialDelayInMills = Long.parseLong(customizedLongPollingInitialDelay);
            }
            catch (Throwable ex) {
                logger.error("Config for apollo.longPollingInitialDelayInMills is invalid: {}", (Object)customizedLongPollingInitialDelay);
            }
        }
    }

    public long getLongPollingInitialDelayInMills() {
        return this.longPollingInitialDelayInMills;
    }

    private void initAutoUpdateInjectedSpringProperties() {
        String enableAutoUpdate = System.getProperty("apollo.autoUpdateInjectedSpringProperties");
        if (Strings.isNullOrEmpty((String)enableAutoUpdate)) {
            enableAutoUpdate = Foundation.app().getProperty("apollo.autoUpdateInjectedSpringProperties", null);
        }
        if (!Strings.isNullOrEmpty((String)enableAutoUpdate)) {
            this.autoUpdateInjectedSpringProperties = Boolean.parseBoolean(enableAutoUpdate.trim());
        }
    }

    public boolean isAutoUpdateInjectedSpringPropertiesEnabled() {
        return this.autoUpdateInjectedSpringProperties;
    }

    private void initPropertiesOrdered() {
        String enablePropertiesOrdered = System.getProperty("apollo.property.order.enable");
        if (Strings.isNullOrEmpty((String)enablePropertiesOrdered)) {
            enablePropertiesOrdered = Foundation.app().getProperty("apollo.property.order.enable", "false");
        }
        if (!Strings.isNullOrEmpty((String)enablePropertiesOrdered)) {
            try {
                this.propertiesOrdered = Boolean.parseBoolean(enablePropertiesOrdered);
            }
            catch (Throwable ex) {
                logger.warn("Config for {} is invalid: {}, set default value: false", (Object)"apollo.property.order.enable", (Object)enablePropertiesOrdered);
            }
        }
    }

    public boolean isPropertiesOrderEnabled() {
        return this.propertiesOrdered;
    }

    public boolean isPropertyNamesCacheEnabled() {
        return this.propertyNamesCacheEnabled;
    }

    public boolean isPropertyFileCacheEnabled() {
        return this.propertyFileCacheEnabled;
    }

    public boolean isPropertyKubernetesCacheEnabled() {
        return this.propertyKubernetesCacheEnabled;
    }

    public boolean isOverrideSystemProperties() {
        return this.overrideSystemProperties;
    }

    private void initPropertyNamesCacheEnabled() {
        this.propertyNamesCacheEnabled = this.getPropertyBoolean("apollo.property.names.cache.enable", "APOLLO_PROPERTY_NAMES_CACHE_ENABLE", this.propertyNamesCacheEnabled);
    }

    private void initPropertyFileCacheEnabled() {
        this.propertyFileCacheEnabled = this.getPropertyBoolean("apollo.cache.file.enable", "APOLLO_CACHE_FILE_ENABLE", this.propertyFileCacheEnabled);
    }

    private void initOverrideSystemProperties() {
        this.overrideSystemProperties = this.getPropertyBoolean("apollo.override-system-properties", "apollo.override-system-properties", this.overrideSystemProperties);
    }

    private void initPropertyKubernetesCacheEnabled() {
        this.propertyKubernetesCacheEnabled = this.getPropertyBoolean("apollo.cache.kubernetes.enable", "APOLLO_KUBERNETES_CACHE_ENABLE", this.propertyKubernetesCacheEnabled);
    }

    private void initClientMonitorExternalType() {
        this.monitorExternalType = System.getProperty("apollo.client.monitor.external.type");
        if (Strings.isNullOrEmpty((String)this.monitorExternalType)) {
            this.monitorExternalType = Foundation.app().getProperty("apollo.client.monitor.external.type", "");
        }
    }

    public String getMonitorExternalType() {
        return this.monitorExternalType;
    }

    private void initClientMonitorExternalExportPeriod() {
        Integer value = ConfigUtil.getCustomizedIntegerValue("apollo.client.monitor.external.export-period");
        if (value != null) {
            if (value <= 0) {
                logger.warn("Config for {} is invalid: {}, remain default value: 10", (Object)"apollo.client.monitor.external.export-period", (Object)value);
            } else {
                this.monitorExternalExportPeriod = value.intValue();
            }
        }
    }

    public long getMonitorExternalExportPeriod() {
        return this.monitorExternalExportPeriod;
    }

    private void initClientMonitorEnabled() {
        this.clientMonitorEnabled = this.getPropertyBoolean("apollo.client.monitor.enabled", "apollo.client.monitor.enabled", this.clientMonitorEnabled);
    }

    public boolean isClientMonitorEnabled() {
        return this.clientMonitorEnabled;
    }

    private void initClientMonitorJmxEnabled() {
        this.clientMonitorJmxEnabled = this.getPropertyBoolean("apollo.client.monitor.jmx.enabled", "apollo.client.monitor.jmx.enabled", this.clientMonitorJmxEnabled);
    }

    public boolean isClientMonitorJmxEnabled() {
        return this.clientMonitorJmxEnabled;
    }

    private void initClientMonitorExceptionQueueSize() {
        Integer value = ConfigUtil.getCustomizedIntegerValue("apollo.client.monitor.exception-queue-size");
        if (value != null) {
            if (value <= 0) {
                logger.warn("Config for {} is invalid: {}, remain default value: 25", (Object)"apollo.client.monitor.exception-queue-size", (Object)value);
            } else {
                this.monitorExceptionQueueSize = value;
            }
        }
    }

    public int getMonitorExceptionQueueSize() {
        return this.monitorExceptionQueueSize;
    }

    private boolean getPropertyBoolean(String propertyName, String envName, boolean defaultVal) {
        String enablePropertyNamesCache = System.getProperty(propertyName);
        if (Strings.isNullOrEmpty((String)enablePropertyNamesCache)) {
            enablePropertyNamesCache = System.getenv(envName);
        }
        if (Strings.isNullOrEmpty((String)enablePropertyNamesCache)) {
            enablePropertyNamesCache = Foundation.app().getProperty(propertyName, null);
        }
        if (!Strings.isNullOrEmpty((String)enablePropertyNamesCache)) {
            try {
                return Boolean.parseBoolean(enablePropertyNamesCache);
            }
            catch (Throwable ex) {
                logger.warn("Config for {} is invalid: {}, set default value: {}", new Object[]{propertyName, enablePropertyNamesCache, defaultVal});
            }
        }
        return defaultVal;
    }

    public String getAccessKeySecret(String appId) {
        return Foundation.app().getAccessKeySecret(appId);
    }
}

