/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.monitor.internal.tracer;

import com.ctrip.framework.apollo.tracer.internals.NullTransaction;
import com.ctrip.framework.apollo.tracer.spi.MessageProducer;
import com.ctrip.framework.apollo.tracer.spi.Transaction;
import java.util.List;

public class ApolloClientMessageProducerComposite
implements MessageProducer {
    public static final NullTransaction NULL_TRANSACTION = new NullTransaction();
    private final List<MessageProducer> producers;

    public ApolloClientMessageProducerComposite(List<MessageProducer> producers) {
        this.producers = producers;
    }

    public void logError(Throwable cause) {
        for (MessageProducer producer : this.producers) {
            producer.logError(cause);
        }
    }

    public void logError(String message, Throwable cause) {
        for (MessageProducer producer : this.producers) {
            producer.logError(message, cause);
        }
    }

    public void logEvent(String type, String name) {
        for (MessageProducer producer : this.producers) {
            producer.logEvent(type, name);
        }
    }

    public void logEvent(String type, String name, String status, String nameValuePairs) {
        for (MessageProducer producer : this.producers) {
            producer.logEvent(type, name, status, nameValuePairs);
        }
    }

    public void logMetricsForCount(String name) {
        for (MessageProducer producer : this.producers) {
            producer.logMetricsForCount(name);
        }
    }

    public Transaction newTransaction(String type, String name) {
        for (MessageProducer producer : this.producers) {
            Transaction transaction = producer.newTransaction(type, name);
            if (transaction == null) continue;
            return transaction;
        }
        return NULL_TRANSACTION;
    }
}

