/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.monitor.internal.listener.impl;

import com.ctrip.framework.apollo.internals.AbstractConfig;
import com.ctrip.framework.apollo.internals.AbstractConfigFile;
import com.ctrip.framework.apollo.internals.RemoteConfigRepository;
import com.ctrip.framework.apollo.monitor.api.ApolloClientThreadPoolMonitorApi;
import com.ctrip.framework.apollo.monitor.internal.exporter.AbstractApolloClientMetricsExporter;
import com.ctrip.framework.apollo.monitor.internal.jmx.mbean.ApolloClientJmxThreadPoolMBean;
import com.ctrip.framework.apollo.monitor.internal.listener.AbstractApolloClientMonitorEventListener;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;

public class DefaultApolloClientThreadPoolApi
extends AbstractApolloClientMonitorEventListener
implements ApolloClientThreadPoolMonitorApi,
ApolloClientJmxThreadPoolMBean {
    public static final String REMOTE_CONFIG_REPOSITORY = RemoteConfigRepository.class.getSimpleName();
    public static final String ABSTRACT_CONFIG = AbstractConfig.class.getSimpleName();
    public static final String ABSTRACT_CONFIG_FILE = AbstractConfigFile.class.getSimpleName();
    public static final String METRICS_EXPORTER = AbstractApolloClientMetricsExporter.class.getSimpleName();
    private final Map<String, ApolloClientThreadPoolMonitorApi.ApolloThreadPoolInfo> executorMap = Maps.newHashMap();

    public DefaultApolloClientThreadPoolApi(ExecutorService remoteConfigRepositoryExecutorService, ExecutorService abstractConfigExecutorService, ExecutorService abstractConfigFileExecutorService, ExecutorService metricsExporterExecutorService) {
        super("ThreadPoolMonitor");
        this.executorMap.put(REMOTE_CONFIG_REPOSITORY, new ApolloClientThreadPoolMonitorApi.ApolloThreadPoolInfo((ThreadPoolExecutor)remoteConfigRepositoryExecutorService));
        this.executorMap.put(ABSTRACT_CONFIG, new ApolloClientThreadPoolMonitorApi.ApolloThreadPoolInfo((ThreadPoolExecutor)abstractConfigExecutorService));
        this.executorMap.put(ABSTRACT_CONFIG_FILE, new ApolloClientThreadPoolMonitorApi.ApolloThreadPoolInfo((ThreadPoolExecutor)abstractConfigFileExecutorService));
        this.executorMap.put(METRICS_EXPORTER, new ApolloClientThreadPoolMonitorApi.ApolloThreadPoolInfo((ThreadPoolExecutor)metricsExporterExecutorService));
    }

    @Override
    public void export0() {
        this.executorMap.forEach((key, value) -> this.exportThreadPoolMetrics((ApolloClientThreadPoolMonitorApi.ApolloThreadPoolInfo)value, (String)key));
    }

    private void exportThreadPoolMetrics(ApolloClientThreadPoolMonitorApi.ApolloThreadPoolInfo info, String threadPoolName) {
        this.createOrUpdateGaugeSample("apollo_client_thread_pool_active_task_count", new String[]{"thread_pool_name"}, new String[]{threadPoolName}, info.getActiveTaskCount());
        this.createOrUpdateGaugeSample("apollo_client_thread_pool_queue_size", new String[]{"thread_pool_name"}, new String[]{threadPoolName}, info.getQueueSize());
        this.createOrUpdateGaugeSample("apollo_client_thread_pool_completed_task_count", new String[]{"thread_pool_name"}, new String[]{threadPoolName}, info.getCompletedTaskCount());
        this.createOrUpdateGaugeSample("apollo_client_thread_pool_pool_size", new String[]{"thread_pool_name"}, new String[]{threadPoolName}, info.getPoolSize());
        this.createOrUpdateGaugeSample("apollo_client_thread_pool_total_task_count", new String[]{"thread_pool_name"}, new String[]{threadPoolName}, info.getTotalTaskCount());
        this.createOrUpdateGaugeSample("apollo_client_thread_pool_core_pool_size", new String[]{"thread_pool_name"}, new String[]{threadPoolName}, info.getCorePoolSize());
        this.createOrUpdateGaugeSample("apollo_client_thread_pool_maximum_pool_size", new String[]{"thread_pool_name"}, new String[]{threadPoolName}, info.getMaximumPoolSize());
        this.createOrUpdateGaugeSample("apollo_client_thread_pool_largest_pool_size", new String[]{"thread_pool_name"}, new String[]{threadPoolName}, info.getLargestPoolSize());
        this.createOrUpdateGaugeSample("apollo_client_thread_pool_queue_remaining_capacity", new String[]{"thread_pool_name"}, new String[]{threadPoolName}, info.getQueueRemainingCapacity());
    }

    @Override
    public boolean isMetricsSampleUpdated() {
        return true;
    }

    @Override
    public Map<String, ApolloClientThreadPoolMonitorApi.ApolloThreadPoolInfo> getThreadPoolInfo() {
        return this.executorMap;
    }

    @Override
    public ApolloClientThreadPoolMonitorApi.ApolloThreadPoolInfo getRemoteConfigRepositoryThreadPoolInfo() {
        return this.executorMap.get(REMOTE_CONFIG_REPOSITORY);
    }

    @Override
    public ApolloClientThreadPoolMonitorApi.ApolloThreadPoolInfo getAbstractConfigThreadPoolInfo() {
        return this.executorMap.get(ABSTRACT_CONFIG);
    }

    @Override
    public ApolloClientThreadPoolMonitorApi.ApolloThreadPoolInfo getAbstractConfigFileThreadPoolInfo() {
        return this.executorMap.get(ABSTRACT_CONFIG_FILE);
    }

    @Override
    public ApolloClientThreadPoolMonitorApi.ApolloThreadPoolInfo getMetricsExporterThreadPoolInfo() {
        return this.executorMap.get(METRICS_EXPORTER);
    }
}

