/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.monitor.internal.listener.impl;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.core.utils.DeferredLoggerFactory;
import com.ctrip.framework.apollo.internals.ConfigManager;
import com.ctrip.framework.apollo.monitor.api.ApolloClientNamespaceMonitorApi;
import com.ctrip.framework.apollo.monitor.internal.event.ApolloClientMonitorEvent;
import com.ctrip.framework.apollo.monitor.internal.jmx.mbean.ApolloClientJmxNamespaceMBean;
import com.ctrip.framework.apollo.monitor.internal.listener.AbstractApolloClientMonitorEventListener;
import com.ctrip.framework.apollo.util.date.DateUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class DefaultApolloClientNamespaceApi
extends AbstractApolloClientMonitorEventListener
implements ApolloClientNamespaceMonitorApi,
ApolloClientJmxNamespaceMBean {
    private static final Logger logger = DeferredLoggerFactory.getLogger(DefaultApolloClientNamespaceApi.class);
    private final ConfigManager configManager;
    private final Map<String, ApolloClientNamespaceMonitorApi.NamespaceMetrics> namespaces = Maps.newConcurrentMap();
    private final Set<String> namespace404 = Sets.newCopyOnWriteArraySet();
    private final Set<String> namespaceTimeout = Sets.newCopyOnWriteArraySet();

    public DefaultApolloClientNamespaceApi(ConfigManager configManager) {
        super("NamespaceMonitor");
        this.configManager = configManager;
    }

    @Override
    public void collect0(ApolloClientMonitorEvent event) {
        String eventName;
        String namespace = (String)event.getAttachmentValue("namespace");
        switch (eventName = event.getName()) {
            case "Apollo.Client.NamespaceNotFound": {
                this.handleNamespaceNotFound(namespace);
                break;
            }
            case "Apollo.Client.NamespaceTimeout": {
                this.handleNamespaceTimeout(namespace);
                break;
            }
            default: {
                this.handleNormalNamespace(namespace, event);
            }
        }
    }

    private void handleNormalNamespace(String namespace, ApolloClientMonitorEvent event) {
        this.namespace404.remove(namespace);
        this.namespaceTimeout.remove(namespace);
        ApolloClientNamespaceMonitorApi.NamespaceMetrics namespaceMetrics = this.namespaces.computeIfAbsent(namespace, k -> new ApolloClientNamespaceMonitorApi.NamespaceMetrics());
        this.collectMetrics(event, namespaceMetrics, namespace);
    }

    private void collectMetrics(ApolloClientMonitorEvent event, ApolloClientNamespaceMonitorApi.NamespaceMetrics namespaceMetrics, String namespace) {
        String eventName;
        switch (eventName = event.getName()) {
            case "Apollo.Client.NamespaceUsage": {
                this.handleUsageEvent(namespaceMetrics, namespace);
                break;
            }
            case "apollo_client_namespace_latest_update_time": {
                this.handleUpdateTimeEvent(event, namespaceMetrics);
                break;
            }
            case "Apollo.Client.NamespaceFirstLoadSpendTime": {
                this.handleFirstLoadSpendEvent(event, namespaceMetrics);
                break;
            }
            case "releaseKey": {
                this.handleReleaseKeyEvent(event, namespaceMetrics);
                break;
            }
            default: {
                logger.warn("Unhandled event name: {}", (Object)eventName);
            }
        }
    }

    private void handleNamespaceNotFound(String namespace) {
        this.namespace404.add(namespace);
    }

    private void handleNamespaceTimeout(String namespace) {
        this.namespaceTimeout.add(namespace);
    }

    private void handleUsageEvent(ApolloClientNamespaceMonitorApi.NamespaceMetrics namespaceMetrics, String namespace) {
        namespaceMetrics.incrementUsageCount();
        this.createOrUpdateCounterSample("apollo_client_namespace_usage", new String[]{"namespace"}, new String[]{namespace}, 1.0);
    }

    private void handleUpdateTimeEvent(ApolloClientMonitorEvent event, ApolloClientNamespaceMonitorApi.NamespaceMetrics namespaceMetrics) {
        namespaceMetrics.setLatestUpdateTime(LocalDateTime.now());
    }

    private void handleFirstLoadSpendEvent(ApolloClientMonitorEvent event, ApolloClientNamespaceMonitorApi.NamespaceMetrics namespaceMetrics) {
        long firstLoadSpendTime = (Long)event.getAttachmentValue("timestamp");
        namespaceMetrics.setFirstLoadTimeSpendInMs(firstLoadSpendTime);
    }

    private void handleReleaseKeyEvent(ApolloClientMonitorEvent event, ApolloClientNamespaceMonitorApi.NamespaceMetrics namespaceMetrics) {
        String releaseKey = (String)event.getAttachmentValue("releaseKey");
        namespaceMetrics.setReleaseKey(releaseKey);
    }

    @Override
    public void export0() {
        this.namespaces.forEach((namespace, metrics) -> {
            this.createOrUpdateGaugeSample("apollo_client_namespace_first_load_time_spend_in_ms", new String[]{"namespace"}, new String[]{namespace}, metrics.getFirstLoadTimeSpendInMs());
            this.createOrUpdateGaugeSample("apollo_client_namespace_item_num", new String[]{"namespace"}, new String[]{namespace}, this.configManager.getConfig((String)namespace).getPropertyNames().size());
        });
        this.createOrUpdateGaugeSample("apollo_client_namespace_not_found", this.namespace404.size());
        this.createOrUpdateGaugeSample("apollo_client_namespace_timeout", this.namespaceTimeout.size());
    }

    @Override
    public Map<String, ApolloClientNamespaceMonitorApi.NamespaceMetrics> getNamespaceMetrics() {
        return Collections.unmodifiableMap(this.namespaces);
    }

    @Override
    public List<String> getNotFoundNamespaces() {
        return new ArrayList<String>(this.namespace404);
    }

    @Override
    public List<String> getTimeoutNamespaces() {
        return new ArrayList<String>(this.namespaceTimeout);
    }

    @Override
    public Map<String, ApolloClientJmxNamespaceMBean.NamespaceMetricsString> getNamespaceMetricsString() {
        HashMap namespaceMetricsStringMap = Maps.newHashMap();
        this.namespaces.forEach((namespace, metrics) -> {
            ApolloClientJmxNamespaceMBean.NamespaceMetricsString namespaceMetricsString = new ApolloClientJmxNamespaceMBean.NamespaceMetricsString();
            namespaceMetricsString.setFirstLoadTimeSpendInMs(metrics.getFirstLoadTimeSpendInMs());
            DateUtil.formatLocalDateTime(metrics.getLatestUpdateTime()).ifPresent(namespaceMetricsString::setLatestUpdateTime);
            namespaceMetricsString.setUsageCount(metrics.getUsageCount());
            namespaceMetricsString.setReleaseKey(metrics.getReleaseKey());
            namespaceMetricsStringMap.put(namespace, namespaceMetricsString);
        });
        return namespaceMetricsStringMap;
    }

    @Override
    public Integer getNamespacePropertySize(String namespace) {
        Config config = this.configManager.getConfig(namespace);
        return config != null ? config.getPropertyNames().size() : 0;
    }
}

