/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.internals;

import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.utils.ClassLoaderUtil;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.internals.AbstractConfig;
import com.ctrip.framework.apollo.internals.AbstractConfigFile;
import com.ctrip.framework.apollo.internals.ConfigManager;
import com.ctrip.framework.apollo.internals.RemoteConfigRepository;
import com.ctrip.framework.apollo.monitor.internal.ApolloClientMonitorContext;
import com.ctrip.framework.apollo.monitor.internal.exporter.AbstractApolloClientMetricsExporter;
import com.ctrip.framework.apollo.monitor.internal.exporter.ApolloClientMetricsExporter;
import com.ctrip.framework.apollo.monitor.internal.exporter.ApolloClientMetricsExporterFactory;
import com.ctrip.framework.apollo.monitor.internal.jmx.ApolloClientJmxMBeanRegister;
import com.ctrip.framework.apollo.monitor.internal.listener.ApolloClientMonitorEventListener;
import com.ctrip.framework.apollo.monitor.internal.listener.impl.DefaultApolloClientBootstrapArgsApi;
import com.ctrip.framework.apollo.monitor.internal.listener.impl.DefaultApolloClientExceptionApi;
import com.ctrip.framework.apollo.monitor.internal.listener.impl.DefaultApolloClientNamespaceApi;
import com.ctrip.framework.apollo.monitor.internal.listener.impl.DefaultApolloClientThreadPoolApi;
import com.ctrip.framework.apollo.monitor.internal.tracer.ApolloClientMessageProducerComposite;
import com.ctrip.framework.apollo.monitor.internal.tracer.ApolloClientMonitorMessageProducer;
import com.ctrip.framework.apollo.tracer.internals.NullMessageProducer;
import com.ctrip.framework.apollo.tracer.internals.cat.CatMessageProducer;
import com.ctrip.framework.apollo.tracer.spi.MessageProducer;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.ctrip.framework.foundation.internals.ServiceBootstrap;
import com.google.common.collect.Lists;
import java.util.List;

public class ConfigMonitorInitializer {
    private static final ApolloClientMonitorContext MONITOR_CONTEXT = ApolloInjector.getInstance(ApolloClientMonitorContext.class);
    protected static volatile boolean hasInitialized = false;
    private static ConfigUtil m_configUtil = ApolloInjector.getInstance(ConfigUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initialize() {
        if (!m_configUtil.isClientMonitorEnabled() || hasInitialized) return;
        Class<ConfigMonitorInitializer> clazz = ConfigMonitorInitializer.class;
        synchronized (ConfigMonitorInitializer.class) {
            if (hasInitialized) return;
            ConfigMonitorInitializer.doInit();
            hasInitialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void doInit() {
        ConfigMonitorInitializer.initializeMetricsEventListener();
        ConfigMonitorInitializer.initializeMetricsExporter();
        ConfigMonitorInitializer.initializeJmxMonitoring();
    }

    private static void initializeJmxMonitoring() {
        if (m_configUtil.isClientMonitorJmxEnabled()) {
            MONITOR_CONTEXT.getApolloClientMonitorEventListeners().forEach(metricsListener -> ApolloClientJmxMBeanRegister.register("apollo.client.monitor:type=" + metricsListener.getName(), metricsListener));
        }
    }

    private static void initializeMetricsEventListener() {
        ConfigManager configManager = ApolloInjector.getInstance(ConfigManager.class);
        DefaultApolloClientBootstrapArgsApi defaultApolloClientBootstrapArgsApi = new DefaultApolloClientBootstrapArgsApi(m_configUtil);
        DefaultApolloClientExceptionApi defaultApolloClientExceptionApi = new DefaultApolloClientExceptionApi(m_configUtil);
        DefaultApolloClientNamespaceApi defaultApolloClientNamespaceApi = new DefaultApolloClientNamespaceApi(configManager);
        DefaultApolloClientThreadPoolApi defaultApolloClientThreadPoolApi = new DefaultApolloClientThreadPoolApi(RemoteConfigRepository.m_executorService, AbstractConfig.m_executorService, AbstractConfigFile.m_executorService, AbstractApolloClientMetricsExporter.m_executorService);
        MONITOR_CONTEXT.setApolloClientBootstrapArgsMonitorApi(defaultApolloClientBootstrapArgsApi);
        MONITOR_CONTEXT.setApolloClientExceptionMonitorApi(defaultApolloClientExceptionApi);
        MONITOR_CONTEXT.setApolloClientNamespaceMonitorApi(defaultApolloClientNamespaceApi);
        MONITOR_CONTEXT.setApolloClientThreadPoolMonitorApi(defaultApolloClientThreadPoolApi);
        MONITOR_CONTEXT.setApolloClientMonitorEventListeners(Lists.newArrayList((Object[])new ApolloClientMonitorEventListener[]{defaultApolloClientBootstrapArgsApi, defaultApolloClientNamespaceApi, defaultApolloClientThreadPoolApi, defaultApolloClientExceptionApi}));
    }

    private static void initializeMetricsExporter() {
        if (StringUtils.isBlank((String)m_configUtil.getMonitorExternalType())) {
            return;
        }
        ApolloClientMetricsExporterFactory exporterFactory = ApolloInjector.getInstance(ApolloClientMetricsExporterFactory.class);
        ApolloClientMetricsExporter metricsReporter = exporterFactory.getMetricsReporter(MONITOR_CONTEXT.getApolloClientMonitorEventListeners());
        if (metricsReporter != null) {
            MONITOR_CONTEXT.setApolloClientMetricsExporter(metricsReporter);
        }
    }

    public static ApolloClientMessageProducerComposite initializeMessageProducerComposite() {
        List producers = ServiceBootstrap.loadAllOrdered(MessageProducer.class);
        if (m_configUtil.isClientMonitorEnabled()) {
            producers.add(new ApolloClientMonitorMessageProducer());
        }
        if (ClassLoaderUtil.isClassPresent((String)"com.dianping.cat.Cat")) {
            producers.add(new CatMessageProducer());
        }
        if (producers.isEmpty()) {
            producers.add(new NullMessageProducer());
        }
        return new ApolloClientMessageProducerComposite(producers);
    }

    protected static void reset() {
        hasInitialized = false;
        m_configUtil = ApolloInjector.getInstance(ConfigUtil.class);
    }
}

