/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.impl.WebElementsCollection;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.List;
import org.openqa.selenium.WebElement;

public class FilteringCollection
implements WebElementsCollection {
    private final WebElementsCollection originalCollection;
    private final Predicate<WebElement> filter;

    public FilteringCollection(WebElementsCollection originalCollection, Predicate<WebElement> filter) {
        this.originalCollection = originalCollection;
        this.filter = filter;
    }

    @Override
    public List<WebElement> getActualElements() {
        return Lists.newArrayList((Iterable)Collections2.filter(this.originalCollection.getActualElements(), this.filter));
    }

    @Override
    public String description() {
        return this.originalCollection.description() + ".filter(" + this.filter + ')';
    }
}

