/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.collections.ExactTexts;
import com.codeborne.selenide.collections.ListSize;
import com.codeborne.selenide.collections.SizeGreaterThan;
import com.codeborne.selenide.collections.SizeGreaterThanOrEqual;
import com.codeborne.selenide.collections.SizeLessThan;
import com.codeborne.selenide.collections.SizeLessThanOrEqual;
import com.codeborne.selenide.collections.SizeNotEqual;
import com.codeborne.selenide.collections.Texts;
import com.codeborne.selenide.impl.WebElementsCollection;
import com.google.common.base.Predicate;
import java.util.List;
import org.openqa.selenium.WebElement;

public abstract class CollectionCondition
implements Predicate<List<WebElement>> {
    public static CollectionCondition empty = CollectionCondition.size(0);

    public abstract void fail(WebElementsCollection var1, List<WebElement> var2, Exception var3, long var4);

    public static CollectionCondition size(int expectedSize) {
        return new ListSize(expectedSize);
    }

    public static CollectionCondition sizeGreaterThan(int expectedSize) {
        return new SizeGreaterThan(expectedSize);
    }

    public static CollectionCondition sizeGreaterThanOrEqual(int expectedSize) {
        return new SizeGreaterThanOrEqual(expectedSize);
    }

    public static CollectionCondition sizeLessThan(int expectedSize) {
        return new SizeLessThan(expectedSize);
    }

    public static CollectionCondition sizeLessThanOrEqual(int size) {
        return new SizeLessThanOrEqual(size);
    }

    public static CollectionCondition sizeNotEqual(int expectedSize) {
        return new SizeNotEqual(expectedSize);
    }

    public static CollectionCondition texts(String ... expectedTexts) {
        return new Texts(expectedTexts);
    }

    public static CollectionCondition texts(List<String> expectedTexts) {
        return new Texts(expectedTexts);
    }

    public static CollectionCondition exactTexts(String ... expectedTexts) {
        return new ExactTexts(expectedTexts);
    }

    public static CollectionCondition exactTexts(List<String> expectedTexts) {
        return new ExactTexts(expectedTexts);
    }
}

