/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.common.poolman.StatementInfo;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import org.frameworkset.elasticsearch.client.DataStream;
import org.frameworkset.elasticsearch.client.ESJDBC;
import org.frameworkset.elasticsearch.client.FieldMeta;
import org.frameworkset.spi.assemble.PropertiesContainer;
import org.frameworkset.util.annotations.DateFormateMeta;

public class ImportBuilder {
    private String applicationPropertiesFile;
    private boolean freezen;
    private String sql;
    private String dbName;
    private String dbDriver;
    private String dbUrl;
    private String dbUser;
    private String dbPassword;
    private String validateSQL;
    private boolean usePool = false;
    private String refreshOption;
    private int batchSize = 1000;
    private String index;
    private String indexType;
    private String esIdField;
    private String esParentIdField;
    private String routingField;
    private String routingValue;
    private Boolean esDocAsUpsert;
    private Integer esRetryOnConflict;
    private Boolean esReturnSource;
    private String esVersionField;
    private String esVersionType;
    private Boolean useJavaName;
    private String dateFormat;
    private String locale;
    private String timeZone;
    private ResultSet resultSet;
    private StatementInfo statementInfo;
    private Map<String, FieldMeta> fieldMetaMap = new HashMap<String, FieldMeta>();

    private ImportBuilder() {
    }

    public static ImportBuilder newInstance() {
        return new ImportBuilder();
    }

    public ImportBuilder setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
        return this;
    }

    public ImportBuilder setStatementInfo(StatementInfo statementInfo) {
        this.statementInfo = statementInfo;
        return this;
    }

    private FieldMeta buildFieldMeta(String dbColumnName, String esFieldName, String dateFormat) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setDbColumnName(dbColumnName);
        fieldMeta.setEsFieldName(esFieldName);
        fieldMeta.setIgnore(false);
        fieldMeta.setDateFormateMeta(dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat));
        return fieldMeta;
    }

    private FieldMeta buildIgnoreFieldMeta(String dbColumnName) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setDbColumnName(dbColumnName);
        fieldMeta.setIgnore(true);
        return fieldMeta;
    }

    private FieldMeta buildFieldMeta(String dbColumnName, String esFieldName, String dateFormat, String locale, String timeZone) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setDbColumnName(dbColumnName);
        fieldMeta.setEsFieldName(esFieldName);
        fieldMeta.setIgnore(false);
        fieldMeta.setDateFormateMeta(dateFormat == null ? null : DateFormateMeta.buildDateFormateMeta((String)dateFormat, (String)locale, (String)timeZone));
        return fieldMeta;
    }

    public ImportBuilder addFieldMapping(String dbColumnName, String esFieldName) {
        this.fieldMetaMap.put(dbColumnName.toUpperCase(), this.buildFieldMeta(dbColumnName, esFieldName, null));
        return this;
    }

    public ImportBuilder addIgnoreFieldMapping(String dbColumnName) {
        this.fieldMetaMap.put(dbColumnName.toUpperCase(), this.buildIgnoreFieldMeta(dbColumnName));
        return this;
    }

    public ImportBuilder addFieldMapping(String dbColumnName, String esFieldName, String dateFormat) {
        this.fieldMetaMap.put(dbColumnName.toUpperCase(), this.buildFieldMeta(dbColumnName, esFieldName, dateFormat));
        return this;
    }

    public ImportBuilder addFieldMapping(String dbColumnName, String esFieldName, String dateFormat, String locale, String timeZone) {
        this.fieldMetaMap.put(dbColumnName.toUpperCase(), this.buildFieldMeta(dbColumnName, esFieldName, dateFormat, locale, timeZone));
        return this;
    }

    public ImportBuilder setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public ImportBuilder setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public ImportBuilder setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public ImportBuilder setUseJavaName(Boolean useJavaName) {
        this.useJavaName = useJavaName;
        return this;
    }

    public ImportBuilder setEsVersionType(String esVersionType) {
        this.esVersionType = esVersionType;
        return this;
    }

    public ImportBuilder setEsVersionField(String esVersionField) {
        this.esVersionField = esVersionField;
        return this;
    }

    public ImportBuilder setEsReturnSource(Boolean esReturnSource) {
        this.esReturnSource = esReturnSource;
        return this;
    }

    public ImportBuilder setEsRetryOnConflict(Integer esRetryOnConflict) {
        this.esRetryOnConflict = esRetryOnConflict;
        return this;
    }

    public ImportBuilder setEsDocAsUpsert(Boolean esDocAsUpsert) {
        this.esDocAsUpsert = esDocAsUpsert;
        return this;
    }

    public ImportBuilder setRoutingValue(String routingValue) {
        this.routingValue = routingValue;
        return this;
    }

    public ImportBuilder setRoutingField(String routingField) {
        this.routingField = routingField;
        return this;
    }

    public ImportBuilder setEsParentIdField(String esParentIdField) {
        this.esParentIdField = esParentIdField;
        return this;
    }

    public ImportBuilder setEsIdField(String esIdField) {
        this.esIdField = esIdField;
        return this;
    }

    private void buildDBConfig() {
        if (!this.freezen) {
            PropertiesContainer propertiesContainer = new PropertiesContainer();
            if (this.applicationPropertiesFile == null) {
                propertiesContainer.addConfigPropertiesFile("application.properties");
            } else {
                propertiesContainer.addConfigPropertiesFile(this.applicationPropertiesFile);
            }
            this.dbName = propertiesContainer.getProperty("db.name");
            this.dbUser = propertiesContainer.getProperty("db.user");
            this.dbPassword = propertiesContainer.getProperty("db.password");
            this.dbDriver = propertiesContainer.getProperty("db.driver");
            this.dbUrl = propertiesContainer.getProperty("db.url");
            String _usePool = propertiesContainer.getProperty("db.usePool");
            if (_usePool != null && !_usePool.equals("")) {
                this.usePool = Boolean.parseBoolean(_usePool);
            }
            this.validateSQL = propertiesContainer.getProperty("db.validateSQL");
        }
    }

    private ESJDBC buildESConfig() {
        ESJDBC esjdbcResultSet = new ESJDBC();
        esjdbcResultSet.setDateFormat(this.dateFormat);
        esjdbcResultSet.setLocale(this.locale);
        esjdbcResultSet.setTimeZone(this.timeZone);
        esjdbcResultSet.setEsDocAsUpsert(this.esDocAsUpsert);
        esjdbcResultSet.setEsIdField(this.esIdField);
        esjdbcResultSet.setEsParentIdField(this.esParentIdField);
        esjdbcResultSet.setEsRetryOnConflict(this.esRetryOnConflict);
        esjdbcResultSet.setEsReturnSource(this.esReturnSource);
        esjdbcResultSet.setEsVersionField(this.esVersionField);
        esjdbcResultSet.setEsVersionType(this.esVersionType);
        esjdbcResultSet.setRoutingField(this.routingField);
        esjdbcResultSet.setRoutingValue(this.routingValue);
        esjdbcResultSet.setUseJavaName(this.useJavaName);
        esjdbcResultSet.setFieldMetaMap(this.fieldMetaMap);
        esjdbcResultSet.setSql(this.sql);
        esjdbcResultSet.setDbName(this.dbName);
        esjdbcResultSet.setRefreshOption(this.refreshOption);
        esjdbcResultSet.setBatchSize(this.batchSize);
        esjdbcResultSet.setIndex(this.index);
        esjdbcResultSet.setIndexType(this.indexType);
        esjdbcResultSet.setDbDriver(this.dbDriver);
        esjdbcResultSet.setDbUrl(this.dbUrl);
        esjdbcResultSet.setDbUser(this.dbUser);
        esjdbcResultSet.setDbPassword(this.dbPassword);
        esjdbcResultSet.setValidateSQL(this.validateSQL);
        esjdbcResultSet.setApplicationPropertiesFile(this.applicationPropertiesFile);
        return esjdbcResultSet;
    }

    public DataStream builder() {
        this.buildDBConfig();
        ESJDBC esjdbcResultSet = this.buildESConfig();
        DataStream dataStream = new DataStream();
        dataStream.setEsjdbc(esjdbcResultSet);
        return dataStream;
    }

    public ImportBuilder setIndexType(String indexType) {
        this.indexType = indexType;
        return this;
    }

    public ImportBuilder setIndex(String index) {
        this.index = index;
        return this;
    }

    public ImportBuilder setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public ImportBuilder setRefreshOption(String refreshOption) {
        this.refreshOption = refreshOption;
        return this;
    }

    public ImportBuilder setDbName(String dbName) {
        this.freezen = true;
        this.dbName = dbName;
        return this;
    }

    public ImportBuilder setSql(String sql) {
        this.sql = sql;
        return this;
    }

    public ImportBuilder setDbDriver(String dbDriver) {
        this.freezen = true;
        this.dbDriver = dbDriver;
        return this;
    }

    public ImportBuilder setDbUrl(String dbUrl) {
        this.freezen = true;
        this.dbUrl = dbUrl;
        return this;
    }

    public ImportBuilder setDbUser(String dbUser) {
        this.freezen = true;
        this.dbUser = dbUser;
        return this;
    }

    public ImportBuilder setDbPassword(String dbPassword) {
        this.freezen = true;
        this.dbPassword = dbPassword;
        return this;
    }

    public ImportBuilder setValidateSQL(String validateSQL) {
        this.freezen = true;
        this.validateSQL = validateSQL;
        return this;
    }

    public ImportBuilder setUsePool(boolean usePool) {
        this.freezen = true;
        this.usePool = usePool;
        return this;
    }

    public String getApplicationPropertiesFile() {
        return this.applicationPropertiesFile;
    }

    public void setApplicationPropertiesFile(String applicationPropertiesFile) {
        this.applicationPropertiesFile = applicationPropertiesFile;
    }
}

