/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.common.poolman.SQLExecutor;
import com.frameworkset.common.poolman.StatementInfo;
import com.frameworkset.common.poolman.handle.NullRowHandler;
import com.frameworkset.common.poolman.handle.ResultSetHandler;
import com.frameworkset.common.poolman.util.SQLUtil;
import com.frameworkset.util.SimpleStringUtil;
import java.sql.ResultSet;
import org.frameworkset.elasticsearch.boot.ElasticSearchBoot;
import org.frameworkset.elasticsearch.client.ESDataImportException;
import org.frameworkset.elasticsearch.client.ESJDBC;
import org.frameworkset.elasticsearch.client.JDBCRestClientUtil;

public class DataStream {
    private ESJDBC esjdbc;

    public void db2es() throws ESDataImportException {
        if (this.esjdbc == null) {
            throw new ESDataImportException("ESJDBC is null.");
        }
        try {
            this.initES();
            this.initDS();
            this.importData();
        }
        catch (Exception e) {
            throw new ESDataImportException(e);
        }
    }

    public void setEsjdbc(ESJDBC esjdbc) {
        this.esjdbc = esjdbc;
    }

    private void initES() {
        if (SimpleStringUtil.isNotEmpty((String)this.esjdbc.getApplicationPropertiesFile())) {
            ElasticSearchBoot.boot((String)this.esjdbc.getApplicationPropertiesFile());
        }
    }

    private void initDS() {
        if (SimpleStringUtil.isNotEmpty((String)this.esjdbc.getDbDriver()) && SimpleStringUtil.isNotEmpty((String)this.esjdbc.getDbUrl())) {
            if (!this.esjdbc.isUsePool()) {
                SQLUtil.startNoPool((String)this.esjdbc.getDbName(), (String)this.esjdbc.getDbDriver(), (String)this.esjdbc.getDbUrl(), (String)this.esjdbc.getDbUser(), (String)this.esjdbc.getDbPassword(), (String)this.esjdbc.getValidateSQL());
            } else {
                SQLUtil.startPool((String)this.esjdbc.getDbName(), (String)this.esjdbc.getDbDriver(), (String)this.esjdbc.getDbUrl(), (String)this.esjdbc.getDbUser(), (String)this.esjdbc.getDbPassword(), (String)this.esjdbc.getValidateSQL());
            }
        }
    }

    private void importData() throws Exception {
        SQLExecutor.queryWithDBNameByNullRowHandler((NullRowHandler)new ResultSetHandler(){

            public void handleResult(ResultSet resultSet, StatementInfo statementInfo) throws Exception {
                DataStream.this.esjdbc.setResultSet(resultSet);
                DataStream.this.esjdbc.setMetaData(statementInfo.getMeta());
                JDBCRestClientUtil jdbcRestClientUtil = new JDBCRestClientUtil();
                jdbcRestClientUtil.addDocuments(DataStream.this.esjdbc.getIndex(), DataStream.this.esjdbc.getIndexType(), DataStream.this.esjdbc, DataStream.this.esjdbc.getRefreshOption(), DataStream.this.esjdbc.getBatchSize());
            }
        }, (String)this.esjdbc.getDbName(), (String)this.esjdbc.getSql(), (Object[])new Object[0]);
    }
}

