/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.ip2regionv2.xdb;

import com.frameworkset.util.DaemonThread;
import com.frameworkset.util.ResourceInitial;
import java.io.File;
import java.io.IOException;
import org.frameworkset.spi.geoip.IpInfo;
import org.frameworkset.spi.ip2region.IP2Region;
import org.frameworkset.spi.ip2region.IP2RegionException;
import org.frameworkset.spi.ip2region.Util;
import org.frameworkset.spi.ip2regionv2.xdb.Searcher;
import org.frameworkset.util.shutdown.ShutdownUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IP2RegionV2
implements IP2Region {
    private static final Logger logger = LoggerFactory.getLogger(IP2RegionV2.class);
    private Searcher searcher;
    private DaemonThread daemonThread;
    private String ip2regionDatabase;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(String ip2regionDatabase, boolean enableBtree) {
        if (this.searcher != null) {
            return;
        }
        IP2RegionV2 iP2RegionV2 = this;
        synchronized (iP2RegionV2) {
            if (this.searcher == null) {
                try {
                    Searcher searcher;
                    this.ip2regionDatabase = ip2regionDatabase;
                    byte[] cBuff = Searcher.loadContentFromFile(ip2regionDatabase);
                    this.searcher = searcher = Searcher.newWithBuffer(cBuff);
                    this.daemonThread = new DaemonThread(5000L, "ip2regionDatabase-Reload");
                    this.daemonThread.addFile(new File(ip2regionDatabase), new ResourceInitial(){

                        public void reinit() {
                            IP2RegionV2.this._reinit();
                        }
                    });
                    this.daemonThread.start();
                    ShutdownUtil.addShutdownHook((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            IP2RegionV2.this.daemonThread.stopped();
                            IP2RegionV2.this.closeDb();
                        }
                    });
                }
                catch (Exception e) {
                    if (logger.isErrorEnabled()) {
                        logger.error("Init ip2regionDatabase failed:" + ip2regionDatabase, (Throwable)e);
                    }
                    throw new IP2RegionException("Init ip2regionDatabase failed:" + ip2regionDatabase, e);
                }
            }
        }
    }

    private void closeDb() {
        if (this.searcher != null) {
            try {
                this.searcher.close();
            }
            catch (IOException e) {
                logger.debug("closeDb failed:", (Throwable)e);
            }
            this.searcher = null;
        }
    }

    private synchronized void _reinit() {
        block2: {
            final Searcher oldSearcher = this.searcher;
            try {
                Searcher searcher;
                byte[] cBuff = Searcher.loadContentFromFile(this.ip2regionDatabase);
                this.searcher = searcher = Searcher.newWithBuffer(cBuff);
                Thread t = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block8: {
                            3 var1_1 = this;
                            synchronized (var1_1) {
                                try {
                                    3.sleep(60000L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (oldSearcher != null) {
                                try {
                                    logger.info("Delay 60s and close old ip2region searcher database.");
                                    oldSearcher.close();
                                }
                                catch (Exception e) {
                                    if (!logger.isErrorEnabled()) break block8;
                                    logger.error("Reinit ip2region searcher database " + IP2RegionV2.this.ip2regionDatabase + " failed:", (Throwable)e);
                                }
                            }
                        }
                    }
                };
                t.start();
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error("Reinit ip2region searcher database " + this.ip2regionDatabase + " failed:", (Throwable)e);
            }
        }
    }

    private void assertInit() {
        if (this.searcher == null) {
            throw new IP2RegionException("ip2region searcher database " + this.ip2regionDatabase + " not inited.");
        }
    }

    @Override
    public IpInfo getIpInfo(String ip) {
        this.assertInit();
        if (!Util.isIpAddress(ip)) {
            return null;
        }
        try {
            String region = this.searcher.search(ip);
            if (region == null) {
                return null;
            }
            String[] infos = region.split("\\|");
            if (infos.length != 5) {
                return null;
            }
            IpInfo ipInfo = new IpInfo();
            ipInfo.setCountry(infos[0]);
            if (!infos[1].equals("0")) {
                ipInfo.setArea(infos[1]);
            }
            if (!infos[2].equals("0")) {
                ipInfo.setRegion(infos[2]);
            }
            if (!infos[3].equals("0")) {
                ipInfo.setCity(infos[3]);
            }
            if (!infos[4].equals("0")) {
                ipInfo.setIsp(infos[4]);
            }
            ipInfo.setIp(ip);
            return ipInfo;
        }
        catch (IOException e) {
            logger.error(ip, (Throwable)e);
            return null;
        }
        catch (Exception e) {
            logger.error(ip, (Throwable)e);
            return null;
        }
    }

    @Override
    public IpInfo getAddressMapResult(String ip) {
        return this.getIpInfo(ip);
    }
}

