/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.geoip;

import com.frameworkset.util.SimpleStringUtil;
import java.util.Map;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.spi.geoip.DefaultIPConverter;
import org.frameworkset.spi.geoip.GeoIPFilter;
import org.frameworkset.spi.geoip.IPConverter;
import org.frameworkset.spi.geoip.IpInfo;
import org.frameworkset.spi.ip2region.IP2Region;
import org.frameworkset.spi.ip2region.IP2RegionV1;
import org.frameworkset.spi.ip2regionv2.xdb.IP2RegionV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoIPUtil {
    private GeoIPFilter geoIPFilter;
    private IP2Region ip2Region;
    public static final String ip2RegionVersion_V1 = "V1";
    public static final String ip2RegionVersion_V2 = "V2";
    private String ip2RegionVersion = "V2";
    private Object ispConverter;
    private IPConverter _IPConverter;
    private String database;
    private String ip2regionDatabase;
    private String asnDatabase;
    private int cachesize;
    private String ipUrl;
    private static final Logger logger = LoggerFactory.getLogger(GeoIPUtil.class);
    private static boolean getGeoIPUtil;
    private static GeoIPUtil geoIPUtil;

    public Object getIspConverter() {
        return this.ispConverter;
    }

    public void setIp2RegionVersion(String ip2RegionVersion) {
        this.ip2RegionVersion = ip2RegionVersion;
    }

    public void setIspConverter(Object ispConverter) {
        this.ispConverter = ispConverter;
    }

    public GeoIPFilter getGeoIPFilter() {
        return this.geoIPFilter;
    }

    private boolean assertEmpty() {
        return SimpleStringUtil.isEmpty((String)this.database) || SimpleStringUtil.isEmpty((String)this.asnDatabase);
    }

    public void init() {
        if (!this.assertEmpty()) {
            if (this.ispConverter != null) {
                if (this.ispConverter instanceof IPConverter) {
                    this._IPConverter = (IPConverter)this.ispConverter;
                } else {
                    String cls = ((String)this.ispConverter).trim();
                    if (!cls.equals("")) {
                        try {
                            Class<?> clazz = Class.forName(cls);
                            this._IPConverter = (IPConverter)clazz.newInstance();
                        }
                        catch (ClassNotFoundException e) {
                            logger.warn(cls, (Throwable)e);
                            this._IPConverter = new DefaultIPConverter();
                        }
                        catch (IllegalAccessException e) {
                            logger.warn(cls, (Throwable)e);
                            this._IPConverter = new DefaultIPConverter();
                        }
                        catch (InstantiationException e) {
                            logger.warn(cls, (Throwable)e);
                            this._IPConverter = new DefaultIPConverter();
                        }
                    } else {
                        this._IPConverter = new DefaultIPConverter();
                    }
                }
            } else {
                this._IPConverter = new DefaultIPConverter();
            }
            this.geoIPFilter = new GeoIPFilter(this.database, this.asnDatabase, this.cachesize);
        }
        if (this.ip2regionDatabase != null && !this.ip2regionDatabase.equals("")) {
            IP2Region ip2Region;
            if (this.ip2RegionVersion.equals(ip2RegionVersion_V2)) {
                ip2Region = new IP2RegionV2();
                ((IP2RegionV2)ip2Region).init(this.ip2regionDatabase, false);
                this.ip2Region = ip2Region;
            } else {
                ip2Region = new IP2RegionV1();
                ((IP2RegionV1)ip2Region).init(this.ip2regionDatabase, false);
                this.ip2Region = ip2Region;
            }
        }
    }

    public void setGeoIPFilter(GeoIPFilter geoIPFilter) {
        this.geoIPFilter = geoIPFilter;
    }

    public String getAsnDatabase() {
        return this.asnDatabase;
    }

    public void setAsnDatabase(String asnDatabase) {
        this.asnDatabase = asnDatabase;
    }

    public String getIpUrl() {
        return this.ipUrl;
    }

    public void setIpUrl(String ipUrl) {
        this.ipUrl = ipUrl;
    }

    @Deprecated
    public String getAddressResult(String ip) {
        IpInfo ipInfo = this.getIpInfo(ip);
        if (ipInfo != null) {
            return SimpleStringUtil.object2json((Object)ipInfo);
        }
        return null;
    }

    @Deprecated
    public IpInfo getAddressMapResult(String ip) {
        return this.getIpInfo(ip);
    }

    public IpInfo getIpInfo(String ip) {
        IpInfo ipInfo = null;
        boolean needHandle = false;
        if (this.ip2Region != null) {
            ipInfo = this.ip2Region.getAddressMapResult(ip);
        }
        if (ipInfo == null) {
            ipInfo = new IpInfo();
            ipInfo.setIp(ip);
        } else {
            needHandle = true;
        }
        if (this.geoIPFilter != null) {
            this.geoIPFilter.handleIpInfo(ipInfo);
            needHandle = true;
        }
        if (ipInfo.getIsp() == null) {
            ipInfo.setIsp("\u672a\u77e5");
        }
        if (ipInfo.getCountry() == null) {
            ipInfo.setCountry("\u672a\u77e5");
        }
        if (ipInfo.getCounty() != null) {
            ipInfo.setCounty("\u672a\u77e5");
        }
        if (ipInfo.getRegion() == null) {
            ipInfo.setRegion("\u672a\u77e5");
        }
        if (ipInfo.getCity() == null) {
            ipInfo.setCity("\u672a\u77e5");
        }
        if (needHandle) {
            this._IPConverter.convert(ipInfo);
        }
        return ipInfo;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public int getCachesize() {
        return this.cachesize;
    }

    public void setCachesize(int cachesize) {
        this.cachesize = cachesize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeoIPUtil getGeoIPUtil(Map<String, Object> geoipConfig) {
        if (getGeoIPUtil) {
            return geoIPUtil;
        }
        Class<GeoIPUtil> clazz = GeoIPUtil.class;
        synchronized (GeoIPUtil.class) {
            if (getGeoIPUtil) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return geoIPUtil;
            }
            getGeoIPUtil = true;
            if (geoIPUtil == null) {
                try {
                    if (geoipConfig == null) {
                        geoipConfig = ElasticSearchHelper.getGeoipConfig();
                    }
                    if (geoipConfig == null || geoipConfig.size() == 0) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return null;
                    }
                    GeoIPUtil geoIPUtil = new GeoIPUtil();
                    geoIPUtil.setDatabase((String)geoipConfig.get("ip.database"));
                    geoIPUtil.setAsnDatabase((String)geoipConfig.get("ip.asnDatabase"));
                    geoIPUtil.setIp2regionDatabase((String)geoipConfig.get("ip.ip2regionDatabase"));
                    geoIPUtil.setIspConverter(geoipConfig.get("ip.ispConverter"));
                    String _cachsize = (String)geoipConfig.get("ip.cachesize");
                    if (_cachsize != null) {
                        try {
                            geoIPUtil.setCachesize(Integer.parseInt(_cachsize));
                        }
                        catch (Exception e) {
                            logger.info("getGeoIPUtil ip.cachesize must be a number:" + _cachsize, (Throwable)e);
                        }
                    }
                    geoIPUtil.setIpUrl((String)geoipConfig.get("ip.serviceUrl"));
                    geoIPUtil.init();
                    GeoIPUtil.geoIPUtil = geoIPUtil;
                }
                catch (Exception e) {
                    logger.info("getGeoIPUtil failed:", (Throwable)e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return geoIPUtil;
        }
    }

    public String getIp2regionDatabase() {
        return this.ip2regionDatabase;
    }

    public void setIp2regionDatabase(String ip2regionDatabase) {
        this.ip2regionDatabase = ip2regionDatabase;
    }
}

