/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.annotations;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class DateFormateMeta {
    private String dateformat;
    private Locale locale;
    private String locale_str;
    private String timeZone_str;
    private TimeZone timeZone;
    private SimpleDateFormat simpleDateFormat = null;
    private static Map<String, DateFormateMeta> baseDataformatMap = new HashMap<String, DateFormateMeta>(20);
    private static Map<String, DateFormateMeta> localDataformatMap = new HashMap<String, DateFormateMeta>(20);
    private static Map<String, DateFormateMeta> timeZoneDataformatMap = new HashMap<String, DateFormateMeta>(20);
    private static Map<String, DateFormateMeta> localTimeZoneDataformatMap = new HashMap<String, DateFormateMeta>(20);

    private DateFormateMeta() {
    }

    public String getDateformat() {
        return this.dateformat;
    }

    public SimpleDateFormat getOriginDateFormat() {
        return this.simpleDateFormat;
    }

    public DateFormat toDateFormat() {
        return this.toDateFormat(true);
    }

    private DateFormat toDateFormat(boolean clone) {
        if (this.simpleDateFormat == null) {
            SimpleDateFormat f = null;
            f = this.getLocale() == null ? new SimpleDateFormat(this.dateformat) : new SimpleDateFormat(this.dateformat, this.getLocale());
            if (this.getTimeZone() != null) {
                f.setTimeZone(this.getTimeZone());
            }
            this.simpleDateFormat = f;
        }
        if (clone) {
            return (DateFormat)this.simpleDateFormat.clone();
        }
        return this.simpleDateFormat;
    }

    void setDateformat(String dateformat) {
        this.dateformat = dateformat;
    }

    public Locale getLocale() {
        return this.locale;
    }

    void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getLocale_str() {
        return this.locale_str;
    }

    void setLocale_str(String locale_str) {
        this.locale_str = locale_str;
    }

    public String getTimeZone_str() {
        return this.timeZone_str;
    }

    void setTimeZone_str(String timeZone_str) {
        this.timeZone_str = timeZone_str;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("dateformat=").append(this.dateformat).append(",").append("locale=").append(this.locale_str).append(",").append("timeZone=").append(this.timeZone_str);
        return ret.toString();
    }

    public static DateFormateMeta buildDateFormateMeta(String dataformat, String _locale) {
        return DateFormateMeta.buildDateFormateMeta(dataformat, _locale, null);
    }

    public static DateFormateMeta buildDateFormateMeta(String dataformat) {
        return DateFormateMeta.buildDateFormateMeta(dataformat, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DateFormateMeta buildDateFormateMeta(String dataformat, String _locale, String timeZone) {
        if (dataformat == null) {
            return null;
        }
        if (_locale == null && timeZone == null) {
            DateFormateMeta dateFormateMeta = baseDataformatMap.get(dataformat);
            if (dateFormateMeta != null) {
                return dateFormateMeta;
            }
            Map<String, DateFormateMeta> map = baseDataformatMap;
            synchronized (map) {
                dateFormateMeta = baseDataformatMap.get(dataformat);
                if (dateFormateMeta != null) {
                    return dateFormateMeta;
                }
                dateFormateMeta = new DateFormateMeta();
                dateFormateMeta.setDateformat(dataformat);
                dateFormateMeta.toDateFormat(false);
                baseDataformatMap.put(dataformat, dateFormateMeta);
                return dateFormateMeta;
            }
        }
        if (_locale != null && timeZone != null) {
            String key = dataformat + "_" + _locale + "_" + timeZone;
            DateFormateMeta dateFormateMeta = localTimeZoneDataformatMap.get(key);
            if (dateFormateMeta != null) {
                return dateFormateMeta;
            }
            Map<String, DateFormateMeta> map = localTimeZoneDataformatMap;
            synchronized (map) {
                dateFormateMeta = localTimeZoneDataformatMap.get(key);
                if (dateFormateMeta != null) {
                    return dateFormateMeta;
                }
                dateFormateMeta = new DateFormateMeta();
                dateFormateMeta.setDateformat(dataformat);
                Locale locale = null;
                try {
                    locale = new Locale(_locale);
                    dateFormateMeta.setLocale(locale);
                }
                catch (Exception e) {
                    throw new RuntimeException("buildDateFormateMeta failed:", e);
                }
                dateFormateMeta.setLocale_str(_locale);
                try {
                    dateFormateMeta.setTimeZone(TimeZone.getTimeZone(timeZone));
                }
                catch (Exception e) {
                    throw new RuntimeException("buildDateFormateMeta failed:", e);
                }
                dateFormateMeta.setTimeZone_str(timeZone);
                dateFormateMeta.toDateFormat(false);
                localTimeZoneDataformatMap.put(key, dateFormateMeta);
                return dateFormateMeta;
            }
        }
        if (_locale != null) {
            String key = dataformat + "_" + _locale;
            DateFormateMeta dateFormateMeta = localDataformatMap.get(key);
            if (dateFormateMeta != null) {
                return dateFormateMeta;
            }
            Map<String, DateFormateMeta> map = localDataformatMap;
            synchronized (map) {
                dateFormateMeta = localDataformatMap.get(key);
                if (dateFormateMeta != null) {
                    return dateFormateMeta;
                }
                dateFormateMeta = new DateFormateMeta();
                dateFormateMeta.setDateformat(dataformat);
                Locale locale = null;
                try {
                    locale = new Locale(_locale);
                    dateFormateMeta.setLocale(locale);
                }
                catch (Exception e) {
                    throw new RuntimeException("buildDateFormateMeta failed:", e);
                }
                dateFormateMeta.setLocale_str(_locale);
                dateFormateMeta.toDateFormat(false);
                localDataformatMap.put(key, dateFormateMeta);
                return dateFormateMeta;
            }
        }
        String key = dataformat + "_" + timeZone;
        DateFormateMeta dateFormateMeta = timeZoneDataformatMap.get(key);
        if (dateFormateMeta != null) {
            return dateFormateMeta;
        }
        Map<String, DateFormateMeta> map = timeZoneDataformatMap;
        synchronized (map) {
            dateFormateMeta = timeZoneDataformatMap.get(key);
            if (dateFormateMeta != null) {
                return dateFormateMeta;
            }
            dateFormateMeta = new DateFormateMeta();
            dateFormateMeta.setDateformat(dataformat);
            try {
                dateFormateMeta.setTimeZone(TimeZone.getTimeZone(timeZone));
            }
            catch (Exception e) {
                throw new RuntimeException("buildDateFormateMeta failed:", e);
            }
            dateFormateMeta.setTimeZone_str(timeZone);
            dateFormateMeta.toDateFormat(false);
            timeZoneDataformatMap.put(key, dateFormateMeta);
            return dateFormateMeta;
        }
    }
}

