/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.assemble;

import com.frameworkset.util.ParserError;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.CallContext;
import org.frameworkset.spi.Lifecycle;
import org.frameworkset.spi.assemble.AOPValueHandler;
import org.frameworkset.spi.assemble.AssembleException;
import org.frameworkset.spi.assemble.AssembleUtil;
import org.frameworkset.spi.assemble.LinkConfigFile;
import org.frameworkset.spi.assemble.ManagerImport;
import org.frameworkset.spi.assemble.ManagerImportWrapper;
import org.frameworkset.spi.assemble.Pro;
import org.frameworkset.spi.assemble.ProArray;
import org.frameworkset.spi.assemble.ProList;
import org.frameworkset.spi.assemble.ProMap;
import org.frameworkset.spi.assemble.ProProperties;
import org.frameworkset.spi.assemble.ProSet;
import org.frameworkset.spi.assemble.PropertiesContainer;
import org.frameworkset.spi.assemble.ProviderManagerInfo;
import org.frameworkset.spi.assemble.ProviderParser;
import org.frameworkset.spi.assemble.RefID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class ServiceProviderManager
implements AOPValueHandler {
    private static Logger log = LoggerFactory.getLogger(ServiceProviderManager.class);
    public Map<String, Set> reverseAttrRefids = new LinkedHashMap<String, Set>();
    public Map<String, Set> reverseServiceRefids = new LinkedHashMap<String, Set>();
    public static final String ATTRIBUTE_PREFIX = "attr:";
    public static final String SERVICE_PREFIX = "service:";
    public static String defaultConfigFile = "manager-provider.xml";
    public static String seriralConfigFile = "org/frameworkset/soa/serialconf.xml";
    private Map<String, Pro> properties = new LinkedHashMap<String, Pro>();
    private Map parsedList = new LinkedHashMap();
    private static final Object trace = new Object();
    private List<LinkConfigFile> traceFiles;
    private Map managers = new LinkedHashMap();
    private ProviderManagerInfo defaultProviderManagerInfo;
    private Map managerimports = new LinkedHashMap();
    private BaseApplicationContext applicationContext;
    private boolean serial;
    private String charset = "UTF-8";
    private Map mutuxMangers;
    private boolean started = true;

    public void init(String configfile) {
        this.init("classpath::", "", configfile);
    }

    public void init(String docbaseType, String docbase, String configfile) {
        this.init(docbaseType, docbase, configfile, true);
    }

    public void init(String docbaseType, String docbase, InputStream instream) {
        this.init(docbaseType, docbase, instream, true);
    }

    public void init(String docbaseType, String docbase, String configfile, URL file) {
        block2: {
            try {
                this.loadFromURL(file);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block2;
                log.error("Load [" + defaultConfigFile + "]\u5931\u8d25", (Throwable)e);
            }
        }
    }

    protected ManagerImportWrapper sortManagerImports(List<ManagerImport> mis) {
        ManagerImportWrapper mi = new ManagerImportWrapper();
        mi.setImports(mis);
        return mi;
    }

    public void init(String docbaseType, String docbase, String configfile, boolean isfile) {
        block5: {
            try {
                if (this.applicationContext.isfile()) {
                    List<ManagerImport> mis = AssembleUtil.getManagerImports(docbaseType, docbase, configfile);
                    ManagerImportWrapper mi = this.sortManagerImports(mis);
                    mis = mi.getImports();
                    for (int i = 0; i < mis.size(); ++i) {
                        this.load(mis.get(i), mi.getParent());
                    }
                } else {
                    this.loadFromContent(configfile);
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block5;
                log.error("Load [" + configfile + "] failed", (Throwable)e);
            }
        }
    }

    public void init(String docbaseType, String docbase, InputStream instream, boolean isfile) {
        block2: {
            try {
                this.parseXML(instream);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block2;
                log.error("Load [" + defaultConfigFile + "]\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public ServiceProviderManager(BaseApplicationContext applicationContext) {
        this.traceFiles = new ArrayList<LinkConfigFile>();
        this.applicationContext = applicationContext;
    }

    public boolean isSerial() {
        return this.serial;
    }

    public void setSerial(boolean serial) {
        this.serial = serial;
    }

    public ServiceProviderManager(BaseApplicationContext applicationContext, String charset) {
        this.traceFiles = new ArrayList<LinkConfigFile>();
        this.applicationContext = applicationContext;
        this.charset = charset;
    }

    public void batchLoad(List imports, LinkConfigFile parentFile) {
        for (int i = 0; imports != null && i < imports.size(); ++i) {
            ManagerImport mi = (ManagerImport)imports.get(i);
            List<ManagerImport> resolvermis = AssembleUtil.getManagerImports(mi);
            for (int j = 0; j < resolvermis.size(); ++j) {
                try {
                    ManagerImport resolvermi = resolvermis.get(j);
                    this.load(resolvermi, parentFile);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean isParsered(String configfile) {
        return this.parsedList.containsKey(configfile);
    }

    public void load(ManagerImport managerImport, LinkConfigFile parentFile) {
        if (this.isParsered(managerImport.getFile())) {
            return;
        }
        this.parseXML(managerImport, parentFile);
        this.parsedList.put(managerImport.getFile(), trace);
    }

    public void loadFromContent(String content) {
        this.parseXML(content);
    }

    public void loadFromURL(URL content) {
        this.parseXML(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseXML(ManagerImport managerImport, LinkConfigFile parentFile) {
        block37: {
            String configFile;
            String url = configFile = managerImport.getRealPath();
            boolean isfile = false;
            PropertiesContainer propertiesContainer = null;
            try {
                if (managerImport.isClasspathBase()) {
                    URL confURL = ServiceProviderManager.class.getClassLoader().getResource(configFile);
                    if (confURL == null) {
                        confURL = ServiceProviderManager.class.getClassLoader().getResource("/" + configFile);
                    }
                    if (confURL == null) {
                        confURL = ServiceProviderManager.getTCL().getResource(configFile);
                    }
                    if (confURL == null) {
                        confURL = ServiceProviderManager.getTCL().getResource("/" + configFile);
                    }
                    if (confURL == null) {
                        confURL = ClassLoader.getSystemResource(configFile);
                    }
                    if (confURL == null) {
                        confURL = ClassLoader.getSystemResource("/" + configFile);
                    }
                    if (confURL == null) {
                        url = System.getProperty("user.dir");
                        File f = new File(url = url + "/" + configFile);
                        if (!f.exists()) {
                            // empty if block
                        }
                        url = configFile;
                        isfile = true;
                    } else {
                        url = confURL.toString();
                    }
                } else {
                    url = managerImport.getRealPath();
                }
                LinkConfigFile linkconfigFile = new LinkConfigFile(url, managerImport.getFile(), parentFile);
                ProviderParser handler = this._buildProviderParser(url, linkconfigFile);
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(false);
                factory.setValidating(false);
                SAXParser parser = factory.newSAXParser();
                if (managerImport.isClasspathBase()) {
                    if (!isfile) {
                        parser.parse(url, (DefaultHandler)handler);
                    } else {
                        File f = new File(url);
                        if (f.exists()) {
                            parser.parse(new File(url), (DefaultHandler)handler);
                        } else if (log.isDebugEnabled()) {
                            log.debug("Ignore load IOC xml file[" + url + "]:file do not exist.");
                        }
                    }
                } else {
                    File f = new File(url);
                    if (f.exists()) {
                        parser.parse(new File(url), (DefaultHandler)handler);
                    } else if (log.isDebugEnabled()) {
                        log.debug("Ignore load IOC xml file[" + url + "]:file do not exist.");
                    }
                }
                propertiesContainer = handler.getConfigPropertiesFile();
                this.addMangers(handler.getManagers());
                this.addProperties(handler.getProperties());
                if (parentFile == null || parentFile.isMultiRoot()) {
                    this.traceFiles.add(linkconfigFile);
                } else {
                    parentFile.addLinkConfigFile(linkconfigFile);
                }
                linkconfigFile.setMgrServices(handler.getManagers());
                linkconfigFile.setProperties(handler.getProperties());
                linkconfigFile.setConfigPropertiesFile(propertiesContainer);
                this.managerimports.put(linkconfigFile.getIdentity(), linkconfigFile);
                if (handler.getMangerimports() != null && handler.getMangerimports().size() > 0) {
                    this.batchLoad(handler.getMangerimports(), linkconfigFile);
                }
            }
            catch (Exception e) {
                if (configFile.equals(defaultConfigFile) || configFile.equals(seriralConfigFile)) {
                    String message = "\u4ece\u6587\u4ef6[" + configFile + "]\u88c5\u8f7d\u7ba1\u7406\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5b58\u5728\uff0c\u6216\u8005\u662f\u5426\u88ab\u6b63\u786e\u5b9a\u4e49\u3002";
                    if (log.isDebugEnabled()) {
                        log.debug(message, (Throwable)e);
                    }
                    if (this.applicationContext != null) {
                        ParserError parserError = new ParserError();
                        parserError.setMessage(message);
                        parserError.setException((Throwable)e);
                        this.applicationContext.setParserError(parserError);
                    }
                    break block37;
                }
                if (parentFile == null) {
                    String message = "\u4ece\u6587\u4ef6[" + url + "]\u88c5\u8f7d\u7ba1\u7406\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5b58\u5728\uff0c\u6216\u8005\u662f\u5426\u88ab\u6b63\u786e\u5b9a\u4e49\u3002";
                    if (log.isErrorEnabled()) {
                        log.error(message, (Throwable)e);
                    }
                    if (this.applicationContext != null) {
                        ParserError parserError = new ParserError();
                        parserError.setMessage(message);
                        parserError.setException((Throwable)e);
                        this.applicationContext.setParserError(parserError);
                    }
                    throw new RuntimeException(message, e);
                }
                String message = "\u4ece\u6587\u4ef6[" + parentFile + "@" + url + "]\u88c5\u8f7d\u7ba1\u7406\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5b58\u5728\uff0c\u6216\u8005\u662f\u5426\u88ab\u6b63\u786e\u5b9a\u4e49\u3002";
                if (log.isErrorEnabled()) {
                    log.error(message, (Throwable)e);
                }
                if (this.applicationContext != null) {
                    ParserError parserError = new ParserError();
                    parserError.setMessage(message);
                    parserError.setException((Throwable)e);
                    this.applicationContext.setParserError(parserError);
                }
                throw new RuntimeException(message, e);
            }
            finally {
                if (propertiesContainer != null) {
                    propertiesContainer.afterLoaded(this.applicationContext);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseXML(String content) {
        InputSource is = null;
        Reader reader = null;
        try {
            ProviderParser handler = this._buildProviderParser();
            handler.setSerial(this.serial);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            SAXParser parser = factory.newSAXParser();
            reader = new StringReader(content);
            is = new InputSource(reader);
            parser.parse(is, (DefaultHandler)handler);
            this.addProperties(handler.getProperties());
            handler = null;
        }
        catch (Exception e) {
            String message = "\u89e3\u6790\u62a5\u6587\u5185\u5bb9\u51fa\u9519[" + content + "]\uff0c\u8bf7\u68c0\u67e5\u62a5\u6587\u662f\u5426\u88ab\u6b63\u786e\u5b9a\u4e49\u3002";
            if (log.isErrorEnabled()) {
                log.error(message, (Throwable)e);
            }
            if (this.applicationContext != null) {
                ParserError parserError = new ParserError();
                parserError.setMessage(message);
                parserError.setException((Throwable)e);
                this.applicationContext.setParserError(parserError);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                    reader = null;
                }
                catch (Exception exception) {}
            }
            if (is != null) {
                is = null;
            }
        }
    }

    protected ProviderParser _buildProviderParser() {
        return new ProviderParser(this.getApplicationContext());
    }

    protected ProviderParser _buildProviderParser(String url, LinkConfigFile linkconfigFile) {
        return new ProviderParser(this.getApplicationContext(), url, linkconfigFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseXML(InputStream in) {
        try {
            ProviderParser handler = this._buildProviderParser();
            handler.setSerial(this.serial);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(in, (DefaultHandler)handler);
            this.addProperties(handler.getProperties());
            handler = null;
        }
        catch (Exception e) {
            String message = "\u89e3\u6790\u62a5\u6587\u5185\u5bb9\u51fa\u9519[" + in + "]\uff0c\u8bf7\u68c0\u67e5\u62a5\u6587\u662f\u5426\u88ab\u6b63\u786e\u5b9a\u4e49\u3002";
            if (log.isErrorEnabled()) {
                log.error(message, (Throwable)e);
            }
            if (this.applicationContext != null) {
                ParserError parserError = new ParserError();
                parserError.setMessage(message);
                parserError.setException((Throwable)e);
                this.applicationContext.setParserError(parserError);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseXML(URL contentFile) {
        String xmlFilePath = contentFile.toString();
        try {
            ProviderParser handler = this._buildProviderParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(xmlFilePath, (DefaultHandler)handler);
            this.addProperties(handler.getProperties());
            handler = null;
        }
        catch (Exception e) {
            String message = "\u89e3\u6790\u62a5\u6587\u5185\u5bb9\u51fa\u9519[" + xmlFilePath + "]\uff0c\u8bf7\u68c0\u67e5\u62a5\u6587\u662f\u5426\u88ab\u6b63\u786e\u5b9a\u4e49\u3002";
            if (log.isErrorEnabled()) {
                log.error(message, (Throwable)e);
            }
            if (this.applicationContext != null) {
                ParserError parserError = new ParserError();
                parserError.setMessage(message);
                parserError.setException((Throwable)e);
                this.applicationContext.setParserError(parserError);
            }
        }
    }

    public void addTopLevel(LinkConfigFile linkconfigFile) {
        this.traceFiles.add(linkconfigFile);
        this.managerimports.put(linkconfigFile.getIdentity(), linkconfigFile);
    }

    private static ClassLoader getTCL() throws IllegalAccessException, InvocationTargetException {
        Method method = null;
        try {
            method = Thread.class.getMethod("getContextClassLoader", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return (ClassLoader)method.invoke((Object)Thread.currentThread(), new Object[0]);
    }

    public ProviderManagerInfo getProviderManagerInfo(String providerManagerType) {
        return (ProviderManagerInfo)this.managers.get(providerManagerType);
    }

    public void addMangers(Map managers) {
        if (managers != null && managers.size() > 0) {
            this.managers.putAll(managers);
        }
    }

    public void addProperties(Map<String, Pro> properties) {
        if (properties != null && properties.size() > 0) {
            this.properties.putAll(properties);
        }
    }

    public ProviderManagerInfo getDefaultProviderManagerInfo() {
        return this.defaultProviderManagerInfo;
    }

    public void setDefaultProviderManagerInfo(ProviderManagerInfo defaultProviderManagerInfo) {
        this.defaultProviderManagerInfo = defaultProviderManagerInfo;
    }

    public Map getManagers() {
        if (this.mutuxMangers == null) {
            this.mutuxMangers = Collections.unmodifiableMap(this.managers);
        }
        return this.mutuxMangers;
    }

    public void addProviderManagerInfo(ProviderManagerInfo provider) {
        this.managers.put(provider.getId(), provider);
    }

    public List getTraceFiles() {
        return this.traceFiles;
    }

    public LinkConfigFile getLinkConfigFile(String id) {
        return (LinkConfigFile)this.managerimports.get(id);
    }

    public Set<String> getPropertyKeys() {
        return this.properties.keySet();
    }

    public boolean isEmpty() {
        return this.properties == null || this.properties.size() == 0;
    }

    public String getProperty(String name) {
        Pro pro = this.properties.get(name);
        if (pro == null) {
            return null;
        }
        String value = (String)pro.getValue();
        return value;
    }

    public Object getObjectProperty(String name) {
        return this.getObjectProperty(name, null);
    }

    public Object getObjectProperty(String name, Object defaultValue) {
        Pro pro = this.properties.get(name);
        if (pro == null) {
            log.debug("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + name + "]\uff01\u8fd4\u56de\u7f3a\u7701\u503c" + defaultValue);
            return defaultValue;
        }
        return pro.getObject(defaultValue);
    }

    public ProSet getSetProperty(String name) {
        Pro value = this.properties.get(name);
        if (value == null) {
            log.debug("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + name + "]\uff01");
            return null;
        }
        return value.getSet();
    }

    public ProSet getSetProperty(String name, ProSet defaultValue) {
        Pro value = this.properties.get(name);
        if (value == null) {
            log.debug("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + name + "]\uff01");
            return defaultValue;
        }
        return value.getSet(defaultValue);
    }

    public ProList getListProperty(String name) {
        Pro value = this.properties.get(name);
        if (value == null) {
            log.debug("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + name + "]\uff01");
            return null;
        }
        return value.getList();
    }

    public ProList getListProperty(String name, ProList defaultValue) {
        Pro value = this.properties.get(name);
        if (value == null) {
            log.debug("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + name + "]\uff01");
            return defaultValue;
        }
        return value.getList(defaultValue);
    }

    public ProMap getMapProperty(String name) {
        Pro value = this.properties.get(name);
        if (value == null) {
            log.debug("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + name + "]\uff01");
            return null;
        }
        return value.getMap();
    }

    public ProProperties getProProperties(String name) {
        Pro value = this.properties.get(name);
        if (value == null) {
            log.debug("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + name + "]\uff01");
            return null;
        }
        return value.getProProperties();
    }

    public ProMap getMapProperty(String name, ProMap defaultValue) {
        Pro value = this.properties.get(name);
        if (value == null) {
            log.debug("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + name + "]\uff01");
            return defaultValue;
        }
        return value.getMap();
    }

    public ProArray getArrayProperty(String name) {
        Pro value = this.properties.get(name);
        if (value == null) {
            log.debug("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + name + "]\uff01");
            return null;
        }
        return value.getArray();
    }

    public ProArray getArrayProperty(String name, ProArray defaultValue) {
        Pro value = this.properties.get(name);
        if (value == null) {
            log.debug("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + name + "]\uff01");
            return defaultValue;
        }
        return value.getArray(defaultValue);
    }

    public int getIntProperty(String name) {
        Pro value = this.properties.get(name);
        if (value == null) {
            throw new AssembleException("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + name + "]\uff01");
        }
        return value.getInt();
    }

    public long getLongProperty(String name) {
        Pro value = this.properties.get(name);
        if (value == null) {
            throw new AssembleException("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + name + "]\uff01");
        }
        return value.getLong();
    }

    public long getLongProperty(String name, long defaultvalue) {
        Pro value = this.properties.get(name);
        if (value == null) {
            return defaultvalue;
        }
        return value.getLong(defaultvalue);
    }

    public boolean getBooleanProperty(String name) {
        Pro value = this.properties.get(name);
        if (value == null) {
            throw new AssembleException("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + name + "]\uff01");
        }
        return value.getBoolean();
    }

    public Pro getPropertyBean(String name) {
        Pro pro = this.properties.get(name);
        if (pro == null) {
            if (log.isDebugEnabled()) {
                log.debug("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + name + "]\uff01");
            }
            return null;
        }
        return pro;
    }

    public String[] getBeanNamesForType(Class<Lifecycle> class1, boolean includeNonSingletons, boolean allowEagerInit) {
        Set<Map.Entry<String, Pro>> entrySet = this.properties.entrySet();
        Iterator<Map.Entry<String, Pro>> iterator = entrySet.iterator();
        ArrayList<String> names = new ArrayList<String>();
        while (iterator.hasNext()) {
            Map.Entry<String, Pro> entry = iterator.next();
            Pro pro = entry.getValue();
            if (!pro.isType(class1)) continue;
            names.add(entry.getKey());
        }
        return names.toArray(new String[names.size()]);
    }

    public String[] getDependenciesForBean(String beanName) {
        return null;
    }

    public String[] getDependentBeans(String beanName) {
        return null;
    }

    public boolean isFactoryBean(String beanNameToRegister) {
        Pro pro = this.getPropertyBean(beanNameToRegister);
        if (pro != null) {
            return pro.isFactoryBean();
        }
        return false;
    }

    public Class<?> getType(String beanNameToCheck) {
        Pro pro = this.getPropertyBean(beanNameToCheck);
        if (pro != null) {
            return pro.getType();
        }
        return null;
    }

    public Pro getInnerPropertyBean(RefID refid, String strrefid) {
        Pro pro = null;
        boolean firsted = true;
        Pro temp = null;
        do {
            int i;
            if (firsted) {
                pro = this.properties.get(refid.getName());
                firsted = false;
            } else {
                if (pro.isRefereced()) {
                    pro = this.getInnerPropertyBean(pro.getRefidLink(), pro.getRefid());
                }
                List<Pro> refs = pro.getReferences();
                pro = null;
                for (i = 0; i < refs.size(); ++i) {
                    temp = refs.get(i);
                    if (!temp.getName().equals(refid.getName())) continue;
                    pro = temp;
                    break;
                }
                if (pro == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + strrefid + "]\uff01");
                    }
                    return null;
                }
            }
            List indexs = refid.getIndexs();
            if (indexs == null || indexs.size() <= 0) continue;
            for (i = 0; i < indexs.size(); ++i) {
                RefID.Index index = (RefID.Index)indexs.get(i);
                pro = !index.isInconstruction() ? (index.getInt_idx() >= 0 ? (pro.isList() ? pro.getList().getPro(index.getInt_idx()) : (pro.isArray() ? pro.getArray().getPro(index.getInt_idx()) : pro.getSet().getPro(index.getInt_idx()))) : pro.getMap().getPro(index.getString_idx())) : pro.getConstructorParams().get(index.getInt_idx());
                if (!pro.isRefereced() || indexs.size() <= 1) continue;
                pro = this.getInnerPropertyBean(pro.getRefidLink(), pro.getRefid());
            }
        } while ((refid = refid.getNext()) != null);
        if (pro == null) {
            if (log.isDebugEnabled()) {
                log.debug("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + strrefid + "]\uff01");
            }
            return null;
        }
        return pro;
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            if (log.isDebugEnabled()) {
                log.debug("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + name + "]\uff01\u8fd4\u56de\u7f3a\u7701\u503c" + defaultValue);
            }
            return defaultValue;
        }
        return value;
    }

    public int getIntProperty(String name, int defaultValue) {
        Pro value = this.properties.get(name);
        if (value == null) {
            if (log.isDebugEnabled()) {
                log.debug("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + name + "]\uff01");
            }
            return defaultValue;
        }
        return value.getInt(defaultValue);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        Pro value = this.properties.get(name);
        if (value == null) {
            if (log.isDebugEnabled()) {
                log.debug("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + name + "]\uff01");
            }
            return defaultValue;
        }
        return value.getBoolean();
    }

    public Object getBeanObject(CallContext context, String name, Object defaultValue) {
        Pro pro = this.properties.get(name);
        if (pro == null) {
            if (log.isDebugEnabled()) {
                log.debug("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + name + "]\uff01\u8fd4\u56de\u7f3a\u7701\u503c" + defaultValue);
            }
            return defaultValue;
        }
        return pro.getBeanObject(context, defaultValue);
    }

    public Object getBeanObject(CallContext context, Pro providerManagerInfo) {
        return this.getBeanObject(context, providerManagerInfo, null);
    }

    public Object getBeanObject(CallContext context, Pro providerManagerInfo, Object defaultValue) {
        return providerManagerInfo.getBeanObject(context, defaultValue);
    }

    public BaseApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public synchronized void destroy() {
        this._destroy();
    }

    protected void _destroy() {
        if (!this.started) {
            return;
        }
        this.started = false;
        if (this.managerimports != null) {
            this.managerimports.clear();
        }
        if (this.managerimports != null) {
            this.managers.clear();
        }
        if (this.mutuxMangers != null) {
            this.mutuxMangers.clear();
        }
        if (this.reverseAttrRefids != null) {
            this.reverseAttrRefids.clear();
        }
        if (this.properties != null) {
            this.properties.clear();
        }
        if (this.reverseServiceRefids != null) {
            this.reverseServiceRefids.clear();
        }
        if (this.traceFiles != null) {
            this.traceFiles.clear();
        }
        this.serial = false;
    }

    public boolean containsBean(String themeSourceBeanName) {
        return this.properties.containsKey(themeSourceBeanName);
    }

    public String[] getStringArray(String key) {
        Pro value = this.properties.get(key);
        if (value == null) {
            throw new AssembleException("\u914d\u7f6e\u6587\u4ef6[" + this.applicationContext.getConfigfile() + "]\u4e2d\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027[" + key + "]\uff01");
        }
        return value.getStringArray();
    }

    public String[] getStringArray(String key, String[] defaultValues) {
        Pro value = this.properties.get(key);
        if (value == null) {
            return defaultValues;
        }
        return value.getStringArray(defaultValues);
    }

    public String getExternalProperty(String property) {
        String value = null;
        for (int i = 0; this.traceFiles != null && i < this.traceFiles.size(); ++i) {
            LinkConfigFile f = this.traceFiles.get(i);
            String string = value = f.getConfigPropertiesFile() != null ? f.getConfigPropertiesFile().getPropertyFromSelf2ndSons(property) : null;
            if (value != null) break;
        }
        return value;
    }

    public String getExternalProperty(String property, String defaultValue) {
        String value = null;
        for (int i = 0; this.traceFiles != null && i < this.traceFiles.size(); ++i) {
            LinkConfigFile f = this.traceFiles.get(i);
            String string = value = f.getConfigPropertiesFile() != null ? f.getConfigPropertiesFile().getPropertyFromSelf2ndSons(property) : null;
            if (value != null) break;
        }
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public Map getAllExternalProperties() {
        HashMap all = new HashMap();
        for (int i = 0; this.traceFiles != null && i < this.traceFiles.size(); ++i) {
            Map value;
            LinkConfigFile f = this.traceFiles.get(i);
            Map map = value = f.getConfigPropertiesFile() != null ? f.getConfigPropertiesFile().getAllExternalProperties() : null;
            if (value == null) continue;
            all.putAll(value);
        }
        return all;
    }

    public String getSystemEnvProperty(String property) {
        String value = this.getExternalProperty(property);
        if (value == null && (value = System.getProperty(property)) == null) {
            value = System.getenv(property);
        }
        return value;
    }

    public Object getExternalObjectProperty(String property, Object defaultValue) {
        String value = null;
        for (int i = 0; this.traceFiles != null && i < this.traceFiles.size(); ++i) {
            LinkConfigFile f = this.traceFiles.get(i);
            String string = value = f.getConfigPropertiesFile() != null ? f.getConfigPropertiesFile().getPropertyFromSelf2ndSons(property) : null;
            if (value != null) break;
        }
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public String getVarpre() {
        return "${";
    }

    @Override
    public String getVarend() {
        return "}";
    }

    @Override
    public boolean findVariableFromSelf() {
        return false;
    }

    @Override
    public String getEscapePre() {
        return null;
    }

    @Override
    public String getEscapeEnd() {
        return null;
    }

    @Override
    public void escapeValue(String value, StringBuilder builder) {
        builder.append(value);
    }

    @Override
    public String getEscapeRNPre() {
        return null;
    }

    @Override
    public String getEscapeRNEnd() {
        return null;
    }

    @Override
    public void escapeRN(String value, StringBuilder builder) {
        builder.append(value);
    }
}

