/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.soa;

import com.frameworkset.util.ValueObjectUtil;
import java.beans.IntrospectionException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.soa.SOAMethodCall;
import org.frameworkset.soa.SerialException;
import org.frameworkset.soa.SerialFactory;
import org.frameworkset.soa.SerialStack;
import org.frameworkset.spi.SOAApplicationContext;
import org.frameworkset.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectSerializable {
    public static final String content_header_gbk = "<?xml version=\"1.0\" encoding=\"gbk\"?>";
    public static final String content_header_utf_8 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String call_header = "<esb><call>";
    public static final String call_tailer = "</call></esb>";
    private static Logger logger = LoggerFactory.getLogger(ObjectSerializable.class);
    public static final String CHARSET_UTF_8 = "UTF-8";
    public static final String CHARSET_GBK = "GBK";
    public static final String[] throwable_filterattributes = new String[]{"message", "cause"};
    public static final String NULL_TYPE = "s:nvl";

    public static <T> T convertXMLToBeanObject(String name, String beanxml, Class<T> beantype) {
        SOAApplicationContext context = new SOAApplicationContext(beanxml);
        T object = context.getTBeanObject(name, beantype);
        context.destroy();
        return object;
    }

    private static void convertMethodCallToXMLMethod(Writer ret, String methodName, Object[] params, Class[] paramTypes, String charset) throws Exception {
        SerialStack stack = new SerialStack();
        ret.append("<p n=\"soamethodcall\" ").append("cs=\"org.frameworkset.soa.SOAMethodCall\" >").append("<p n=\"soamethodinfo\" cs=\"org.frameworkset.soa.SOAMethodInfo\" ").append("f:methodName=\"").append(methodName).append("\">");
        if (paramTypes == null || paramTypes.length == 0) {
            ret.append("<p n=\"params\" s:nvl=\"true\" s:t=\"").append(ValueObjectUtil.getSimpleTypeName(Object[].class)).append("\"/>");
        } else {
            ret.append("<p n=\"params\">").append("<a cmt=\"").append(ValueObjectUtil.getComponentTypeName(Object[].class)).append("\">");
            stack.addStack((Object)params, "params");
            ObjectSerializable.convertParams(ret, params, paramTypes, null, stack, "params");
            ret.append("</a></p>");
        }
        stack.clear();
        ret.append("</p></p>");
    }

    public static String convertMethodCallToXMLMethod(Method method, Object[] params, Class[] paramTypes, String charset) throws Exception {
        BBossStringWriter ret = null;
        try {
            ret = new BBossStringWriter();
            ret.append(call_header);
            ObjectSerializable.convertMethodCallToXMLMethod((Writer)ret, method.getName(), params, paramTypes, charset);
            ret.append(call_tailer);
            String string = ret.toString();
            return string;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            if (ret != null) {
                ret = null;
            }
        }
    }

    public static String convertSOAMethodCallToXMLMethod(SOAMethodCall method, String charset) throws Exception, IntrospectionException {
        BBossStringWriter ret = null;
        try {
            ret = new BBossStringWriter();
            ret.append(call_header);
            SerialStack stack = new SerialStack();
            ObjectSerializable.convertBeanObjectToXML("soamethodcall", method, method.getClass(), false, null, (Writer)ret, stack, "soamethodcall", false);
            stack.clear();
            ret.append(call_tailer);
            String string = ret.toString();
            return string;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            if (ret != null) {
                ret = null;
            }
        }
    }

    public static final String convertBeanObjectToXML(Object obj, Class type, String dateformat) throws Exception, IntrospectionException {
        BBossStringWriter ret = null;
        try {
            ret = new BBossStringWriter();
            SerialStack stack = new SerialStack();
            String name = UUID.randomUUID().toString();
            ObjectSerializable.convertBeanObjectToXML(name, obj, type, ValueObjectUtil.isBasePrimaryType((Class)type), dateformat, (Writer)ret, stack, name, false);
            stack.clear();
            String string = ret.toString();
            return string;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            if (ret != null) {
                ret = null;
            }
        }
    }

    public static final String convertBeanObjectToXML(String name, Object obj, Class type) throws Exception {
        return ObjectSerializable.convertBeanObjectToXML(name, obj, type, null, CHARSET_UTF_8);
    }

    public static final String toXML(Object obj) throws Exception {
        if (obj == null) {
            return null;
        }
        return ObjectSerializable.convertBeanObjectToXML("_dflt_", obj, obj.getClass(), null, CHARSET_UTF_8);
    }

    public static final String toXML(Object obj, String charset) throws Exception {
        if (obj == null) {
            return null;
        }
        return ObjectSerializable.convertBeanObjectToXML("_dflt_", obj, obj.getClass(), null, charset);
    }

    public static final void toXML(Object obj, Writer out) throws Exception {
        if (obj == null) {
            return;
        }
        ObjectSerializable.convertBeanObjectToXML("_dflt_", obj, obj.getClass(), null, CHARSET_UTF_8, out);
    }

    public static <T> T toBean(String beanxml, Class<T> beantype, String charset) {
        SOAApplicationContext context = new SOAApplicationContext(beanxml, charset, false);
        context.setSerial(true);
        context.init();
        T object = context.getTBeanObject("_dflt_", beantype);
        context.destroy();
        return object;
    }

    public static <T> T toBean(String beanxml, Class<T> beantype) {
        if (beanxml == null || beanxml.equals("")) {
            return null;
        }
        SOAApplicationContext context = new SOAApplicationContext(beanxml, false);
        context.setSerial(true);
        context.init();
        T object = context.getTBeanObject("_dflt_", beantype);
        context.destroy();
        return object;
    }

    public static <T> T toBean(InputStream instream, Class<T> beantype) {
        if (instream == null) {
            return null;
        }
        SOAApplicationContext context = new SOAApplicationContext(instream, false);
        context.setSerial(true);
        context.init();
        T object = context.getTBeanObject("_dflt_", beantype);
        context.destroy();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String convertBeanObjectToXML1(String name, Object obj, Class type, String dateformat, String charset) throws Exception {
        BBossStringWriter ret = null;
        try {
            ret = new BBossStringWriter();
            ObjectSerializable.convertBeanObjectToXML(name, obj, type, dateformat, charset, (Writer)ret);
            String string = ret.toString();
            return string;
        }
        finally {
            if (ret != null) {
                ret = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String convertBeanObjectToXML(String name, Object obj, Class type, String dateformat, String charset) throws Exception {
        BBossStringWriter ret = null;
        try {
            ret = new BBossStringWriter();
            ObjectSerializable.convertBeanObjectToXML(name, obj, type, dateformat, charset, (Writer)ret);
            String string = ret.toString();
            return string;
        }
        finally {
            if (ret != null) {
                ret = null;
            }
        }
    }

    public static final void convertBeanObjectToXML(String name, Object obj, Class ptype, String dateformat, String charset, Writer ret) throws Exception {
        try {
            ret.append("<ps>");
            SerialStack stack = new SerialStack();
            ObjectSerializable.convertBeanObjectToXML(name, obj, ptype, ValueObjectUtil.isBasePrimaryType((Class)ptype), dateformat, ret, stack, name, false);
            stack.clear();
            ret.append("</ps>");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final String convertBeanObjectToXML(Object obj, Class type) throws Exception {
        BBossStringWriter ret = new BBossStringWriter();
        try {
            SerialStack stack = new SerialStack();
            String name = UUID.randomUUID().toString();
            ObjectSerializable.convertBeanObjectToXML(name, obj, type, ValueObjectUtil.isBasePrimaryType((Class)type), null, (Writer)ret, stack, name, false);
            stack.clear();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return ret.toString();
    }

    public static final String convertBeanObjectsToXML(List<String> names, List<Object> objs, List<Class> types) throws Exception {
        return ObjectSerializable.convertBeanObjectsToXML(names, objs, types, CHARSET_UTF_8);
    }

    public static final String convertBeanObjectsToXML(List<String> names, List<Object> objs, List<Class> types, String charset) throws Exception {
        BBossStringWriter ret = null;
        try {
            ret = new BBossStringWriter();
            ret.append("<ps>");
            if (objs != null && objs.size() > 0) {
                int i = 0;
                SerialStack stack = new SerialStack();
                for (Object obj : objs) {
                    ObjectSerializable.convertBeanObjectToXML(names.get(i), obj, types.get(i), ValueObjectUtil.isBasePrimaryType((Class)types.get(i)), null, (Writer)ret, stack, names.get(i), false);
                    ++i;
                }
            }
            ret.append("</ps>");
            String i = ret.toString();
            return i;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            if (ret != null) {
                ret = null;
            }
        }
    }

    private static void arraytoxml(Writer ret, Object obj, String dateformat, String name, Class vtype, SerialStack serialStack, String currentAddress) throws Exception {
        if (obj == null) {
            if (name == null) {
                ret.append("<p s:nvl=\"true\" s:t=\"").append(ValueObjectUtil.getTypeName((Class)vtype)).append("\"/>");
            } else {
                ret.append("<p n=\"").append(name).append("\" s:nvl=\"true\" s:t=\"").append(ValueObjectUtil.getTypeName((Class)vtype)).append("\"/>");
            }
            return;
        }
        if (name == null) {
            ret.append("<p s:t=\"").append(ValueObjectUtil.getTypeName((Class)vtype)).append("\">");
        } else {
            ret.append("<p n=\"").append(name).append("\" s:t=\"").append(ValueObjectUtil.getTypeName((Class)vtype)).append("\">");
        }
        ret.append("<a cmt=\"").append(ValueObjectUtil.getComponentTypeName((Class)vtype)).append("\">");
        Object value = null;
        int len = Array.getLength(obj);
        for (int i = 0; i < len; ++i) {
            value = Array.get(obj, i);
            if (value == null) {
                ObjectSerializable.convertBeanObjectToXML(null, value, null, false, dateformat, ret, serialStack, currentAddress + "[" + i + "]", false);
                continue;
            }
            ObjectSerializable.convertBeanObjectToXML(null, value, value.getClass(), ValueObjectUtil.isBasePrimaryType(value.getClass()), dateformat, ret, serialStack, currentAddress + "[" + i + "]", false);
        }
        ret.append("</a>");
        ret.append("</p>");
    }

    private static void maptoxml(Writer ret, Object obj, String dateformat, String name, Class vtype, SerialStack serialStack, String currentAddress, ClassUtil.ClassInfo classInfo) throws Exception {
        if (obj == null) {
            if (name == null) {
                ret.append("<p s:nvl=\"true\" s:t=\"").append(ValueObjectUtil.getSimpleTypeName((Class)vtype)).append("\"/>");
            } else {
                ret.append("<p n=\"").append(name).append("\" s:nvl=\"true\" s:t=\"").append(ValueObjectUtil.getSimpleTypeName((Class)vtype)).append("\"/>");
            }
        } else if ((obj = ObjectSerializable.serialContainerObject(ret, obj, name, vtype, classInfo, false)) != null) {
            Map datas = (Map)obj;
            ret.append("<m cmt=\"bean\">");
            Object value = null;
            for (Map.Entry entry : datas.entrySet()) {
                value = entry.getValue();
                if (value == null) {
                    ObjectSerializable.convertBeanObjectToXML(String.valueOf(entry.getKey()), value, null, false, dateformat, ret, serialStack, currentAddress + "[" + entry.getKey() + "]", false);
                    continue;
                }
                ObjectSerializable.convertBeanObjectToXML(String.valueOf(entry.getKey()), value, value.getClass(), ValueObjectUtil.isBasePrimaryType(value.getClass()), dateformat, ret, serialStack, currentAddress + "[" + entry.getKey() + "]", false);
            }
            ret.append("</m>");
            ret.append("</p>");
        }
    }

    private static void propertiestoxml(Writer ret, Object obj, String dateformat, String name, Class vtype, SerialStack serialStack, String currentAddress, ClassUtil.ClassInfo classInfo) throws Exception {
        if (obj == null) {
            if (name == null) {
                ret.append("<p s:nvl=\"true\" s:t=\"").append(ValueObjectUtil.getSimpleTypeName((Class)vtype)).append("\"/>");
            } else {
                ret.append("<p n=\"").append(name).append("\" s:nvl=\"true\" s:t=\"").append(ValueObjectUtil.getSimpleTypeName((Class)vtype)).append("\"/>");
            }
        } else if ((obj = ObjectSerializable.serialContainerObject(ret, obj, name, vtype, classInfo, false)) != null) {
            Properties datas = (Properties)obj;
            ret.append("<propes>");
            Object value = null;
            for (Map.Entry<Object, Object> entry : datas.entrySet()) {
                value = entry.getValue();
                if (value == null) {
                    ObjectSerializable.convertBeanObjectToXML(String.valueOf(entry.getKey()), value, null, false, dateformat, ret, serialStack, currentAddress + "[" + entry.getKey() + "]", false);
                    continue;
                }
                ObjectSerializable.convertBeanObjectToXML(String.valueOf(entry.getKey()), value, value.getClass(), ValueObjectUtil.isBasePrimaryType(value.getClass()), dateformat, ret, serialStack, currentAddress + "[" + entry.getKey() + "]", false);
            }
            ret.append("</propes>");
            ret.append("</p>");
        }
    }

    private static void settoxml(Writer ret, Object obj, String dateformat, String name, Class vtype, SerialStack serialStack, String currentAddress, ClassUtil.ClassInfo classInfo) throws Exception {
        if (obj == null) {
            if (name == null) {
                ret.append("<p s:nvl=\"true\" s:t=\"").append(ValueObjectUtil.getSimpleTypeName((Class)vtype)).append("\"/>");
            } else {
                ret.append("<p n=\"").append(name).append("\" s:nvl=\"true\" s:t=\"").append(ValueObjectUtil.getSimpleTypeName((Class)vtype)).append("\"/>");
            }
        } else if ((obj = ObjectSerializable.serialContainerObject(ret, obj, name, vtype, classInfo, false)) != null) {
            Set datas = (Set)obj;
            ret.append("<s cmt=\"bean\">");
            Object value = null;
            Iterator itr = datas.iterator();
            int i = 0;
            while (itr.hasNext()) {
                value = itr.next();
                if (value == null) {
                    ObjectSerializable.convertBeanObjectToXML(null, value, null, false, dateformat, ret, serialStack, currentAddress + "[" + i + "]", false);
                } else {
                    ObjectSerializable.convertBeanObjectToXML(null, value, value.getClass(), ValueObjectUtil.isBasePrimaryType(value.getClass()), dateformat, ret, serialStack, currentAddress + "[" + i + "]", false);
                }
                ++i;
            }
            ret.append("</s>");
            ret.append("</p>");
        }
    }

    private static void pluginserial(Object obj, SerialFactory.MagicClass magicclass, String handleObjectClass, String name, Writer ret) throws IOException {
        String object = magicclass.getSerailObject().serialize(obj);
        if (name == null) {
            if (handleObjectClass != null) {
                ret.append("<p cs=\"").append(handleObjectClass).append("\" mg=\"").append(magicclass.getMagicnumber()).append("\">");
            } else {
                ret.append("<p mg=\"").append(magicclass.getMagicnumber()).append("\">");
            }
        } else if (handleObjectClass != null) {
            ret.append("<p cs=\"").append(handleObjectClass).append("\" n=\"").append(name).append("\" mg=\"").append(magicclass.getMagicnumber()).append("\">");
        } else {
            ret.append("<p n=\"").append(name).append("\" mg=\"").append(magicclass.getMagicnumber()).append("\">");
        }
        ret.append("<![CDATA[").append(object).append("]]></p>");
    }

    private static void appendmghead(String name, SerialFactory.MagicClass magicclass, String handleObjectClass, Writer ret, String className) throws IOException {
        if (name == null) {
            if (handleObjectClass != null) {
                ret.append("<p cs=\"").append(handleObjectClass).append("\" mg=\"").append(magicclass.getMagicnumber()).append("\">");
            } else {
                ret.append("<p mg=\"").append(magicclass.getMagicnumber()).append("\">");
            }
        } else if (handleObjectClass != null) {
            ret.append("<p cs=\"").append(handleObjectClass).append("\" n=\"").append(name).append("\" mg=\"").append(magicclass.getMagicnumber()).append("\">");
        } else {
            ret.append("<p n=\"").append(name).append("\" mg=\"").append(magicclass.getMagicnumber()).append("\">");
        }
    }

    private static Object serialContainerObject(Writer ret, Object obj, String name, Class vtype, ClassUtil.ClassInfo classInfo, boolean isobject) throws IOException {
        String className = classInfo.getName();
        SerialFactory.MagicClass magicclass = SerialFactory.getSerialFactory().getMagicClass(className);
        String handleObjectClass = null;
        if (magicclass != null) {
            if (magicclass.getPreserialObject() != null) {
                obj = magicclass.getPreserialObject().prehandle(obj);
                handleObjectClass = magicclass.getPreserialObject().getVClazz();
                if (handleObjectClass == null) {
                    handleObjectClass = obj.getClass().getName();
                }
                if (handleObjectClass.equals(className)) {
                    handleObjectClass = null;
                }
            }
            if (magicclass.getSerailObject() != null) {
                ObjectSerializable.pluginserial(obj, magicclass, handleObjectClass, name, ret);
                return null;
            }
            ObjectSerializable.appendmghead(name, magicclass, handleObjectClass, ret, className);
        } else {
            String typename = null;
            typename = isobject ? "cs" : "s:t";
            if (name == null) {
                ret.append("<p ").append(typename).append("=\"").append(ValueObjectUtil.getSimpleTypeName((Class)vtype)).append("\">");
            } else {
                ret.append("<p n=\"").append(name).append("\" ").append(typename).append("=\"").append(ValueObjectUtil.getSimpleTypeName((Class)vtype)).append("\">");
            }
        }
        return obj;
    }

    private static void listtoxml(Writer ret, Object obj, String dateformat, String name, Class vtype, SerialStack serialStack, String currentAddress, ClassUtil.ClassInfo classInfo) throws Exception {
        if (obj == null) {
            if (name == null) {
                ret.append("<p s:nvl=\"true\" s:t=\"").append(ValueObjectUtil.getSimpleTypeName((Class)vtype)).append("\"/>");
            } else {
                ret.append("<p n=\"").append(name).append("\" s:nvl=\"true\" s:t=\"").append(ValueObjectUtil.getSimpleTypeName((Class)vtype)).append("\"/>");
            }
            return;
        }
        if ((obj = ObjectSerializable.serialContainerObject(ret, obj, name, vtype, classInfo, false)) != null) {
            List datas = (List)obj;
            ret.append("<l cmt=\"bean\">");
            Object value = null;
            for (int i = 0; i < datas.size(); ++i) {
                value = datas.get(i);
                if (value == null) {
                    ObjectSerializable.convertBeanObjectToXML(null, value, null, false, dateformat, ret, serialStack, currentAddress + "[" + i + "]", false);
                    continue;
                }
                ObjectSerializable.convertBeanObjectToXML(null, value, value.getClass(), ValueObjectUtil.isBasePrimaryType(value.getClass()), dateformat, ret, serialStack, currentAddress + "[" + i + "]", false);
            }
            ret.append("</l>");
            ret.append("</p>");
        }
    }

    private static void stringtoxml(Writer ret, Object obj, String name, Class vtype) throws IOException {
        if (obj == null) {
            if (name == null) {
                ret.append("<p s:nvl=\"true\" s:t=\"String\"/>");
            } else {
                ret.append("<p n=\"").append(name).append("\" s:nvl=\"true\" s:t=\"String\"/>");
            }
        } else if (name == null) {
            ret.append("<p s:t=\"String\"><![CDATA[").append((String)obj).append("]]></p>");
        } else {
            ret.append("<p n=\"").append(name).append("\" s:t=\"String\"><![CDATA[").append((String)obj).append("]]></p>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filetoxml(Writer ret, Object obj, String name, Class vtype) throws IOException {
        if (obj == null) {
            if (name == null) {
                ret.append("<p s:nvl=\"true\" s:t=\"File\"/>");
            } else {
                ret.append("<p n=\"").append(name).append("\" s:nvl=\"true\" s:t=\"File\"/>");
            }
            return;
        }
        File object = (File)obj;
        FileInputStream byteIn = null;
        ByteArrayOutputStream fileOut = null;
        try {
            byteIn = new FileInputStream(object);
            fileOut = new ByteArrayOutputStream();
            byte[] v = new byte[1024];
            int i = 0;
            while ((i = byteIn.read(v)) > 0) {
                fileOut.write(v, 0, i);
            }
            fileOut.flush();
            if (name == null) {
                ret.append("<p s:t=\"File\"><![CDATA[").append(ValueObjectUtil.byteArrayEncoder((byte[])fileOut.toByteArray())).append("]]></p>");
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"File\"><![CDATA[").append(ValueObjectUtil.byteArrayEncoder((byte[])fileOut.toByteArray())).append("]]></p>");
            }
        }
        catch (FileNotFoundException e) {
            logger.warn("", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("", (Throwable)e);
        }
        finally {
            try {
                if (byteIn != null) {
                    byteIn.close();
                }
            }
            catch (Exception e) {}
            try {
                if (fileOut != null) {
                    fileOut.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bytearraytoxml(Writer ret, Object obj, String name, Class vtype) throws IOException {
        if (obj == null) {
            if (name == null) {
                ret.append("<p s:nvl=\"true\" s:t=\"").append(ValueObjectUtil.getSimpleTypeName((Class)vtype)).append("\"/>");
            } else {
                ret.append("<p n=\"").append(name).append("\" s:nvl=\"true\" s:t=\"").append(ValueObjectUtil.getSimpleTypeName((Class)vtype)).append("\"/>");
            }
            return;
        }
        if (!File.class.isAssignableFrom(vtype)) {
            if (name == null) {
                ret.append("<p s:t=\"").append(ValueObjectUtil.getSimpleTypeName((Class)vtype)).append("\"><![CDATA[").append(ValueObjectUtil.byteArrayEncoder((byte[])((byte[])obj))).append("]]></p>");
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"").append(ValueObjectUtil.getSimpleTypeName((Class)vtype)).append("\"><![CDATA[").append(ValueObjectUtil.byteArrayEncoder((byte[])((byte[])obj))).append("]]></p>");
            }
        } else {
            File object = (File)obj;
            FileInputStream byteIn = null;
            ByteArrayOutputStream fileOut = null;
            try {
                byteIn = new FileInputStream(object);
                fileOut = new ByteArrayOutputStream();
                byte[] v = new byte[1024];
                int i = 0;
                while ((i = byteIn.read(v)) > 0) {
                    fileOut.write(v, 0, i);
                }
                fileOut.flush();
                if (name == null) {
                    ret.append("<p s:t=\"").append(ValueObjectUtil.getSimpleTypeName((Class)vtype)).append("\"><![CDATA[").append(ValueObjectUtil.byteArrayEncoder((byte[])fileOut.toByteArray())).append("]]></p>");
                } else {
                    ret.append("<p n=\"").append(name).append("\" s:t=\"").append(ValueObjectUtil.getSimpleTypeName((Class)vtype)).append("\"><![CDATA[").append(ValueObjectUtil.byteArrayEncoder((byte[])fileOut.toByteArray())).append("]]></p>");
                }
            }
            catch (FileNotFoundException e) {
                logger.warn("", (Throwable)e);
            }
            catch (Exception e) {
                logger.warn("", (Throwable)e);
            }
            finally {
                try {
                    if (byteIn != null) {
                        byteIn.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (fileOut != null) {
                        fileOut.close();
                    }
                }
                catch (Exception e) {}
            }
        }
    }

    private static final void convertBeanObjectToXML(String name, Object obj, Class ptype, boolean pisbasetype, String dateformat, Writer ret, SerialStack serialStack, String currentAddress, boolean frombeanpropety) throws Exception {
        ClassUtil.ClassInfo classinfo = null;
        Class<?> vtype = null;
        if (obj != null) {
            if (!pisbasetype) {
                vtype = obj.getClass();
                classinfo = ClassUtil.getClassInfo(vtype);
                String address = serialStack.getRefID(obj);
                if (address != null) {
                    if (name == null) {
                        ret.append("<p refid=\"attr:").append(address).append("\"/>");
                    } else {
                        ret.append("<p n=\"").append(name).append("\" refid=\"attr:").append(address).append("\"/>");
                    }
                    return;
                }
                serialStack.addStack(obj, currentAddress);
            } else {
                vtype = ptype;
            }
        } else if (!frombeanpropety) {
            vtype = ptype;
        } else {
            return;
        }
        if (vtype == byte[].class) {
            ObjectSerializable.bytearraytoxml(ret, obj, name, vtype);
            return;
        }
        if (vtype != null && File.class.isAssignableFrom(vtype)) {
            ObjectSerializable.filetoxml(ret, obj, name, vtype);
            return;
        }
        if (vtype == String.class) {
            ObjectSerializable.stringtoxml(ret, obj, name, vtype);
            return;
        }
        if (vtype != null && List.class.isAssignableFrom(vtype)) {
            ObjectSerializable.listtoxml(ret, obj, dateformat, name, vtype, serialStack, currentAddress, classinfo);
            return;
        }
        if (vtype != null && Set.class.isAssignableFrom(vtype)) {
            ObjectSerializable.settoxml(ret, obj, dateformat, name, vtype, serialStack, currentAddress, classinfo);
        } else if (vtype != null && Properties.class.isAssignableFrom(vtype)) {
            ObjectSerializable.propertiestoxml(ret, obj, dateformat, name, vtype, serialStack, currentAddress, classinfo);
        } else if (vtype != null && Map.class.isAssignableFrom(vtype)) {
            ObjectSerializable.maptoxml(ret, obj, dateformat, name, vtype, serialStack, currentAddress, classinfo);
        } else if (vtype != null && vtype.isArray()) {
            ObjectSerializable.arraytoxml(ret, obj, dateformat, name, vtype, serialStack, currentAddress);
        } else {
            ObjectSerializable.basicTypeCast(name, obj, vtype, classinfo, dateformat, ret, serialStack, currentAddress);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean basicTypeCast(String name, Object obj, Class ptype, ClassUtil.ClassInfo classInfo, String dateformat, Writer ret, SerialStack stack, String currentAddress) throws Exception {
        if (obj == null) {
            if (name == null) {
                if (ptype != null) {
                    ret.append("<p s:nvl=\"true\" s:t=\"").append(ValueObjectUtil.getSimpleTypeName((Class)ptype)).append("\"/>");
                    return true;
                } else {
                    ret.append("<p s:nvl=\"true\"/>");
                }
                return true;
            } else if (ptype != null) {
                ret.append("<p n=\"").append(name).append("\" s:nvl=\"true\" s:t=\"").append(ValueObjectUtil.getSimpleTypeName((Class)ptype)).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:nvl=\"true\"/>");
            }
            return true;
        }
        Class<?> vtype = obj.getClass();
        if (ptype == String.class) {
            if (name == null) {
                ret.append("<p s:t=\"String\" v=\"").append(obj.toString()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"String\" v=\"").append(obj.toString()).append("\"/>");
            }
            return true;
        }
        if (ptype == Long.TYPE) {
            if (name == null) {
                ret.append("<p s:t=\"long\" v=\"").append(obj.toString()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"long\" v=\"").append(obj.toString()).append("\"/>");
            }
            return true;
        }
        if (ptype == Long.class) {
            if (name == null) {
                ret.append("<p s:t=\"Long\" v=\"").append(obj.toString()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"Long\" v=\"").append(obj.toString()).append("\"/>");
            }
            return true;
        }
        if (ptype == Integer.TYPE) {
            if (name == null) {
                ret.append("<p s:t=\"int\" v=\"").append(obj.toString()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"int\" v=\"").append(obj.toString()).append("\"/>");
            }
            return true;
        }
        if (ptype == Integer.class) {
            if (name == null) {
                ret.append("<p s:t=\"Integer\" v=\"").append(obj.toString()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"Integer\" v=\"").append(obj.toString()).append("\"/>");
            }
            return true;
        }
        if (ptype == Float.TYPE) {
            if (name == null) {
                ret.append("<p s:t=\"float\" v=\"").append(obj.toString()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"float\" v=\"").append(obj.toString()).append("\"/>");
            }
            return true;
        }
        if (ptype == Float.class) {
            if (name == null) {
                ret.append("<p s:t=\"Float\" v=\"").append(obj.toString()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"Float\" v=\"").append(obj.toString()).append("\"/>");
            }
            return true;
        }
        if (ptype == Short.TYPE) {
            if (name == null) {
                ret.append("<p s:t=\"short\" v=\"").append(obj.toString()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"short\" v=\"").append(obj.toString()).append("\"/>");
            }
            return true;
        }
        if (ptype == Short.class) {
            if (name == null) {
                ret.append("<p s:t=\"Short\" v=\"").append(obj.toString()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"Short\" v=\"").append(obj.toString()).append("\"/>");
            }
            return true;
        }
        if (ptype == Double.TYPE) {
            if (name == null) {
                ret.append("<p s:t=\"double\" v=\"").append(obj.toString()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"double\" v=\"").append(obj.toString()).append("\"/>");
            }
            return true;
        }
        if (ptype == Double.class) {
            if (name == null) {
                ret.append("<p s:t=\"Double\" v=\"").append(obj.toString()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"Double\" v=\"").append(obj.toString()).append("\"/>");
            }
            return true;
        }
        if (ptype == Character.TYPE) {
            if (name == null) {
                ret.append("<p s:t=\"char\" v=\"").append(obj.toString()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"char\" v=\"").append(obj.toString()).append("\"/>");
            }
            return true;
        }
        if (ptype == Character.class) {
            if (name == null) {
                ret.append("<p s:t=\"Character\" v=\"").append(obj.toString()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"Character\" v=\"").append(obj.toString()).append("\"/>");
            }
            return true;
        }
        if (ptype == Boolean.TYPE) {
            if (name == null) {
                ret.append("<p s:t=\"boolean\" v=\"").append(obj.toString()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"boolean\" v=\"").append(obj.toString()).append("\"/>");
            }
            return true;
        }
        if (ptype == Boolean.class) {
            if (name == null) {
                ret.append("<p s:t=\"Boolean\" v=\"").append(obj.toString()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"Boolean\" v=\"").append(obj.toString()).append("\"/>");
            }
            return true;
        }
        if (ptype == Byte.TYPE) {
            if (name == null) {
                ret.append("<p s:t=\"byte\" v=\"").append(obj.toString()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"byte\" v=\"").append(obj.toString()).append("\"/>");
            }
            return true;
        }
        if (ptype == Byte.class) {
            if (name == null) {
                ret.append("<p s:t=\"Byte\" v=\"").append(obj.toString()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"Byte\" v=\"").append(obj.toString()).append("\"/>");
            }
            return true;
        }
        if (Date.class.isAssignableFrom(vtype)) {
            long value = ((Date)obj).getTime();
            if (name == null) {
                ret.append("<p s:t=\"").append(ValueObjectUtil.getSimpleTypeName(vtype)).append("\" v=\"").append(String.valueOf(value)).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"").append(ValueObjectUtil.getSimpleTypeName(vtype)).append("\" v=\"").append(String.valueOf(value)).append("\"/>");
            }
            return true;
        }
        if (vtype == BigInteger.class) {
            if (name == null) {
                ret.append("<p s:t=\"bigint\" v=\"").append(obj.toString()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"bigint\" v=\"").append(obj.toString()).append("\"/>");
            }
            return true;
        }
        if (vtype == BigDecimal.class) {
            if (name == null) {
                ret.append("<p s:t=\"bigdecimal\" v=\"").append(obj.toString()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"bigdecimal\" v=\"").append(obj.toString()).append("\"/>");
            }
            return true;
        }
        if (ptype == Class.class) {
            if (name == null) {
                ret.append("<p s:t=\"Class\" v=\"").append(((Class)obj).getName()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"Class\" v=\"").append(((Class)obj).getName()).append("\"/>");
            }
            return true;
        }
        if (vtype.isEnum()) {
            if (name == null) {
                ret.append("<p s:t=\"").append(ValueObjectUtil.getSimpleTypeName(vtype)).append("\" v=\"").append(obj.toString()).append("\"/>");
                return true;
            } else {
                ret.append("<p n=\"").append(name).append("\" s:t=\"").append(ValueObjectUtil.getSimpleTypeName(vtype)).append("\" v=\"").append(obj.toString()).append("\"/>");
            }
            return true;
        }
        if (StackTraceElement.class.isAssignableFrom(vtype)) {
            if ((obj = ObjectSerializable.serialContainerObject(ret, obj, name, vtype, classInfo, true)) == null) return true;
            ObjectSerializable.appendStackTraceElementProperties(obj, vtype, dateformat, ret, stack, currentAddress);
        } else if (Throwable.class.isAssignableFrom(vtype)) {
            if ((obj = ObjectSerializable.serialContainerObject(ret, obj, name, vtype, classInfo, true)) == null) return true;
            ObjectSerializable.appendThrowableProperties(obj, vtype, dateformat, ret, stack, currentAddress);
        } else {
            if ((obj = ObjectSerializable.serialContainerObject(ret, obj, name, vtype, classInfo, true)) == null) return true;
            ObjectSerializable.appendBeanProperties(obj, vtype, classInfo, dateformat, ret, stack, currentAddress);
        }
        ret.append("</p>");
        return true;
    }

    private static void appendThrowableProperties(Object obj, Class type, String dateformat, Writer ret, SerialStack stack, String currentAddress) throws Exception {
        ret.append("<construction>");
        try {
            Object value = ValueObjectUtil.getValue((Object)obj, (String)"message");
            StringBuilder temp = new StringBuilder();
            temp.append(currentAddress).append("{0}");
            ObjectSerializable.convertBeanObjectToXML("message", value, String.class, true, dateformat, ret, stack, temp.toString(), false);
            value = ValueObjectUtil.getValue((Object)obj, (String)"cause");
            if (value != null) {
                temp.setLength(0);
                temp.append(currentAddress).append("{1}");
                ObjectSerializable.convertBeanObjectToXML("cause", value, value.getClass(), false, dateformat, ret, stack, temp.toString(), false);
            }
        }
        catch (SerialException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerialException("", e);
        }
        ret.append("</construction>");
        ObjectSerializable.appendBeanProperties(obj, type, ClassUtil.getClassInfo((Class)type), dateformat, ret, throwable_filterattributes, stack, currentAddress);
    }

    private static void appendStackTraceElementProperties(Object obj, Class type, String dateformat, Writer ret, SerialStack serialStack, String currentAddress) throws Exception {
        ret.append("<construction>");
        try {
            StringBuilder temp = new StringBuilder();
            String addr = null;
            Object value = ValueObjectUtil.getValue((Object)obj, (String)"className");
            temp.append(currentAddress).append("{0}");
            addr = temp.toString();
            temp.setLength(0);
            ObjectSerializable.convertBeanObjectToXML("declaringClass", value, String.class, true, dateformat, ret, serialStack, addr, false);
            value = ValueObjectUtil.getValue((Object)obj, (String)"methodName");
            temp.append(currentAddress).append("{1}");
            addr = temp.toString();
            temp.setLength(0);
            ObjectSerializable.convertBeanObjectToXML("methodName", value, String.class, true, dateformat, ret, serialStack, addr, false);
            value = ValueObjectUtil.getValue((Object)obj, (String)"fileName");
            temp.append(currentAddress).append("{2}");
            addr = temp.toString();
            temp.setLength(0);
            ObjectSerializable.convertBeanObjectToXML("fileName", value, String.class, true, dateformat, ret, serialStack, addr, false);
            value = ValueObjectUtil.getValue((Object)obj, (String)"lineNumber");
            temp.append(currentAddress).append("{3}");
            addr = temp.toString();
            temp.setLength(0);
            ObjectSerializable.convertBeanObjectToXML("lineNumber", value, Integer.TYPE, true, dateformat, ret, serialStack, addr, false);
        }
        catch (SerialException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerialException("", e);
        }
        ret.append("</construction>");
    }

    private static void appendBeanProperties(Object obj, Class type, ClassUtil.ClassInfo beanInfo, String dateformat, Writer ret, SerialStack stack, String currentAddress) throws Exception {
        ObjectSerializable.appendBeanProperties(obj, type, beanInfo, dateformat, ret, null, stack, currentAddress);
    }

    private static boolean isexclusive(String name, String[] filters) {
        if (filters == null || filters.length == 0) {
            return false;
        }
        for (String filter : filters) {
            if (!name.equals(filter)) continue;
            return true;
        }
        return false;
    }

    private static void appendBeanProperties(Object obj, Class type1, ClassUtil.ClassInfo beanInfo, String dateformat, Writer ret, String[] filters, SerialStack stack, String currentAddress) throws Exception {
        List attributes = beanInfo.getPropertyDescriptors();
        StringBuilder temp = new StringBuilder();
        String addr = null;
        for (int n = 0; attributes != null && n < attributes.size(); ++n) {
            ClassUtil.PropertieDescription propertyDescriptor = (ClassUtil.PropertieDescription)attributes.get(n);
            String attrName = propertyDescriptor.getName();
            if (ObjectSerializable.isexclusive(attrName, filters)) continue;
            Class<?> ptype = propertyDescriptor.getPropertyType();
            if (!propertyDescriptor.canseriable()) continue;
            try {
                Object value = propertyDescriptor.getValue(obj);
                boolean pisbasetype = ValueObjectUtil.isBasePrimaryType((Class)ptype);
                if (!pisbasetype && value != null && ValueObjectUtil.isBasePrimaryType(value.getClass())) {
                    pisbasetype = true;
                    ptype = value.getClass();
                }
                temp.append(currentAddress).append("->").append(attrName);
                addr = temp.toString();
                temp.setLength(0);
                ObjectSerializable.convertBeanObjectToXML(attrName, value, ptype, pisbasetype, dateformat, ret, stack, addr, true);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new SerialException("", e);
            }
            catch (IllegalAccessException e) {
                throw new SerialException("", e);
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (SerialFactory.getSerialFactory().isIgnoreException(target)) continue;
                throw new SerialException("", target);
            }
            catch (SerialException e) {
                throw e;
            }
            catch (Exception e) {
                if (SerialFactory.getSerialFactory().isIgnoreException(e)) continue;
                throw new SerialException("", e);
            }
        }
    }

    private static void convertParams(Writer ret, Object[] params, Class[] paramTypes, String dateformat, SerialStack stack, String currentAddress) throws Exception {
        StringBuilder temp = new StringBuilder();
        String addr = null;
        for (int i = 0; i < params.length; ++i) {
            temp.append(currentAddress).append("[").append(i).append("]");
            addr = temp.toString();
            temp.setLength(0);
            ObjectSerializable.convertBeanObjectToXML(null, params[i], paramTypes[i], ValueObjectUtil.isBasePrimaryType((Class)paramTypes[i]), dateformat, ret, stack, addr, false);
        }
    }
}

