/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.converts;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.ClickHouseTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.DB2TypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.DmTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.FirebirdTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.GaussDBSqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.KingbaseESTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.MySqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.OracleTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.OscarTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.PostgreSqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.SqlServerTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.SqliteTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.select.BranchBuilder;
import com.baomidou.mybatisplus.generator.config.converts.select.Selector;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;

public class TypeConverts {
    public static ITypeConvert getTypeConvert(DbType dbType) {
        switch (dbType) {
            case ORACLE: {
                return OracleTypeConvert.INSTANCE;
            }
            case DB2: {
                return DB2TypeConvert.INSTANCE;
            }
            case DM: 
            case GAUSS: {
                return DmTypeConvert.INSTANCE;
            }
            case GAUSS_DB: {
                return GaussDBSqlTypeConvert.INSTANCE;
            }
            case KINGBASE_ES: {
                return KingbaseESTypeConvert.INSTANCE;
            }
            case OSCAR: {
                return OscarTypeConvert.INSTANCE;
            }
            case MYSQL: 
            case MARIADB: {
                return MySqlTypeConvert.INSTANCE;
            }
            case POSTGRE_SQL: {
                return PostgreSqlTypeConvert.INSTANCE;
            }
            case SQLITE: {
                return SqliteTypeConvert.INSTANCE;
            }
            case SQL_SERVER: {
                return SqlServerTypeConvert.INSTANCE;
            }
            case FIREBIRD: {
                return FirebirdTypeConvert.INSTANCE;
            }
            case CLICK_HOUSE: {
                return ClickHouseTypeConvert.INSTANCE;
            }
        }
        return null;
    }

    static Selector<String, IColumnType> use(String param) {
        return new Selector<String, IColumnType>(param.toLowerCase());
    }

    static BranchBuilder<String, IColumnType> contains(CharSequence value) {
        return BranchBuilder.of(s -> s.contains(value));
    }

    static BranchBuilder<String, IColumnType> containsAny(CharSequence ... values) {
        return BranchBuilder.of(s -> {
            for (CharSequence value : values) {
                if (!s.contains(value)) continue;
                return true;
            }
            return false;
        });
    }
}

