/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.openapi.risknet;

import com.aliyun.common.Common;
import com.aliyun.tea.Tea;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.TeaUnretryableException;
import com.aliyun.teautil.models.RuntimeOptions;
import com.antgroup.antchain.openapi.antchain.util.AntchainUtils;
import com.antgroup.antchain.openapi.risknet.models.Config;
import com.antgroup.antchain.openapi.risknet.models.QueryGeneralRequest;
import com.antgroup.antchain.openapi.risknet.models.QueryGeneralResponse;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class Client {
    public String _endpoint;
    public String _regionId;
    public String _accessKeyId;
    public String _accessKeySecret;
    public String _protocol;
    public String _userAgent;
    public Number _readTimeout;
    public Number _connectTimeout;
    public String _httpProxy;
    public String _httpsProxy;
    public String _socks5Proxy;
    public String _socks5NetWork;
    public String _noProxy;
    public Number _maxIdleConns;
    public String _securityToken;
    public Number _maxIdleTimeMillis;
    public Number _keepAliveDurationMillis;
    public Number _maxRequests;
    public Number _maxRequestsPerHost;

    public Client(Config config) throws Exception {
        if (com.aliyun.teautil.Common.isUnset((Object)TeaModel.buildMap((TeaModel)config))) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'config' can not be unset")}));
        }
        this._accessKeyId = config.accessKeyId;
        this._accessKeySecret = config.accessKeySecret;
        this._securityToken = config.securityToken;
        this._endpoint = config.endpoint;
        this._protocol = config.protocol;
        this._userAgent = config.userAgent;
        this._readTimeout = com.aliyun.teautil.Common.defaultNumber((Number)config.readTimeout, (Number)20000);
        this._connectTimeout = com.aliyun.teautil.Common.defaultNumber((Number)config.connectTimeout, (Number)20000);
        this._httpProxy = config.httpProxy;
        this._httpsProxy = config.httpsProxy;
        this._noProxy = config.noProxy;
        this._socks5Proxy = config.socks5Proxy;
        this._socks5NetWork = config.socks5NetWork;
        this._maxIdleConns = com.aliyun.teautil.Common.defaultNumber((Number)config.maxIdleConns, (Number)60000);
        this._maxIdleTimeMillis = com.aliyun.teautil.Common.defaultNumber((Number)config.maxIdleTimeMillis, (Number)5);
        this._keepAliveDurationMillis = com.aliyun.teautil.Common.defaultNumber((Number)config.keepAliveDurationMillis, (Number)5000);
        this._maxRequests = com.aliyun.teautil.Common.defaultNumber((Number)config.maxRequests, (Number)100);
        this._maxRequestsPerHost = com.aliyun.teautil.Common.defaultNumber((Number)config.maxRequestsPerHost, (Number)100);
    }

    public Map<String, ?> doRequest(String version, String action, String protocol, String method, String pathname, Map<String, ?> request, Map<String, String> headers, RuntimeOptions runtime) throws Exception {
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("timeouted", (Object)"retry"), new TeaPair("readTimeout", (Object)com.aliyun.teautil.Common.defaultNumber((Number)runtime.readTimeout, (Number)this._readTimeout)), new TeaPair("connectTimeout", (Object)com.aliyun.teautil.Common.defaultNumber((Number)runtime.connectTimeout, (Number)this._connectTimeout)), new TeaPair("httpProxy", (Object)com.aliyun.teautil.Common.defaultString((String)runtime.httpProxy, (String)this._httpProxy)), new TeaPair("httpsProxy", (Object)com.aliyun.teautil.Common.defaultString((String)runtime.httpsProxy, (String)this._httpsProxy)), new TeaPair("noProxy", (Object)com.aliyun.teautil.Common.defaultString((String)runtime.noProxy, (String)this._noProxy)), new TeaPair("maxIdleConns", (Object)com.aliyun.teautil.Common.defaultNumber((Number)runtime.maxIdleConns, (Number)this._maxIdleConns)), new TeaPair("maxIdleTimeMillis", (Object)this._maxIdleTimeMillis), new TeaPair("keepAliveDurationMillis", (Object)this._keepAliveDurationMillis), new TeaPair("maxRequests", (Object)this._maxRequests), new TeaPair("maxRequestsPerHost", (Object)this._maxRequestsPerHost), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("retryable", (Object)runtime.autoretry), new TeaPair("maxAttempts", (Object)com.aliyun.teautil.Common.defaultNumber((Number)runtime.maxAttempts, (Number)3))})), new TeaPair("backoff", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("policy", (Object)com.aliyun.teautil.Common.defaultString((String)runtime.backoffPolicy, (String)"no")), new TeaPair("period", (Object)com.aliyun.teautil.Common.defaultNumber((Number)runtime.backoffPeriod, (Number)1))})), new TeaPair("ignoreSSL", (Object)runtime.ignoreSSL)});
        TeaRequest _lastRequest = null;
        Exception _lastException = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                request_.protocol = com.aliyun.teautil.Common.defaultString((String)this._protocol, (String)protocol);
                request_.method = method;
                request_.pathname = pathname;
                request_.query = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("method", (Object)action), new TeaPair("version", (Object)version), new TeaPair("sign_type", (Object)"HmacSHA1"), new TeaPair("req_time", (Object)AntchainUtils.getTimestamp()), new TeaPair("req_msg_id", (Object)AntchainUtils.getNonce()), new TeaPair("access_key", (Object)this._accessKeyId), new TeaPair("base_sdk_version", (Object)"TeaSDK-2.0"), new TeaPair("sdk_version", (Object)"1.0.6")});
                if (!com.aliyun.teautil.Common.empty((String)this._securityToken)) {
                    request_.query.put("security_token", this._securityToken);
                }
                request_.headers = TeaConverter.merge(String.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("host", (Object)com.aliyun.teautil.Common.defaultString((String)this._endpoint, (String)"openapi.antchain.antgroup.com")), new TeaPair("user-agent", (Object)com.aliyun.teautil.Common.getUserAgent((String)this._userAgent))}), headers});
                Map tmp = com.aliyun.teautil.Common.anyifyMapValue((Map)Common.query(request));
                request_.body = Tea.toReadable((String)com.aliyun.teautil.Common.toFormString((Map)tmp));
                request_.headers.put("content-type", "application/x-www-form-urlencoded");
                Map signedParam = TeaConverter.merge(String.class, (Map[])new Map[]{request_.query, Common.query(request)});
                request_.query.put("sign", AntchainUtils.getSignature((Map)signedParam, (String)this._accessKeySecret));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_);
                String raw = com.aliyun.teautil.Common.readAsString((InputStream)response_.body);
                Object obj = com.aliyun.teautil.Common.parseJSON((String)raw);
                Map res = com.aliyun.teautil.Common.assertAsMap((Object)obj);
                Map resp = com.aliyun.teautil.Common.assertAsMap(res.get("response"));
                if (AntchainUtils.hasError((String)raw, (String)this._accessKeySecret).booleanValue()) {
                    throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("message", resp.get("result_msg")), new TeaPair("data", (Object)resp), new TeaPair("code", resp.get("result_code"))}));
                }
                return resp;
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) {
                    _lastException = e;
                    continue;
                }
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest, _lastException);
    }

    public QueryGeneralResponse queryGeneral(QueryGeneralRequest request) throws Exception {
        RuntimeOptions runtime = new RuntimeOptions();
        HashMap<String, String> headers = new HashMap<String, String>();
        return this.queryGeneralEx(request, headers, runtime);
    }

    public QueryGeneralResponse queryGeneralEx(QueryGeneralRequest request, Map<String, String> headers, RuntimeOptions runtime) throws Exception {
        com.aliyun.teautil.Common.validateModel((TeaModel)request);
        return (QueryGeneralResponse)TeaModel.toModel(this.doRequest("1.0", "antsecuritytech.risknet.general.query", "HTTPS", "POST", "/gateway.do", TeaModel.buildMap((TeaModel)request), headers, runtime), (TeaModel)new QueryGeneralResponse());
    }
}

