/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ons.open.trace.core.dispatch.impl;

import com.alibaba.ons.open.trace.core.common.OnsTraceContext;
import com.alibaba.ons.open.trace.core.common.OnsTraceDispatcherType;
import com.alibaba.ons.open.trace.core.dispatch.AsyncDispatcher;
import com.alibaba.ons.open.trace.core.dispatch.NameServerAddressSetter;
import com.alibaba.ons.open.trace.core.dispatch.impl.InnerTraceProducer;
import com.aliyun.openservices.ons.api.impl.authority.SessionCredentialsProvider;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.RPCHook;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;

public class AsyncArrayDispatcher
implements AsyncDispatcher {
    private final boolean innerProducerSingleton;
    private final InnerTraceProducer traceProducer;
    private String dispatcherType;
    private DefaultMQProducerImpl hostProducer;
    private DefaultMQPushConsumerImpl hostConsumer;
    private String dispatcherId = UUID.randomUUID().toString();

    public AsyncArrayDispatcher(Properties properties, SessionCredentialsProvider provider, NameServerAddressSetter nameserverAddressSetter) throws MQClientException {
        this.dispatcherType = properties.getProperty("DispatcherType");
        this.innerProducerSingleton = Boolean.parseBoolean(properties.getProperty("TraceProducerSingleton", "true"));
        this.traceProducer = InnerTraceProducer.getTraceDispatcherProducer(properties, provider, nameserverAddressSetter);
    }

    public AsyncArrayDispatcher(Properties properties, NameServerAddressSetter nameserverAddressSetter, RPCHook rpcHook) throws MQClientException {
        this.dispatcherType = properties.getProperty("DispatcherType");
        this.innerProducerSingleton = Boolean.parseBoolean(properties.getProperty("TraceProducerSingleton", "true"));
        this.traceProducer = InnerTraceProducer.getTraceDispatcherProducer(properties, nameserverAddressSetter, rpcHook);
    }

    public DefaultMQProducerImpl getHostProducer() {
        return this.hostProducer;
    }

    public void setHostProducer(DefaultMQProducerImpl hostProducer) {
        this.hostProducer = hostProducer;
    }

    public DefaultMQPushConsumerImpl getHostConsumer() {
        return this.hostConsumer;
    }

    public void setHostConsumer(DefaultMQPushConsumerImpl hostConsumer) {
        this.hostConsumer = hostConsumer;
    }

    @Override
    public void start() throws MQClientException {
        InnerTraceProducer.registerTraceDispatcher(this.dispatcherId, this.traceProducer, this.innerProducerSingleton);
    }

    @Override
    public boolean append(OnsTraceContext ctx) {
        if (ctx.getTraceBeans().isEmpty()) {
            return true;
        }
        String topic = ctx.getTraceBeans().get(0).getTopic();
        Set<String> brokerSet = this.getBrokerSetByTopic(topic);
        ctx.setBrokerSet(brokerSet);
        return this.traceProducer.append(ctx);
    }

    @Override
    public void shutdown() {
        InnerTraceProducer.unregisterTraceDispatcher(this.dispatcherId, this.traceProducer, this.innerProducerSingleton);
    }

    private Set<String> getBrokerSetByTopic(String topic) {
        Set<String> brokerSet = new HashSet<String>();
        if (this.dispatcherType != null && this.dispatcherType.equals(OnsTraceDispatcherType.PRODUCER.name()) && this.hostProducer != null) {
            brokerSet = InnerTraceProducer.tryGetMessageQueueBrokerSet(this.hostProducer, topic);
        }
        if (this.dispatcherType != null && this.dispatcherType.equals(OnsTraceDispatcherType.CONSUMER.name()) && this.hostConsumer != null) {
            brokerSet = InnerTraceProducer.tryGetMessageQueueBrokerSet(this.hostConsumer, topic);
        }
        return brokerSet;
    }
}

