/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.annotation.JSONField;
import com.aliyun.openservices.log.common.JobScheduleType;
import com.aliyun.openservices.log.util.Args;
import com.aliyun.openservices.log.util.JsonUtils;
import java.io.Serializable;
import net.sf.json.JSONObject;

public class JobSchedule
implements Serializable {
    private static final long serialVersionUID = 8400426178465652937L;
    @JSONField
    private JobScheduleType type;
    @JSONField
    private String interval;
    @JSONField
    private String cronExpression;
    @JSONField
    private Integer delay;
    @JSONField
    private Integer dayOfWeek;
    @JSONField
    private Integer hour;

    public JobScheduleType getType() {
        return this.type;
    }

    public void setType(JobScheduleType type) {
        this.type = type;
    }

    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        Args.checkDuration(interval);
        this.interval = interval;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public Integer getDelay() {
        return this.delay;
    }

    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    public Integer getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(Integer dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public Integer getHour() {
        return this.hour;
    }

    public void setHour(Integer hour) {
        this.hour = hour;
    }

    public void deserialize(JSONObject value) {
        this.type = JobScheduleType.fromString(value.getString("type"));
        this.delay = JsonUtils.readOptionalInt(value, "delay");
        switch (this.type) {
            case CRON: {
                this.cronExpression = value.getString("cronExpression");
                break;
            }
            case FIXED_RATE: {
                this.interval = value.getString("interval");
                break;
            }
            case DAILY: {
                this.hour = value.getInt("hour");
                break;
            }
            case WEEKLY: {
                this.dayOfWeek = value.getInt("dayOfWeek");
                this.hour = value.getInt("hour");
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobSchedule schedule = (JobSchedule)o;
        if (this.getType() != schedule.getType()) {
            return false;
        }
        if (this.getInterval() != null ? !this.getInterval().equals(schedule.getInterval()) : schedule.getInterval() != null) {
            return false;
        }
        if (this.getCronExpression() != null ? !this.getCronExpression().equals(schedule.getCronExpression()) : schedule.getCronExpression() != null) {
            return false;
        }
        if (this.getDelay() != null ? !this.getDelay().equals(schedule.getDelay()) : schedule.getDelay() != null) {
            return false;
        }
        if (this.getDayOfWeek() != null ? !this.getDayOfWeek().equals(schedule.getDayOfWeek()) : schedule.getDayOfWeek() != null) {
            return false;
        }
        return this.getHour() != null ? this.getHour().equals(schedule.getHour()) : schedule.getHour() == null;
    }

    public int hashCode() {
        int result = this.getType() != null ? this.getType().hashCode() : 0;
        result = 31 * result + (this.getInterval() != null ? this.getInterval().hashCode() : 0);
        result = 31 * result + (this.getCronExpression() != null ? this.getCronExpression().hashCode() : 0);
        result = 31 * result + (this.getDelay() != null ? this.getDelay().hashCode() : 0);
        result = 31 * result + (this.getDayOfWeek() != null ? this.getDayOfWeek().hashCode() : 0);
        result = 31 * result + (this.getHour() != null ? this.getHour().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "JobSchedule{type=" + (Object)((Object)this.type) + ", interval='" + this.interval + '\'' + ", cronExpression='" + this.cronExpression + '\'' + ", delay=" + this.delay + ", dayOfWeek=" + this.dayOfWeek + ", hour=" + this.hour + '}';
    }
}

