/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.FastLogContent;
import com.aliyun.openservices.log.util.VarintUtil;
import java.util.ArrayList;
import java.util.List;

public class FastLog {
    private byte[] rawBytes;
    private int beginOffset;
    private int endOffset;
    private int time = -1;
    private int timeNsPart = 0;
    private final List<FastLogContent> contents;

    public FastLog(byte[] rawBytes, int offset, int length) {
        this.rawBytes = rawBytes;
        this.beginOffset = offset;
        this.endOffset = offset + length;
        this.contents = new ArrayList<FastLogContent>();
        if (!this.parse()) {
            this.contents.clear();
        }
    }

    private boolean parse() {
        int pos = this.beginOffset;
        boolean findTime = false;
        while (pos < this.endOffset) {
            int[] value = VarintUtil.DecodeVarInt32(this.rawBytes, pos, this.endOffset);
            if (value[0] == 0) {
                return false;
            }
            int mode = value[1] & 7;
            int index = value[1] >> 3;
            if (mode == 0) {
                pos = value[2];
                if ((value = VarintUtil.DecodeVarInt32(this.rawBytes, pos, this.endOffset))[0] == 0) {
                    return false;
                }
                pos = value[2];
                if (index != 1) continue;
                this.time = value[1];
                findTime = true;
                continue;
            }
            if (mode == 1) {
                pos = value[2] + 8;
                continue;
            }
            if (mode == 2) {
                pos = value[2];
                if ((value = VarintUtil.DecodeVarInt32(this.rawBytes, pos, this.endOffset))[0] == 0) {
                    return false;
                }
                pos = value[2] + value[1];
                if (index != 2) continue;
                this.contents.add(new FastLogContent(this.rawBytes, value[2], value[1]));
                continue;
            }
            if (mode == 5) {
                if (index == 4) {
                    this.timeNsPart = this.rawBytes[value[2]] & 0xFF | (this.rawBytes[value[2] + 1] & 0xFF) << 8 | (this.rawBytes[value[2] + 2] & 0xFF) << 16 | (this.rawBytes[value[2] + 3] & 0xFF) << 24;
                }
                pos = value[2] + 4;
                continue;
            }
            return false;
        }
        return findTime && pos == this.endOffset;
    }

    public int getTime() {
        return this.time;
    }

    public int getTimeNsPart() {
        return this.timeNsPart;
    }

    public int getContentsCount() {
        return this.contents.size();
    }

    public List<FastLogContent> getContents() {
        return this.contents;
    }

    public FastLogContent getContents(int i) {
        if (i < this.contents.size()) {
            return this.contents.get(i);
        }
        return null;
    }

    public int getByteSize() {
        return this.endOffset - this.beginOffset;
    }
}

