package com.aliyun.mns.model;

import com.google.gson.*;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

/**
 * please refer to https://help.aliyun.com/document_detail/48089.html
 */
public class PushAttributes implements BaseAttributes {
    private PushTarget target;
    private String targetValue;
    private PushDeviceType deviceType;
    private PushType pushType;
    private String title;
    private String body;

    private Map<String, String> params = new HashMap<String, String>();

    public String toJson(Gson gson) {
        return gson.toJson(this);
    }

    public enum PushTarget {
        DEVICE, ACCOUNT, ALIAS, TAG, ALL;
    }
    public enum PushDeviceType {
        iOS, ANDROID, ALL;
    }
    public enum PushType {
        MESSAGE, NOTICE;
    }

    @Override
    public AttributesValidationResult validate() {
        AttributesValidationResult result = new AttributesValidationResult();

        if (target == null) {
            result.setSuccess(false);
            result.setMessage("Invalid PushTarget");
            return result;
        }
        if (targetValue == null || (target == PushTarget.ALL && !targetValue.equals("ALL"))) {
            result.setSuccess(false);
            result.setMessage("Invalid TargetValue");
            return result;
        }
        if (deviceType == null) {
            result.setSuccess(false);
            result.setMessage("Invalid DeviceType");
            return result;
        }
        if (body == null) {
            result.setSuccess(false);
            result.setMessage("Invalid Body");
            return result;
        }
        if (title == null) {
            result.setSuccess(false);
            result.setMessage("Invalid Title");
            return result;
        }

        if (pushType == null) {
            pushType = PushType.MESSAGE; // use default value
        }
        result.setSuccess(true);
        return result;
    }

    public static class PushAttributesSerializer implements JsonSerializer<PushAttributes> {
        @Override
        public JsonElement serialize(PushAttributes pushAttributes, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("Target", pushAttributes.target.name());
            jsonObject.addProperty("TargetValue", pushAttributes.targetValue);
            jsonObject.addProperty("DeviceType", pushAttributes.deviceType.name());
            jsonObject.addProperty("PushType", pushAttributes.pushType.name());
            jsonObject.addProperty("Title", pushAttributes.title);
            jsonObject.addProperty("Body", pushAttributes.body);

            for (String key : pushAttributes.params.keySet()) {
                jsonObject.addProperty(key, pushAttributes.params.get(key));
            }
            return jsonObject;
        }
    }

    public void setParam(String key, String value) {
        if (value != null && !value.isEmpty()) {
            params.put(key, value);
        }
    }

    public PushTarget getTarget() {
        return target;
    }

    public void setTarget(PushTarget target) {
        this.target = target;
    }

    public String getTargetValue() {
        return targetValue;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = targetValue;
    }

    public PushDeviceType getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(PushDeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public PushType getPushType() {
        return pushType;
    }

    public void setPushType(PushType pushType) {
        this.pushType = pushType;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }
}
