/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.kms;

import com.aliyun.dkms.gcs.openapi.models.Config;
import com.aliyun.dkms.gcs.openapi.util.models.RuntimeOptions;
import com.aliyun.dkms.gcs.sdk.Client;
import com.aliyun.kms.handlers.AsymmetricDecryptTransferHandler;
import com.aliyun.kms.handlers.AsymmetricEncryptTransferHandler;
import com.aliyun.kms.handlers.AsymmetricSignTransferHandler;
import com.aliyun.kms.handlers.AsymmetricVerifyTransferHandler;
import com.aliyun.kms.handlers.DecryptTransferHandler;
import com.aliyun.kms.handlers.EncryptTransferHandler;
import com.aliyun.kms.handlers.GenerateDataKeyTransferHandler;
import com.aliyun.kms.handlers.GenerateDataKeyWithoutPlaintextTransferHandler;
import com.aliyun.kms.handlers.GetPublicKeyTransferHandler;
import com.aliyun.kms.handlers.GetSecretValueTransferHandler;
import com.aliyun.kms.handlers.KmsTransferHandler;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.Credential;
import com.aliyuncs.auth.Signer;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.profile.IClientProfile;
import java.util.HashMap;
import java.util.Map;

public class KmsTransferAcsClient
extends DefaultAcsClient {
    private boolean ignoreSSLCerts = false;
    private Client client;
    private final Map<String, KmsTransferHandler> handlers = new HashMap<String, KmsTransferHandler>();
    private boolean isUseKmsShareGateway;

    public KmsTransferAcsClient(Config config) throws ClientException {
        try {
            this.setUserAgent(config);
            this.client = new Client(config);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        this.initKmsTransferHandlers();
    }

    public KmsTransferAcsClient(String regionId, Config config) throws ClientException {
        super(regionId);
        try {
            this.setUserAgent(config);
            this.client = new Client(config);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        this.initKmsTransferHandlers();
    }

    public KmsTransferAcsClient(String regionId) throws ClientException {
        super(regionId);
        this.isUseKmsShareGateway = true;
    }

    public KmsTransferAcsClient(IClientProfile profile, Config config) {
        super(profile);
        this.ignoreSSLCerts = profile.getHttpClientConfig() == null ? false : profile.getHttpClientConfig().isIgnoreSSLCerts();
        try {
            this.setUserAgent(config);
            this.client = new Client(config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.initKmsTransferHandlers();
    }

    public KmsTransferAcsClient(IClientProfile profile) {
        super(profile);
        this.isUseKmsShareGateway = true;
    }

    public KmsTransferAcsClient(IClientProfile profile, AlibabaCloudCredentials credentials, Config config) {
        super(profile, credentials);
        this.ignoreSSLCerts = profile.getHttpClientConfig() == null ? false : profile.getHttpClientConfig().isIgnoreSSLCerts();
        try {
            this.setUserAgent(config);
            this.client = new Client(config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.initKmsTransferHandlers();
    }

    public KmsTransferAcsClient(IClientProfile profile, AlibabaCloudCredentials credentials) {
        super(profile, credentials);
        this.isUseKmsShareGateway = true;
    }

    public KmsTransferAcsClient(IClientProfile profile, AlibabaCloudCredentialsProvider credentialsProvider, Config config) {
        super(profile, credentialsProvider);
        this.ignoreSSLCerts = profile.getHttpClientConfig() == null ? false : profile.getHttpClientConfig().isIgnoreSSLCerts();
        try {
            this.setUserAgent(config);
            this.client = new Client(config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.initKmsTransferHandlers();
    }

    public KmsTransferAcsClient(IClientProfile profile, AlibabaCloudCredentialsProvider credentialsProvider) {
        super(profile, credentialsProvider);
        this.isUseKmsShareGateway = true;
    }

    private void initKmsTransferHandlers() {
        this.handlers.put("Encrypt", new EncryptTransferHandler(this.client, "Encrypt"));
        this.handlers.put("Decrypt", new DecryptTransferHandler(this.client, "Decrypt"));
        this.handlers.put("AsymmetricEncrypt", new AsymmetricEncryptTransferHandler(this.client, "AsymmetricEncrypt"));
        this.handlers.put("AsymmetricDecrypt", new AsymmetricDecryptTransferHandler(this.client, "AsymmetricDecrypt"));
        this.handlers.put("AsymmetricSign", new AsymmetricSignTransferHandler(this.client, "AsymmetricSign"));
        this.handlers.put("AsymmetricVerify", new AsymmetricVerifyTransferHandler(this.client, "AsymmetricVerify"));
        this.handlers.put("GenerateDataKey", new GenerateDataKeyTransferHandler(this.client, "GenerateDataKey"));
        this.handlers.put("GenerateDataKeyWithoutPlaintext", new GenerateDataKeyWithoutPlaintextTransferHandler(this.client, "GenerateDataKeyWithoutPlaintext"));
        this.handlers.put("GetPublicKey", new GetPublicKeyTransferHandler(this.client, "GetPublicKey"));
        this.handlers.put("GetSecretValue", new GetSecretValueTransferHandler(this.client, "GetSecretValue"));
    }

    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, String regionId, Credential credential) throws ClientException, ServerException {
        if (!this.isUseKmsShareGateway && this.handlers.containsKey(request.getSysActionName())) {
            return this.dispatchDKmsAction(this.handlers.get(request.getSysActionName()), request);
        }
        return super.doAction(request, regionId, credential);
    }

    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, boolean autoRetry, int maxRetryCounts, IClientProfile profile) throws ClientException, ServerException {
        if (this.handlers.containsKey(request.getSysActionName()) && !this.isUseKmsShareGateway) {
            return this.dispatchDKmsAction(this.handlers.get(request.getSysActionName()), request);
        }
        return super.doAction(request, autoRetry, maxRetryCounts, profile);
    }

    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, boolean autoRetry, int maxRetryNumber, String regionId, Credential credential, Signer signer, FormatType format) throws ClientException, ServerException {
        if (this.handlers.containsKey(request.getSysActionName()) && !this.isUseKmsShareGateway) {
            return this.dispatchDKmsAction(this.handlers.get(request.getSysActionName()), request);
        }
        return super.doAction(request, autoRetry, maxRetryNumber, regionId, credential, signer, format);
    }

    private <T extends AcsResponse> HttpResponse dispatchDKmsAction(KmsTransferHandler handler, AcsRequest<T> request) throws ClientException, ServerException {
        RuntimeOptions runtimeOptions = new RuntimeOptions();
        runtimeOptions.setIgnoreSSL(Boolean.valueOf(this.ignoreSSLCerts));
        return handler.handlerDKmsRequestWithOptions(request, runtimeOptions);
    }

    private void setUserAgent(Config config) {
        if (config.getUserAgent() != null) {
            config.setUserAgent(config.getUserAgent() + " " + "alibabacloud-dkms-transfer-java-sdk/0.2.2");
        } else {
            config.setUserAgent("alibabacloud-dkms-transfer-java-sdk/0.2.2");
        }
    }
}

