/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.drc.client.message.DataMessage;
import org.apache.commons.lang3.StringUtils;

public class MetaMappingUtils {
    private JSONObject metaMappingJSON = null;

    public void init(String mappingJSONStr) {
        try {
            if (this.metaMappingJSON == null && StringUtils.isNotBlank((CharSequence)mappingJSONStr)) {
                this.metaMappingJSON = JSON.parseObject((String)mappingJSONStr);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("init metaMappingJSON exception", e);
        }
    }

    public String getLogicalDbname(DataMessage.Record record) {
        if (this.metaMappingJSON == null) {
            throw new RuntimeException("metaMappingJSON should not be null");
        }
        String dbname = record.getDbname();
        if (StringUtils.isBlank((CharSequence)dbname)) {
            return null;
        }
        String logicalDbname = null;
        JSONObject json = this.metaMappingJSON.getJSONObject(dbname);
        if (json != null) {
            logicalDbname = json.getString("name");
        }
        return logicalDbname == null ? dbname : logicalDbname;
    }

    public String getLogicalTablename(DataMessage.Record record) {
        JSONObject tbJSON;
        if (this.metaMappingJSON == null) {
            throw new RuntimeException("metaMappingJSON should not be null");
        }
        String dbname = record.getDbname();
        String tablename = record.getTablename();
        if (StringUtils.isBlank((CharSequence)dbname) || StringUtils.isBlank((CharSequence)tablename)) {
            return null;
        }
        String logicalTablename = null;
        JSONObject dbJSON = this.metaMappingJSON.getJSONObject(dbname);
        if (dbJSON != null && (tbJSON = dbJSON.getJSONObject("tables")) != null) {
            logicalTablename = tbJSON.getString(tablename);
        }
        return logicalTablename == null ? tablename : logicalTablename;
    }
}

