/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.message;

import java.io.UnsupportedEncodingException;

public class ByteString {
    private int len;
    private int offset;
    private byte[] bytes;

    public ByteString(byte[] bytes, int len) {
        this.bytes = bytes;
        this.len = len;
    }

    public ByteString(byte[] bytes, int offset, int len) {
        this.bytes = bytes;
        this.len = len;
        this.offset = offset;
    }

    public String toString(String encoding) throws UnsupportedEncodingException {
        if (this.len == 0) {
            return new String("");
        }
        if (encoding.equalsIgnoreCase("binary")) {
            throw new UnsupportedEncodingException("field encoding: binary, use getBytes() instead of toString()");
        }
        String realEncoding = encoding;
        if (encoding.isEmpty() || encoding.equalsIgnoreCase("null")) {
            realEncoding = "ASCII";
        } else if (encoding.equalsIgnoreCase("utf8mb4")) {
            realEncoding = "utf8";
        } else if (encoding.equalsIgnoreCase("latin1")) {
            realEncoding = "cp1252";
        } else if (encoding.equalsIgnoreCase("latin2")) {
            realEncoding = "iso-8859-2";
        }
        return new String(this.bytes, this.offset, this.len, realEncoding);
    }

    public String toString() {
        if (this.len == 0) {
            return "";
        }
        byte[] byteArray = this.bytes;
        char[] charArray = new char[this.len];
        for (int i = 0; i < this.len; ++i) {
            charArray[i] = (char)byteArray[i + this.offset];
        }
        return String.valueOf(charArray);
    }

    public byte[] getBytes() {
        byte[] t = new byte[this.len];
        System.arraycopy(this.bytes, this.offset, t, 0, this.len);
        return t;
    }

    public int getLen() {
        return this.len;
    }

    public int getOffset() {
        return this.offset;
    }
}

