/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.client.impl;

import com.aliyun.drc.client.DRCClientException;
import com.aliyun.drc.client.HttpBadResponseException;
import com.aliyun.drc.client.impl.DRCConfig;
import com.aliyun.drc.client.message.Builder;
import com.aliyun.drc.client.message.Message;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;

public class HttpHandler {
    private final String url;
    private String urlEncoding = "UTF-8";
    private final List<NameValuePair> formParams;
    private HttpClient httpClient;
    private HttpResponse httpResponse;
    private DataInputStream inStream;
    private Message message;
    private Builder builder;
    private String protocolVersion;
    private int socketTimeout = 120;
    private int connectionTimeout = 120;
    private static final int BUFFSIZE = 131072;
    private final byte[] buffer = new byte[131072];
    private static final int CONNECTION_TIMEOUT = 120;

    HttpHandler(String urlString, boolean useHTTPS) {
        this.url = urlString;
        this.formParams = new ArrayList<NameValuePair>();
        this.builder = new Builder();
        this.protocolVersion = "2.0";
        if (useHTTPS) {
            this.initHTTPSClient();
        } else {
            this.httpClient = new DefaultHttpClient();
        }
    }

    private void initHTTPSClient() {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        PlainConnectionSocketFactory plainSF = new PlainConnectionSocketFactory();
        registryBuilder.register("http", (Object)plainSF);
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            TrustStrategy anyTrustStrategy = new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    return true;
                }
            };
            SSLContext sslContext = SSLContexts.custom().useTLS().loadTrustMaterial(trustStore, anyTrustStrategy).build();
            SSLConnectionSocketFactory sslSF = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            registryBuilder.register("https", (Object)sslSF);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Registry registry = registryBuilder.build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(registry);
        this.httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connManager).build();
    }

    final String getProtocolVersion() {
        return this.protocolVersion;
    }

    final String getUrl() {
        return this.url;
    }

    final void addFormParam(String param, String value) {
        this.formParams.add((NameValuePair)new BasicNameValuePair(param, value));
    }

    final List<NameValuePair> getFormParams() {
        return this.formParams;
    }

    final void setUrlEncoding(String encoding) {
        this.urlEncoding = encoding;
    }

    final String getUrlEncoding() {
        return this.urlEncoding;
    }

    void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    private void sendRequest(StringEntity entity) throws ClientProtocolException, IOException, HttpBadResponseException {
        HttpPost method = new HttpPost(this.url);
        method.getParams().setParameter("http.socket.timeout", (Object)(this.socketTimeout * 1000));
        method.getParams().setParameter("http.connection.timeout", (Object)(this.connectionTimeout * 1000));
        method.setEntity((HttpEntity)entity);
        this.httpResponse = this.httpClient.execute((HttpUriRequest)method);
        this.checkResponse(this.httpResponse);
    }

    void sendEncodedRequest() throws IOException, HttpBadResponseException {
        this.sendRequest((StringEntity)new UrlEncodedFormEntity(this.formParams, this.urlEncoding));
    }

    void sendPlainRequest() throws IOException, HttpBadResponseException {
        StringBuilder builder = new StringBuilder();
        for (NameValuePair pair : this.formParams) {
            builder.append(pair.getName() + "=" + pair.getValue());
            builder.append("&");
        }
        if (builder.length() != 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        this.sendRequest(new StringEntity(builder.toString()));
    }

    HttpResponse recvResponse() {
        return this.httpResponse;
    }

    InputStream recvInputStream() throws IOException, DRCClientException {
        if (this.inStream == null) {
            if (this.httpResponse == null) {
                throw new DRCClientException("HttpHanlder can not find http response and inputStream.");
            }
            HttpEntity responsedEntity = this.httpResponse.getEntity();
            if (responsedEntity != null) {
                this.inStream = new DataInputStream(responsedEntity.getContent());
            }
        }
        return this.inStream;
    }

    Message recvDRCPResponse(DRCConfig drcConfig) throws IOException, DRCClientException {
        if (this.inStream == null) {
            if (this.httpResponse == null) {
                throw new DRCClientException("HttpHanlder can not find http response and inputStream.");
            }
            HttpEntity responsedEntity = this.httpResponse.getEntity();
            if (responsedEntity != null) {
                this.inStream = new DataInputStream(responsedEntity.getContent());
                this.protocolVersion = this.inStream.readLine();
            }
        }
        this.message = this.builder.build(this.inStream, drcConfig);
        return this.message;
    }

    Message recvDRCPBinaryResponse(DRCConfig drcConfig) throws Exception, DRCClientException {
        if (this.inStream == null) {
            if (this.httpResponse == null) {
                throw new DRCClientException("HttpHanlder can not find http response and inputStream.");
            }
            HttpEntity responsedEntity = this.httpResponse.getEntity();
            if (responsedEntity != null) {
                this.inStream = new DataInputStream(responsedEntity.getContent());
            }
        }
        try {
            this.message = this.builder.buildBinaryBinlog(this.inStream, drcConfig);
        }
        catch (Exception e) {
            byte[] buff = new byte[1024];
            int read_effective_count = this.inStream.read(buff, 0, 1024);
            Exception toThrow = new Exception("raw buf:" + new String(buff, 0, read_effective_count), e.getCause());
            toThrow.setStackTrace(e.getStackTrace());
            throw toThrow;
        }
        return this.message;
    }

    Message recvDRCNetBinaryResponse(byte[] buff, DRCConfig drcConfig) throws Exception {
        this.message = this.builder.buildDRCNetBinaryBinlog(buff, drcConfig);
        return this.message;
    }

    Message recvDRCNetTextResponse(byte[] buff, DRCConfig drcConfig) throws Exception {
        this.message = this.builder.buildDRCNetTextBinlog(buff, drcConfig);
        return this.message;
    }

    byte[] recv() throws IOException, DRCClientException {
        int readBytes;
        if (this.inStream == null) {
            if (this.httpResponse == null) {
                throw new DRCClientException("HttpHanlder can not find http response and inputStream.");
            }
            HttpEntity responsedEntity = this.httpResponse.getEntity();
            if (responsedEntity != null) {
                this.inStream = new DataInputStream(responsedEntity.getContent());
            }
        }
        if ((readBytes = this.inStream.read(this.buffer, 0, 131072)) != -1) {
            byte[] data = new byte[readBytes];
            System.arraycopy(this.buffer, 0, data, 0, readBytes);
            return data;
        }
        return null;
    }

    final void close() {
        if (this.inStream != null && this.httpClient != null) {
            this.httpClient.getConnectionManager().shutdown();
        }
    }

    void checkResponse(HttpResponse response) throws HttpBadResponseException, IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            switch (statusCode) {
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 400: {
                    InputStream in = response.getEntity().getContent();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    String line = null;
                    StringBuilder builder = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        builder.append(line);
                    }
                    throw new HttpBadResponseException(statusCode, "HTTP response code: " + statusCode + " " + builder.toString());
                }
                case 403: {
                    throw new HttpBadResponseException(statusCode, "HTTP response code: " + statusCode + " Forbidden.");
                }
                case 404: {
                    throw new HttpBadResponseException(statusCode, "HTTP response code: " + statusCode + " Not Found.");
                }
                case 500: {
                    throw new HttpBadResponseException(statusCode, "HTTP response code: " + statusCode + " Internal Error.");
                }
            }
            throw new HttpBadResponseException(statusCode, "HTTP response code: " + statusCode + " Unexpected code.");
        }
    }
}

