/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.aliyun.datahub;

import com.aliyun.datahub.DatahubClient;
import com.aliyun.datahub.DatahubConfiguration;
import com.aliyun.datahub.auth.Account;
import com.aliyun.datahub.auth.AliyunAccount;
import com.aliyun.datahub.model.RecordEntry;
import com.aliyun.datahub.model.ShardEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.aliyun.datahub.DatahubInputDStream;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class DatahubUtils$
implements Logging {
    public static final DatahubUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DatahubUtils$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public <T> DStream<T> createStream(StreamingContext ssc, String projectName, String topicName, String subId, String accessKeyId, String accessKeySecret, String endpoint, String shardId, Function1<RecordEntry, T> func, StorageLevel storageLevel, ClassTag<T> evidence$1) {
        boolean walEnabled = WriteAheadLogUtils$.MODULE$.enableReceiverLog(ssc.conf());
        this.logInfo((Function0<String>)new Serializable(walEnabled){
            public static final long serialVersionUID = 0L;
            private final boolean walEnabled$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"createStream walEnabled: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)this.walEnabled$1)}));
            }
            {
                this.walEnabled$1 = walEnabled$1;
            }
        });
        return this.createStream(ssc, projectName, topicName, subId, accessKeyId, accessKeySecret, endpoint, shardId, func, walEnabled, storageLevel, evidence$1);
    }

    private <T> DStream<T> createStream(StreamingContext ssc, String projectName, String topicName, String subId, String accessKeyId, String accessKeySecret, String endpoint, String shardId, Function1<RecordEntry, T> func, boolean walEnabled, StorageLevel storageLevel, ClassTag<T> evidence$2) {
        return (DStream)ssc.withNamedScope("datahub sparkstreaming", (Function0)new Serializable(ssc, projectName, topicName, subId, accessKeyId, accessKeySecret, endpoint, shardId, func, walEnabled, storageLevel, evidence$2){
            public static final long serialVersionUID = 0L;
            private final StreamingContext ssc$2;
            private final String projectName$2;
            private final String topicName$2;
            private final String subId$2;
            private final String accessKeyId$2;
            private final String accessKeySecret$2;
            private final String endpoint$2;
            private final String shardId$1;
            private final Function1 func$2;
            private final boolean walEnabled$2;
            private final StorageLevel storageLevel$2;
            private final ClassTag evidence$2$1;

            public final DatahubInputDStream<T> apply() {
                return new DatahubInputDStream<T>(this.ssc$2, this.projectName$2, this.topicName$2, this.subId$2, this.accessKeyId$2, this.accessKeySecret$2, this.endpoint$2, this.shardId$1, this.func$2, this.storageLevel$2, this.walEnabled$2, this.evidence$2$1);
            }
            {
                this.ssc$2 = ssc$2;
                this.projectName$2 = projectName$2;
                this.topicName$2 = topicName$2;
                this.subId$2 = subId$2;
                this.accessKeyId$2 = accessKeyId$2;
                this.accessKeySecret$2 = accessKeySecret$2;
                this.endpoint$2 = endpoint$2;
                this.shardId$1 = shardId$1;
                this.func$2 = func$2;
                this.walEnabled$2 = walEnabled$2;
                this.storageLevel$2 = storageLevel$2;
                this.evidence$2$1 = evidence$2$1;
            }
        });
    }

    public <T> DStream<T> createStream(StreamingContext ssc, String projectName, String topicName, String subId, String accessKeyId, String accessKeySecret, String endpoint, Function1<RecordEntry, T> func, StorageLevel storageLevel, ClassTag<T> evidence$3) {
        AliyunAccount account = new AliyunAccount(accessKeyId, accessKeySecret);
        DatahubConfiguration conf = new DatahubConfiguration((Account)account, endpoint);
        DatahubClient loghubClient = new DatahubClient(conf);
        Buffer shardEntries = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(loghubClient.listShard(projectName, topicName).getShards()).asScala();
        ObjectRef dStream = ObjectRef.create(null);
        shardEntries.foreach((Function1)new Serializable(ssc, projectName, topicName, subId, accessKeyId, accessKeySecret, endpoint, func, storageLevel, evidence$3, dStream){
            public static final long serialVersionUID = 0L;
            private final StreamingContext ssc$1;
            private final String projectName$1;
            private final String topicName$1;
            private final String subId$1;
            private final String accessKeyId$1;
            private final String accessKeySecret$1;
            private final String endpoint$1;
            private final Function1 func$1;
            private final StorageLevel storageLevel$1;
            private final ClassTag evidence$3$1;
            private final ObjectRef dStream$1;

            public final void apply(ShardEntry shardEntry) {
                this.dStream$1.elem = (DStream)this.dStream$1.elem == null ? DatahubUtils$.MODULE$.createStream(this.ssc$1, this.projectName$1, this.topicName$1, this.subId$1, this.accessKeyId$1, this.accessKeySecret$1, this.endpoint$1, shardEntry.getShardId(), this.func$1, this.storageLevel$1, this.evidence$3$1) : ((DStream)this.dStream$1.elem).union(DatahubUtils$.MODULE$.createStream(this.ssc$1, this.projectName$1, this.topicName$1, this.subId$1, this.accessKeyId$1, this.accessKeySecret$1, this.endpoint$1, shardEntry.getShardId(), this.func$1, this.storageLevel$1, this.evidence$3$1));
            }
            {
                this.ssc$1 = ssc$1;
                this.projectName$1 = projectName$1;
                this.topicName$1 = topicName$1;
                this.subId$1 = subId$1;
                this.accessKeyId$1 = accessKeyId$1;
                this.accessKeySecret$1 = accessKeySecret$1;
                this.endpoint$1 = endpoint$1;
                this.func$1 = func$1;
                this.storageLevel$1 = storageLevel$1;
                this.evidence$3$1 = evidence$3$1;
                this.dStream$1 = dStream$1;
            }
        });
        return (DStream)dStream.elem;
    }

    private <T> StorageLevel createStream$default$11() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK_SER_2();
    }

    private DatahubUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

