/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class UpdateSecretVersionStageRequest
extends Request {
    @Query
    @NameInMap(value="MoveToVersion")
    private String moveToVersion;
    @Query
    @NameInMap(value="RemoveFromVersion")
    private String removeFromVersion;
    @Query
    @NameInMap(value="SecretName")
    @Validation(required=true)
    private String secretName;
    @Query
    @NameInMap(value="VersionStage")
    @Validation(required=true)
    private String versionStage;

    private UpdateSecretVersionStageRequest(Builder builder) {
        super((Request.Builder)builder);
        this.moveToVersion = builder.moveToVersion;
        this.removeFromVersion = builder.removeFromVersion;
        this.secretName = builder.secretName;
        this.versionStage = builder.versionStage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateSecretVersionStageRequest create() {
        return UpdateSecretVersionStageRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getMoveToVersion() {
        return this.moveToVersion;
    }

    public String getRemoveFromVersion() {
        return this.removeFromVersion;
    }

    public String getSecretName() {
        return this.secretName;
    }

    public String getVersionStage() {
        return this.versionStage;
    }

    public static final class Builder
    extends Request.Builder<UpdateSecretVersionStageRequest, Builder> {
        private String moveToVersion;
        private String removeFromVersion;
        private String secretName;
        private String versionStage;

        private Builder() {
        }

        private Builder(UpdateSecretVersionStageRequest request) {
            super((Request)request);
            this.moveToVersion = request.moveToVersion;
            this.removeFromVersion = request.removeFromVersion;
            this.secretName = request.secretName;
            this.versionStage = request.versionStage;
        }

        public Builder moveToVersion(String moveToVersion) {
            this.putQueryParameter("MoveToVersion", moveToVersion);
            this.moveToVersion = moveToVersion;
            return this;
        }

        public Builder removeFromVersion(String removeFromVersion) {
            this.putQueryParameter("RemoveFromVersion", removeFromVersion);
            this.removeFromVersion = removeFromVersion;
            return this;
        }

        public Builder secretName(String secretName) {
            this.putQueryParameter("SecretName", secretName);
            this.secretName = secretName;
            return this;
        }

        public Builder versionStage(String versionStage) {
            this.putQueryParameter("VersionStage", versionStage);
            this.versionStage = versionStage;
            return this;
        }

        public UpdateSecretVersionStageRequest build() {
            return new UpdateSecretVersionStageRequest(this);
        }
    }
}

