/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class PutSecretValueRequest
extends Request {
    @Query
    @NameInMap(value="SecretData")
    @Validation(required=true)
    private String secretData;
    @Query
    @NameInMap(value="SecretDataType")
    private String secretDataType;
    @Query
    @NameInMap(value="SecretName")
    @Validation(required=true)
    private String secretName;
    @Query
    @NameInMap(value="VersionId")
    @Validation(required=true)
    private String versionId;
    @Query
    @NameInMap(value="VersionStages")
    private String versionStages;

    private PutSecretValueRequest(Builder builder) {
        super((Request.Builder)builder);
        this.secretData = builder.secretData;
        this.secretDataType = builder.secretDataType;
        this.secretName = builder.secretName;
        this.versionId = builder.versionId;
        this.versionStages = builder.versionStages;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PutSecretValueRequest create() {
        return PutSecretValueRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getSecretData() {
        return this.secretData;
    }

    public String getSecretDataType() {
        return this.secretDataType;
    }

    public String getSecretName() {
        return this.secretName;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getVersionStages() {
        return this.versionStages;
    }

    public static final class Builder
    extends Request.Builder<PutSecretValueRequest, Builder> {
        private String secretData;
        private String secretDataType;
        private String secretName;
        private String versionId;
        private String versionStages;

        private Builder() {
        }

        private Builder(PutSecretValueRequest request) {
            super((Request)request);
            this.secretData = request.secretData;
            this.secretDataType = request.secretDataType;
            this.secretName = request.secretName;
            this.versionId = request.versionId;
            this.versionStages = request.versionStages;
        }

        public Builder secretData(String secretData) {
            this.putQueryParameter("SecretData", secretData);
            this.secretData = secretData;
            return this;
        }

        public Builder secretDataType(String secretDataType) {
            this.putQueryParameter("SecretDataType", secretDataType);
            this.secretDataType = secretDataType;
            return this;
        }

        public Builder secretName(String secretName) {
            this.putQueryParameter("SecretName", secretName);
            this.secretName = secretName;
            return this;
        }

        public Builder versionId(String versionId) {
            this.putQueryParameter("VersionId", versionId);
            this.versionId = versionId;
            return this;
        }

        public Builder versionStages(String versionStages) {
            this.putQueryParameter("VersionStages", versionStages);
            this.versionStages = versionStages;
            return this;
        }

        public PutSecretValueRequest build() {
            return new PutSecretValueRequest(this);
        }
    }
}

