/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ImportKeyMaterialRequest
extends Request {
    @Query
    @NameInMap(value="EncryptedKeyMaterial")
    @Validation(required=true)
    private String encryptedKeyMaterial;
    @Query
    @NameInMap(value="ImportToken")
    @Validation(required=true)
    private String importToken;
    @Query
    @NameInMap(value="KeyId")
    @Validation(required=true)
    private String keyId;
    @Query
    @NameInMap(value="KeyMaterialExpireUnix")
    @Validation(required=true)
    private Long keyMaterialExpireUnix;

    private ImportKeyMaterialRequest(Builder builder) {
        super((Request.Builder)builder);
        this.encryptedKeyMaterial = builder.encryptedKeyMaterial;
        this.importToken = builder.importToken;
        this.keyId = builder.keyId;
        this.keyMaterialExpireUnix = builder.keyMaterialExpireUnix;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ImportKeyMaterialRequest create() {
        return ImportKeyMaterialRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getEncryptedKeyMaterial() {
        return this.encryptedKeyMaterial;
    }

    public String getImportToken() {
        return this.importToken;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public Long getKeyMaterialExpireUnix() {
        return this.keyMaterialExpireUnix;
    }

    public static final class Builder
    extends Request.Builder<ImportKeyMaterialRequest, Builder> {
        private String encryptedKeyMaterial;
        private String importToken;
        private String keyId;
        private Long keyMaterialExpireUnix;

        private Builder() {
        }

        private Builder(ImportKeyMaterialRequest request) {
            super((Request)request);
            this.encryptedKeyMaterial = request.encryptedKeyMaterial;
            this.importToken = request.importToken;
            this.keyId = request.keyId;
            this.keyMaterialExpireUnix = request.keyMaterialExpireUnix;
        }

        public Builder encryptedKeyMaterial(String encryptedKeyMaterial) {
            this.putQueryParameter("EncryptedKeyMaterial", encryptedKeyMaterial);
            this.encryptedKeyMaterial = encryptedKeyMaterial;
            return this;
        }

        public Builder importToken(String importToken) {
            this.putQueryParameter("ImportToken", importToken);
            this.importToken = importToken;
            return this;
        }

        public Builder keyId(String keyId) {
            this.putQueryParameter("KeyId", keyId);
            this.keyId = keyId;
            return this;
        }

        public Builder keyMaterialExpireUnix(Long keyMaterialExpireUnix) {
            this.putQueryParameter("KeyMaterialExpireUnix", keyMaterialExpireUnix);
            this.keyMaterialExpireUnix = keyMaterialExpireUnix;
            return this;
        }

        public ImportKeyMaterialRequest build() {
            return new ImportKeyMaterialRequest(this);
        }
    }
}

