/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.Map;

public class DecryptRequest
extends Request {
    @Query
    @NameInMap(value="CiphertextBlob")
    @Validation(required=true)
    private String ciphertextBlob;
    @Query
    @NameInMap(value="EncryptionContext")
    private Map<String, ?> encryptionContext;

    private DecryptRequest(Builder builder) {
        super((Request.Builder)builder);
        this.ciphertextBlob = builder.ciphertextBlob;
        this.encryptionContext = builder.encryptionContext;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DecryptRequest create() {
        return DecryptRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCiphertextBlob() {
        return this.ciphertextBlob;
    }

    public Map<String, ?> getEncryptionContext() {
        return this.encryptionContext;
    }

    public static final class Builder
    extends Request.Builder<DecryptRequest, Builder> {
        private String ciphertextBlob;
        private Map<String, ?> encryptionContext;

        private Builder() {
        }

        private Builder(DecryptRequest request) {
            super((Request)request);
            this.ciphertextBlob = request.ciphertextBlob;
            this.encryptionContext = request.encryptionContext;
        }

        public Builder ciphertextBlob(String ciphertextBlob) {
            this.putQueryParameter("CiphertextBlob", ciphertextBlob);
            this.ciphertextBlob = ciphertextBlob;
            return this;
        }

        public Builder encryptionContext(Map<String, ?> encryptionContext) {
            String encryptionContextShrink = this.shrink(encryptionContext, "EncryptionContext", "json");
            this.putQueryParameter("EncryptionContext", encryptionContextShrink);
            this.encryptionContext = encryptionContext;
            return this;
        }

        public DecryptRequest build() {
            return new DecryptRequest(this);
        }
    }
}

