/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateApplicationAccessPointRequest
extends Request {
    @Query
    @NameInMap(value="AuthenticationMethod")
    private String authenticationMethod;
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="Name")
    @Validation(required=true)
    private String name;
    @Query
    @NameInMap(value="Policies")
    @Validation(required=true)
    private String policies;

    private CreateApplicationAccessPointRequest(Builder builder) {
        super((Request.Builder)builder);
        this.authenticationMethod = builder.authenticationMethod;
        this.description = builder.description;
        this.name = builder.name;
        this.policies = builder.policies;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateApplicationAccessPointRequest create() {
        return CreateApplicationAccessPointRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getPolicies() {
        return this.policies;
    }

    public static final class Builder
    extends Request.Builder<CreateApplicationAccessPointRequest, Builder> {
        private String authenticationMethod;
        private String description;
        private String name;
        private String policies;

        private Builder() {
        }

        private Builder(CreateApplicationAccessPointRequest request) {
            super((Request)request);
            this.authenticationMethod = request.authenticationMethod;
            this.description = request.description;
            this.name = request.name;
            this.policies = request.policies;
        }

        public Builder authenticationMethod(String authenticationMethod) {
            this.putQueryParameter("AuthenticationMethod", authenticationMethod);
            this.authenticationMethod = authenticationMethod;
            return this;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder name(String name) {
            this.putQueryParameter("Name", name);
            this.name = name;
            return this;
        }

        public Builder policies(String policies) {
            this.putQueryParameter("Policies", policies);
            this.policies = policies;
            return this;
        }

        public CreateApplicationAccessPointRequest build() {
            return new CreateApplicationAccessPointRequest(this);
        }
    }
}

