/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CertificatePrivateKeySignRequest
extends Request {
    @Query
    @NameInMap(value="Algorithm")
    @Validation(required=true)
    private String algorithm;
    @Query
    @NameInMap(value="CertificateId")
    @Validation(required=true)
    private String certificateId;
    @Query
    @NameInMap(value="Message")
    @Validation(required=true)
    private String message;
    @Query
    @NameInMap(value="MessageType")
    @Validation(required=true)
    private String messageType;

    private CertificatePrivateKeySignRequest(Builder builder) {
        super((Request.Builder)builder);
        this.algorithm = builder.algorithm;
        this.certificateId = builder.certificateId;
        this.message = builder.message;
        this.messageType = builder.messageType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CertificatePrivateKeySignRequest create() {
        return CertificatePrivateKeySignRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getCertificateId() {
        return this.certificateId;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public static final class Builder
    extends Request.Builder<CertificatePrivateKeySignRequest, Builder> {
        private String algorithm;
        private String certificateId;
        private String message;
        private String messageType;

        private Builder() {
        }

        private Builder(CertificatePrivateKeySignRequest request) {
            super((Request)request);
            this.algorithm = request.algorithm;
            this.certificateId = request.certificateId;
            this.message = request.message;
            this.messageType = request.messageType;
        }

        public Builder algorithm(String algorithm) {
            this.putQueryParameter("Algorithm", algorithm);
            this.algorithm = algorithm;
            return this;
        }

        public Builder certificateId(String certificateId) {
            this.putQueryParameter("CertificateId", certificateId);
            this.certificateId = certificateId;
            return this;
        }

        public Builder message(String message) {
            this.putQueryParameter("Message", message);
            this.message = message;
            return this;
        }

        public Builder messageType(String messageType) {
            this.putQueryParameter("MessageType", messageType);
            this.messageType = messageType;
            return this;
        }

        public CertificatePrivateKeySignRequest build() {
            return new CertificatePrivateKeySignRequest(this);
        }
    }
}

